/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

import java.beans.IntrospectionException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.commons.BeanUtility;
import org.eclipse.scout.commons.beans.FastPropertyDescriptor;
import org.eclipse.scout.commons.beans.IPropertyFilter;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.table.ColumnSet;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.shared.data.basic.table.AbstractTableRowData;

public class TableRowDataMapper {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(TableRowDataMapper.class);
    private final Map<IColumn, FastPropertyDescriptor> m_propertyDescriptorByColumn = new HashMap<IColumn, FastPropertyDescriptor>();
    private final ColumnSet m_columnSet;

    public TableRowDataMapper(Class<? extends AbstractTableRowData> rowType, ColumnSet columnSet) throws ProcessingException {
        if (rowType == null) {
            throw new IllegalArgumentException("rowType must not be null");
        }
        if (columnSet == null) {
            throw new IllegalArgumentException("columnSet must not be null");
        }
        this.m_columnSet = columnSet;
        try {
            FastPropertyDescriptor[] props;
            FastPropertyDescriptor[] fastPropertyDescriptorArray = props = BeanUtility.getFastPropertyDescriptors(rowType, AbstractTableRowData.class, (IPropertyFilter)this.createPropertyFilter());
            int n = props.length;
            int n2 = 0;
            while (n2 < n) {
                FastPropertyDescriptor rowDataPropertyDesc = fastPropertyDescriptorArray[n2];
                IColumn column = this.findColumn(columnSet, rowDataPropertyDesc);
                if (column != null) {
                    this.m_propertyDescriptorByColumn.put(column, rowDataPropertyDesc);
                } else {
                    LOG.warn("No column found for property [" + rowDataPropertyDesc.getBeanClass().getName() + "#" + rowDataPropertyDesc.getName() + "]");
                }
                ++n2;
            }
        }
        catch (IntrospectionException e) {
            throw new ProcessingException("Could not determine property descriptors", (Throwable)e);
        }
    }

    protected IPropertyFilter createPropertyFilter() {
        return new TableRowDataPropertyFilter();
    }

    protected IColumn findColumn(ColumnSet columnset, FastPropertyDescriptor rowDataPropertyDesc) {
        String columnId = this.capitalize(rowDataPropertyDesc.getName());
        return columnset.getColumnById(columnId);
    }

    private String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
    }

    public void importTableRowData(ITableRow row, AbstractTableRowData rowData) throws ProcessingException {
        IColumn[] iColumnArray = this.m_columnSet.getColumns();
        int n = iColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            IColumn column = iColumnArray[n2];
            Object value = null;
            FastPropertyDescriptor propertyDesc = this.m_propertyDescriptorByColumn.get(column);
            if (propertyDesc != null) {
                try {
                    value = propertyDesc.getReadMethod().invoke((Object)rowData, new Object[0]);
                }
                catch (Throwable t) {
                    LOG.warn("Error reading row data property for column [" + column.getClass().getName() + "]", t);
                }
            } else {
                value = rowData.getCustomColumnValue(column.getColumnId());
            }
            column.setValue(row, value);
            ++n2;
        }
        row.setStatus(rowData.getRowState());
    }

    public void exportTableRowData(ITableRow row, AbstractTableRowData rowData) throws ProcessingException {
        IColumn[] iColumnArray = this.m_columnSet.getColumns();
        int n = iColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            IColumn column = iColumnArray[n2];
            Object value = column.getValue(row);
            FastPropertyDescriptor propertyDesc = this.m_propertyDescriptorByColumn.get(column);
            if (propertyDesc != null) {
                try {
                    propertyDesc.getWriteMethod().invoke((Object)rowData, value);
                }
                catch (Throwable t) {
                    LOG.warn("Error writing row data property for column [" + column.getClass().getName() + "]", t);
                }
            } else {
                rowData.setCustomColumnValue(column.getColumnId(), value);
            }
            ++n2;
        }
        rowData.setRowState(row.getStatus());
    }

    public static class TableRowDataPropertyFilter
    implements IPropertyFilter {
        public boolean accept(FastPropertyDescriptor descriptor) {
            Class propertyType = descriptor.getPropertyType();
            if (propertyType == null) {
                return false;
            }
            if (descriptor.getReadMethod() == null) {
                return false;
            }
            if (descriptor.getWriteMethod() == null) {
                return false;
            }
            if (!(propertyType.isPrimitive() || propertyType.isInterface() || Serializable.class.isAssignableFrom(propertyType))) {
                return false;
            }
            if ("rowState".equals(descriptor.getName())) {
                return false;
            }
            return !"customColumnValues".equals(descriptor.getName());
        }
    }
}

