/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractDecimalColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IBigDecimalColumn;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.bigdecimalfield.AbstractBigDecimalField;

public abstract class AbstractBigDecimalColumn
extends AbstractDecimalColumn<BigDecimal>
implements IBigDecimalColumn {
    @Override
    protected BigDecimal parseValueInternal(ITableRow row, Object rawValue) throws ProcessingException {
        BigDecimal validValue = null;
        if (rawValue == null) {
            validValue = null;
        } else if (rawValue instanceof BigDecimal) {
            validValue = (BigDecimal)rawValue;
        } else if (rawValue instanceof Long) {
            validValue = new BigDecimal(((Long)rawValue).toString());
        } else if (rawValue instanceof Double) {
            validValue = BigDecimal.valueOf((Double)rawValue);
        } else {
            throw new ProcessingException("invalid BigDecimal value in column '" + this.getClass().getSimpleName() + "': " + rawValue + " class=" + rawValue.getClass());
        }
        return validValue;
    }

    @Override
    protected IFormField prepareEditInternal(ITableRow row) throws ProcessingException {
        return super.prepareEditInternal(row);
    }

    protected AbstractBigDecimalField getEditorField() {
        return new AbstractBigDecimalField(){

            @Override
            protected void initConfig() {
                super.initConfig();
                this.propertySupport.putPropertiesMap(AbstractBigDecimalColumn.this.propertySupport.getPropertiesMap());
            }
        };
    }

    @Override
    protected void decorateCellInternal(Cell cell, ITableRow row) {
        super.decorateCellInternal(cell, row);
        if (cell.getValue() != null) {
            cell.setText(this.getNumberFormat().format(cell.getValue()));
        } else {
            cell.setText("");
        }
    }

    @Override
    public NumberFormat getNumberFormat() {
        if (super.getNumberFormat() == null) {
            NumberFormat fmt = this.isPercent() ? NumberFormat.getPercentInstance(LocaleThreadLocal.get()) : NumberFormat.getNumberInstance(LocaleThreadLocal.get());
            if (fmt instanceof DecimalFormat) {
                ((DecimalFormat)fmt).setMultiplier(this.getMultiplier());
                if (this.getFormat() != null) {
                    ((DecimalFormat)fmt).applyPattern(this.getFormat());
                } else {
                    fmt.setMinimumFractionDigits(this.getMinFractionDigits());
                    fmt.setMaximumFractionDigits(this.getMaxFractionDigits());
                    fmt.setGroupingUsed(this.isGroupingUsed());
                }
            } else {
                fmt.setMinimumFractionDigits(this.getMinFractionDigits());
                fmt.setMaximumFractionDigits(this.getMaxFractionDigits());
                fmt.setGroupingUsed(this.isGroupingUsed());
            }
            this.setNumberFormat(fmt);
        }
        return super.getNumberFormat();
    }
}

