/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractNumberColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.ILongColumn;
import org.eclipse.scout.rt.client.ui.form.fields.longfield.AbstractLongField;

public abstract class AbstractLongColumn
extends AbstractNumberColumn<Long>
implements ILongColumn {
    @ConfigProperty(value="LONG")
    @Order(value=160.0)
    @ConfigPropertyValue(value="null")
    protected Long getConfiguredMaxValue() {
        return null;
    }

    @ConfigProperty(value="LONG")
    @Order(value=170.0)
    @ConfigPropertyValue(value="null")
    protected Long getConfiguredMinValue() {
        return null;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setMaxValue(this.getConfiguredMaxValue());
        this.setMinValue(this.getConfiguredMinValue());
    }

    @Override
    protected Long parseValueInternal(ITableRow row, Object rawValue) throws ProcessingException {
        Long validValue = null;
        if (rawValue == null) {
            validValue = null;
        } else if (rawValue instanceof Long) {
            validValue = (Long)rawValue;
        } else if (rawValue instanceof Number) {
            validValue = ((Number)rawValue).longValue();
        } else {
            throw new ProcessingException("invalid Long value in column '" + this.getClass().getSimpleName() + "': " + rawValue + " class=" + rawValue.getClass());
        }
        return validValue;
    }

    protected AbstractLongField getEditorField() {
        return new AbstractLongField(){

            @Override
            protected void initConfig() {
                super.initConfig();
                this.propertySupport.putPropertiesMap(AbstractLongColumn.this.propertySupport.getPropertiesMap());
            }
        };
    }

    @Override
    protected void decorateCellInternal(Cell cell, ITableRow row) {
        super.decorateCellInternal(cell, row);
        if (cell.getValue() != null) {
            cell.setText(this.getNumberFormat().format((Long)cell.getValue()));
        } else {
            cell.setText("");
        }
    }

    @Override
    public NumberFormat getNumberFormat() {
        if (super.getNumberFormat() == null) {
            if (this.getFormat() != null) {
                DecimalFormat x = (DecimalFormat)DecimalFormat.getNumberInstance(LocaleThreadLocal.get());
                x.applyPattern(this.getFormat());
                x.setMinimumFractionDigits(0);
                x.setMaximumFractionDigits(0);
                this.setNumberFormat(x);
            } else {
                NumberFormat y = NumberFormat.getNumberInstance(LocaleThreadLocal.get());
                y.setMinimumFractionDigits(0);
                y.setMaximumFractionDigits(0);
                y.setGroupingUsed(this.isGroupingUsed());
                this.setNumberFormat(y);
            }
        }
        return super.getNumberFormat();
    }
}

