/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.filechooser.IFileChooser;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.PrintDevice;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBox;

public class DesktopEvent
extends EventObject {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_DESKTOP_CLOSED = 100;
    public static final int TYPE_OUTLINE_CHANGED = 200;
    public static final int TYPE_FORM_ADDED = 600;
    public static final int TYPE_FORM_REMOVED = 610;
    public static final int TYPE_FORM_ENSURE_VISIBLE = 620;
    public static final int TYPE_MESSAGE_BOX_ADDED = 700;
    public static final int TYPE_PRINT = 900;
    public static final int TYPE_PRINTED = 901;
    public static final int TYPE_FILE_CHOOSER_ADDED = 910;
    public static final int TYPE_OPEN_BROWSER_WINDOW = 920;
    public static final int TYPE_FIND_FOCUS_OWNER = 1000;
    public static final int TYPE_TRAY_POPUP = 1010;
    private final int m_type;
    private IOutline m_outline;
    private IForm m_form;
    private IFormField m_focusedField;
    private IMessageBox m_messageBox;
    private IFileChooser m_fileChooser;
    private String m_path;
    private PrintDevice m_printDevice;
    private Map<String, Object> m_printParameters;
    private List<IMenu> m_popupMenus;
    private File m_printedFile;

    public DesktopEvent(IDesktop source, int type) {
        super(source);
        this.m_type = type;
    }

    public DesktopEvent(IDesktop source, int type, File printedFile) {
        this(source, type);
        this.m_printedFile = printedFile;
    }

    public DesktopEvent(IDesktop source, int type, IForm form) {
        this(source, type);
        this.m_form = form;
    }

    public DesktopEvent(IDesktop source, int type, IMessageBox messageBox) {
        this(source, type);
        this.m_messageBox = messageBox;
    }

    public DesktopEvent(IDesktop source, int type, IOutline outline) {
        this(source, type);
        this.m_outline = outline;
    }

    public DesktopEvent(IDesktop source, int type, IFileChooser fc) {
        this(source, type);
        this.m_fileChooser = fc;
    }

    public DesktopEvent(IDesktop source, int type, String path) {
        this(source, type);
        this.m_path = path;
    }

    public DesktopEvent(IDesktop source, int type, PrintDevice printDevice, Map<String, Object> printParameters) {
        super(source);
        this.m_type = type;
        this.m_printDevice = printDevice;
        this.m_printParameters = printParameters;
    }

    public IDesktop getDesktop() {
        return (IDesktop)this.getSource();
    }

    public int getType() {
        return this.m_type;
    }

    public IForm getForm() {
        return this.m_form;
    }

    public ISearchForm getSearchForm() {
        return (ISearchForm)this.m_form;
    }

    public IForm getDetailForm() {
        return this.m_form;
    }

    public IFileChooser getFileChooser() {
        return this.m_fileChooser;
    }

    public String getPath() {
        return this.m_path;
    }

    public IMessageBox getMessageBox() {
        return this.m_messageBox;
    }

    public IOutline getOutline() {
        return this.m_outline;
    }

    public IFormField getFocusedField() {
        return this.m_focusedField;
    }

    public void setFocusedField(IFormField f) {
        this.m_focusedField = f;
    }

    public PrintDevice getPrintDevice() {
        return this.m_printDevice;
    }

    public File getPrintedFile() {
        return this.m_printedFile;
    }

    public void addPopupMenu(IMenu menu) {
        if (menu != null) {
            if (this.m_popupMenus == null) {
                this.m_popupMenus = new ArrayList<IMenu>();
            }
            this.m_popupMenus.add(menu);
        }
    }

    public void addPopupMenus(IMenu[] menus) {
        if (menus != null) {
            if (this.m_popupMenus == null) {
                this.m_popupMenus = new ArrayList<IMenu>();
            }
            this.m_popupMenus.addAll(Arrays.asList(menus));
        }
    }

    public IMenu[] getPopupMenus() {
        if (this.m_popupMenus != null) {
            return this.m_popupMenus.toArray(new IMenu[0]);
        }
        return new IMenu[0];
    }

    public int getPopupMenuCount() {
        if (this.m_popupMenus != null) {
            return this.m_popupMenus.size();
        }
        return 0;
    }

    public Map<String, Object> getPrintParameters() {
        return new HashMap<String, Object>(this.m_printParameters);
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(String.valueOf(this.getClass().getSimpleName()) + "[");
        try {
            Field[] f = this.getClass().getDeclaredFields();
            int i = 0;
            while (i < f.length) {
                if (Modifier.isPublic(f[i].getModifiers()) && Modifier.isStatic(f[i].getModifiers()) && f[i].getName().startsWith("TYPE_") && ((Number)f[i].get(null)).intValue() == this.m_type) {
                    buf.append(f[i].getName());
                    break;
                }
                ++i;
            }
        }
        catch (Throwable t) {
            buf.append("#" + this.m_type);
        }
        if (this.m_form != null) {
            buf.append(" " + this.m_form.getTitle());
        }
        if (this.m_messageBox != null) {
            buf.append(" " + this.m_messageBox.getTitle());
        }
        if (this.m_outline != null) {
            buf.append(" " + this.m_outline.getRootNode().getCell().getText());
        }
        buf.append("]");
        return buf.toString();
    }
}

