/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.security.Permission;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.BeanUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.StoppableThread;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.FormData;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.beans.AbstractPropertyObserver;
import org.eclipse.scout.commons.beans.FastPropertyDescriptor;
import org.eclipse.scout.commons.beans.IPropertyFilter;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.VetoException;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.xmlparser.SimpleXmlElement;
import org.eclipse.scout.rt.client.BlockingCondition;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.services.common.search.ISearchFilterService;
import org.eclipse.scout.rt.client.ui.DataChangeListener;
import org.eclipse.scout.rt.client.ui.IEventHistory;
import org.eclipse.scout.rt.client.ui.WeakDataChangeListener;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.basic.filechooser.FileChooser;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.DefaultFormEventHistory;
import org.eclipse.scout.rt.client.ui.form.DefaultFormFieldInjection;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormFieldInjectionThreadLocal;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.FormUtility;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.IFormFieldVisitor;
import org.eclipse.scout.rt.client.ui.form.IFormHandler;
import org.eclipse.scout.rt.client.ui.form.IFormUIFacade;
import org.eclipse.scout.rt.client.ui.form.NullFormHandler;
import org.eclipse.scout.rt.client.ui.form.PrintDevice;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormFieldFilter;
import org.eclipse.scout.rt.client.ui.form.fields.IValidateContentDescriptor;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.client.ui.form.fields.button.ButtonEvent;
import org.eclipse.scout.rt.client.ui.form.fields.button.ButtonListener;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;
import org.eclipse.scout.rt.client.ui.form.fields.wrappedform.IWrappedFormField;
import org.eclipse.scout.rt.client.ui.form.internal.FindFieldByFormDataIdVisitor;
import org.eclipse.scout.rt.client.ui.form.internal.FindFieldByXmlIdsVisitor;
import org.eclipse.scout.rt.client.ui.form.internal.FormDataPropertyFilter;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBox;
import org.eclipse.scout.rt.client.ui.profiler.DesktopProfiler;
import org.eclipse.scout.rt.client.ui.wizard.IWizard;
import org.eclipse.scout.rt.client.ui.wizard.IWizardStep;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.TEXTS;
import org.eclipse.scout.rt.shared.data.form.AbstractFormData;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractValueFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.tablefield.AbstractTableFieldData;
import org.eclipse.scout.rt.shared.data.form.properties.AbstractPropertyData;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;
import org.eclipse.scout.rt.shared.services.common.security.IAccessControlService;
import org.eclipse.scout.service.SERVICES;

@FormData(value=AbstractFormData.class, sdkCommand=FormData.SdkCommand.USE)
public abstract class AbstractForm
extends AbstractPropertyObserver
implements IForm {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractForm.class);
    private boolean m_initialized;
    private final EventListenerList m_listenerList = new EventListenerList();
    private IFormUIFacade m_uiFacade;
    private IWizardStep m_wizardStep;
    private boolean m_modal;
    private boolean m_cacheBounds;
    private boolean m_askIfNeedSave;
    private boolean m_buttonsArmed;
    private boolean m_closeTimerArmed;
    private boolean m_formStored;
    private boolean m_formLoading;
    private final BlockingCondition m_blockingCondition;
    private boolean m_autoRegisterInDesktopOnStart;
    private int m_displayHint;
    private String m_displayViewId;
    private boolean m_displayHintLocked = false;
    private int m_closeType = 0;
    private String m_basicTitle;
    private String m_subTitle;
    private String m_cancelVerificationText;
    private File m_lastXmlFileForStorage;
    private IGroupBox m_mainBox;
    private IWrappedFormField m_wrappedFormField;
    private P_SystemButtonListener m_systemButtonListener;
    private IFormHandler m_handler;
    private boolean m_enabledGranted;
    private boolean m_visibleGranted;
    private SearchFilter m_searchFilter;
    private IValidateContentDescriptor m_currentValidateContentDescriptor;
    private P_CloseTimer m_scoutCloseTimer;
    private HashMap<String, P_Timer> m_scoutTimerMap;
    private String m_iconId;
    private DataChangeListener m_internalDataChangeListener;
    private IEventHistory<FormEvent> m_eventHistory;
    private Map<Class<?>, Class<? extends IFormField>> m_fieldReplacements;

    public AbstractForm() throws ProcessingException {
        this(true);
    }

    public AbstractForm(boolean callInitializer) throws ProcessingException {
        if (DesktopProfiler.getInstance().isEnabled()) {
            DesktopProfiler.getInstance().registerForm(this);
        }
        this.m_eventHistory = this.createEventHistory();
        this.m_enabledGranted = true;
        this.m_visibleGranted = true;
        this.m_formLoading = true;
        this.m_blockingCondition = new BlockingCondition(false);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    protected void callInitializer() throws ProcessingException {
        if (!this.m_initialized) {
            this.initConfig();
            this.postInitConfig();
            this.m_initialized = true;
        }
    }

    @ConfigProperty(value="TEXT")
    @Order(value=10.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredTitle() {
        return null;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=11.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredSubTitle() {
        return null;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=20.0)
    @ConfigPropertyValue(value="0")
    protected int getConfiguredCloseTimer() {
        return 0;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=40.0)
    @ConfigPropertyValue(value="0")
    protected int getConfiguredCustomTimer() {
        return 0;
    }

    @ConfigProperty(value="DOC")
    @Order(value=60.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredDoc() {
        return null;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=90.0)
    @ConfigPropertyValue(value="ScoutTexts.get(\"FormSaveChangesQuestion\")")
    protected String getConfiguredCancelVerificationText() {
        return ScoutTexts.get((String)"FormSaveChangesQuestion", (String[])new String[0]);
    }

    @ConfigProperty(value="FORM_DISPLAY_HINT")
    @Order(value=100.0)
    @ConfigPropertyValue(value="DISPLAY_HINT_DIALOG")
    protected int getConfiguredDisplayHint() {
        return 0;
    }

    @ConfigProperty(value="FORM_VIEW_ID")
    @Order(value=105.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredDisplayViewId() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=108.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredMinimizeEnabled() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=109.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredMaximizeEnabled() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=110.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredMinimized() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=112.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredMaximized() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=120.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredModal() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=140.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredCacheBounds() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=150.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredAskIfNeedSave() {
        return true;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=160.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredIconId() {
        return null;
    }

    @Override
    public Object computeExclusiveKey() throws ProcessingException {
        return null;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execInitForm() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=11.0)
    protected void execFormActivated() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=13.0)
    protected void execDataChanged(Object ... dataTypes) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=13.0)
    protected boolean execCheckFields() throws ProcessingException {
        return true;
    }

    @ConfigOperation
    @Order(value=14.0)
    protected boolean execValidate() throws ProcessingException {
        return true;
    }

    @ConfigOperation
    @Order(value=16.0)
    protected void execStored() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=17.0)
    protected void execOnVetoException(VetoException e, int code) throws ProcessingException {
        throw e;
    }

    @ConfigOperation
    @Order(value=18.0)
    protected void execOnCloseRequest(boolean kill, HashSet<Integer> enabledButtonSystemTypes) throws ProcessingException {
        if (enabledButtonSystemTypes.contains(2)) {
            this.doClose();
        } else if (enabledButtonSystemTypes.contains(1)) {
            this.doCancel();
        } else if (!this.isAskIfNeedSave()) {
            this.doClose();
        } else {
            LOG.info("Trying to close a form (" + this.getClass().getName() + " - " + this.getTitle() + ") with no enabled close button! override getConfiguredAskIfNeedSave() to false to make this form is unsaveable.");
        }
    }

    @ConfigOperation
    @Order(value=19.0)
    protected void execDisposeForm() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execCloseTimer() throws ProcessingException {
        this.doClose();
    }

    @ConfigOperation
    @Order(value=30.0)
    protected void execInactivityTimer() throws ProcessingException {
        this.doClose();
    }

    @ConfigOperation
    @Order(value=40.0)
    protected void execTimer(String timerId) throws ProcessingException {
        LOG.info("execTimer " + timerId);
    }

    @ConfigOperation
    @Order(value=50.0)
    protected void execAddSearchTerms(SearchFilter search) {
    }

    private Class<? extends IKeyStroke>[] getConfiguredKeyStrokes() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClasses((Class[])dca, IKeyStroke.class);
    }

    private Class<? extends IGroupBox> getConfiguredMainBox() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClassIgnoringInjectFieldAnnotation((Class[])dca, IGroupBox.class);
    }

    private Class<? extends IFormField>[] getConfiguredInjectedFields() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClassesWithInjectFieldAnnotation((Class[])dca, IFormField.class);
    }

    protected void initConfig() throws ProcessingException {
        IGroupBox rootBox;
        block12: {
            this.m_uiFacade = new P_UIFacade();
            this.m_scoutTimerMap = new HashMap();
            this.m_autoRegisterInDesktopOnStart = true;
            Class<? extends IFormField>[] fieldArray = this.getConfiguredInjectedFields();
            DefaultFormFieldInjection injectedFields = null;
            rootBox = this.getRootGroupBox();
            try {
                if (fieldArray.length > 0) {
                    injectedFields = new DefaultFormFieldInjection(this);
                    injectedFields.addFields(fieldArray);
                    FormFieldInjectionThreadLocal.push(injectedFields);
                }
                if (rootBox != null) break block12;
                Class<? extends IGroupBox> mainBoxClass = this.getConfiguredMainBox();
                try {
                    this.m_mainBox = (IGroupBox)ConfigurationUtility.newInnerInstance((Object)this, mainBoxClass);
                }
                catch (Throwable t) {
                    throw new ProcessingException("mainBox: " + (mainBoxClass == null ? "not defined." : mainBoxClass.getName()), t);
                }
                rootBox = this.getRootGroupBox();
            }
            finally {
                if (injectedFields != null) {
                    this.m_fieldReplacements = injectedFields.getReplacementMapping();
                    FormFieldInjectionThreadLocal.pop(injectedFields);
                }
            }
        }
        rootBox.setFormInternal(this);
        rootBox.setMainBox(true);
        rootBox.updateKeyStrokes();
        if (this.getConfiguredCloseTimer() > 0) {
            this.setCloseTimer(this.getConfiguredCloseTimer());
        }
        if (this.getConfiguredCustomTimer() > 0) {
            this.setTimer("custom", this.getConfiguredCustomTimer());
        }
        this.setModal(this.getConfiguredModal());
        this.setDisplayHint(this.getConfiguredDisplayHint());
        this.setDisplayViewId(this.getConfiguredDisplayViewId());
        if (this.getConfiguredCancelVerificationText() != null) {
            this.setCancelVerificationText(this.getConfiguredCancelVerificationText());
        }
        if (this.getConfiguredTitle() != null) {
            this.setTitle(this.getConfiguredTitle());
        }
        if (this.getConfiguredSubTitle() != null) {
            this.setSubTitle(this.getConfiguredSubTitle());
        }
        this.setMinimizeEnabled(this.getConfiguredMinimizeEnabled());
        this.setMaximizeEnabled(this.getConfiguredMaximizeEnabled());
        this.setMinimized(this.getConfiguredMinimized());
        this.setMaximized(this.getConfiguredMaximized());
        this.setCacheBounds(this.getConfiguredCacheBounds());
        this.setAskIfNeedSave(this.getConfiguredAskIfNeedSave());
        this.setIconId(this.getConfiguredIconId());
        this.m_systemButtonListener = new P_SystemButtonListener();
        IFormFieldVisitor v2 = new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                if (field instanceof IButton && ((IButton)field).getSystemType() != 0) {
                    ((IButton)field).addButtonListener(AbstractForm.this.m_systemButtonListener);
                }
                return true;
            }
        };
        this.visitFields(v2);
        this.getRootGroupBox().addPropertyChangeListener(new P_MainBoxPropertyChangeProxy());
        this.setButtonsArmed(true);
    }

    @Override
    public void setEnabledPermission(Permission p) {
        boolean b = p != null ? ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).checkPermission(p) : true;
        this.setEnabledGranted(b);
    }

    @Override
    public boolean isEnabledGranted() {
        return this.m_enabledGranted;
    }

    @Override
    public void setEnabledGranted(boolean b) {
        this.m_enabledGranted = b;
        IGroupBox box = this.getRootGroupBox();
        if (box != null) {
            box.setEnabledGranted(b);
        }
    }

    @Override
    public void setVisiblePermission(Permission p) {
        boolean b = p != null ? ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).checkPermission(p) : true;
        this.setVisibleGranted(b);
    }

    @Override
    public boolean isVisibleGranted() {
        return this.m_visibleGranted;
    }

    @Override
    public void setVisibleGranted(boolean b) {
        this.m_visibleGranted = b;
        IGroupBox box = this.getRootGroupBox();
        if (box != null) {
            box.setVisibleGranted(b);
        }
    }

    @Override
    public String getIconId() {
        return this.propertySupport.getPropertyString("iconId");
    }

    @Override
    public void setIconId(String iconId) {
        this.propertySupport.setPropertyString("iconId", iconId);
    }

    @Override
    public String getPerspectiveId() {
        return this.propertySupport.getPropertyString("perspectiveId");
    }

    @Override
    public void setPerspectiveId(String perspectiveId) {
        this.propertySupport.setPropertyString("perspectiveId", perspectiveId);
    }

    public void registerDataChangeListener(Object ... dataTypes) {
        IDesktop desktop;
        if (this.m_internalDataChangeListener == null) {
            this.m_internalDataChangeListener = new WeakDataChangeListener(){

                @Override
                public void dataChanged(Object ... innerDataTypes) throws ProcessingException {
                    AbstractForm.this.execDataChanged(innerDataTypes);
                }
            };
        }
        if ((desktop = this.getDesktop()) == null) {
            desktop = ClientSyncJob.getCurrentSession().getVirtualDesktop();
        }
        desktop.addDataChangeListener(this.m_internalDataChangeListener, dataTypes);
    }

    public void unregisterDataChangeListener(Object ... dataTypes) {
        if (this.m_internalDataChangeListener != null) {
            this.getDesktop().removeDataChangeListener(this.m_internalDataChangeListener, dataTypes);
        }
    }

    protected IForm startInternalExclusive(IFormHandler handler) throws ProcessingException {
        if (this.m_blockingCondition.isBlocking()) {
            throw new ProcessingException("The form " + this.getFormId() + " has already been started");
        }
        IForm[] iFormArray = this.getDesktop().getSimilarViewForms(this);
        int n = iFormArray.length;
        int n2 = 0;
        while (n2 < n) {
            IForm simCandidate = iFormArray[n2];
            if (handler != null && simCandidate.getHandler() != null && handler.getClass().getName() == simCandidate.getHandler().getClass().getName() && simCandidate.getHandler().isOpenExclusive() && handler.isOpenExclusive()) {
                this.getDesktop().ensureVisible(simCandidate);
                return simCandidate;
            }
            ++n2;
        }
        return this.startInternal(handler);
    }

    protected IForm startInternal(IFormHandler handler) throws ProcessingException {
        IDesktop desktop;
        if (this.m_blockingCondition.isBlocking()) {
            throw new ProcessingException("The form " + this.getFormId() + " has already been started");
        }
        this.setHandler(handler);
        this.m_closeType = 0;
        this.m_displayHintLocked = true;
        this.m_blockingCondition.setBlocking(true);
        try {
            if (!this.getRootGroupBox().isVisible()) {
                this.disposeFormInternal();
                return this;
            }
            this.initForm();
            if (!this.getRootGroupBox().isVisible()) {
                this.disposeFormInternal();
                return this;
            }
            this.loadStateInternal();
            if (!this.isFormOpen()) {
                this.disposeFormInternal();
                return this;
            }
            if (!this.getRootGroupBox().isVisible()) {
                this.disposeFormInternal();
                return this;
            }
            if (this.getHandler().isGuiLess()) {
                this.storeStateInternal();
                this.markSaved();
                this.doFinally();
                this.disposeFormInternal();
                return this;
            }
        }
        catch (ProcessingException e) {
            e.addContextMessage(this.getClass().getSimpleName());
            this.disposeFormInternal();
            if (e instanceof VetoException) {
                this.execOnVetoException((VetoException)((Object)e), e.getStatus().getCode());
            }
            throw e;
        }
        catch (Throwable t) {
            this.disposeFormInternal();
            throw new ProcessingException("failed showing " + this.getTitle(), t);
        }
        this.setButtonsArmed(true);
        this.setCloseTimerArmed(true);
        if (this.isAutoAddRemoveOnDesktop() && (desktop = this.getDesktop()) != null) {
            desktop.addForm(this);
        }
        return this;
    }

    @Override
    public void startWizardStep(IWizardStep wizardStep, Class<? extends IFormHandler> handlerType) throws ProcessingException {
        this.setAutoAddRemoveOnDesktop(false);
        IFormHandler formHandler = null;
        if (handlerType != null) {
            try {
                formHandler = (IFormHandler)ConfigurationUtility.newInnerInstance((Object)this, handlerType);
            }
            catch (Exception e) {
                throw new ProcessingException(handlerType + " is not an internal form handler", (Throwable)e);
            }
        }
        this.m_wizardStep = wizardStep;
        this.setModal(false);
        this.setAskIfNeedSave(false);
        IFormField[] iFormFieldArray = this.getRootGroupBox().getFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IButton b;
            IFormField f = iFormFieldArray[n2];
            if (f instanceof IButton && (b = (IButton)f).getSystemType() != 0) {
                b.setVisible(false);
                b.setVisibleGranted(false);
            }
            ++n2;
        }
        this.startInternal(formHandler);
    }

    @Override
    public void waitFor() throws ProcessingException {
        IDesktop desktop = ClientSyncJob.getCurrentSession().getDesktop();
        if (desktop == null || !desktop.isOpened()) {
            throw new ProcessingException("Cannot wait for " + this.getClass().getName() + ". There is no desktop or the desktop has not yet been opened in the ui", null, 69218);
        }
        try {
            this.m_blockingCondition.waitFor();
        }
        catch (InterruptedException e) {
            throw new ProcessingException(ScoutTexts.get((String)"UserInterrupted", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void exportFormData(AbstractFormData target) throws ProcessingException {
        Map properties = BeanUtility.getProperties((Object)this, AbstractForm.class, (IPropertyFilter)new FormDataPropertyFilter());
        BeanUtility.setProperties((Object)target, (Map)properties, (boolean)false, null);
        Map breathFirstMap = target.getAllFieldsRec();
        for (Map targetMap : breathFirstMap.values()) {
            for (Map.Entry e : targetMap.entrySet()) {
                String fieldQId = (String)e.getKey();
                AbstractFormFieldData data = (AbstractFormFieldData)e.getValue();
                FindFieldByFormDataIdVisitor v = new FindFieldByFormDataIdVisitor(fieldQId, this);
                this.visitFields(v);
                IFormField f = v.getField();
                if (f != null) {
                    properties = BeanUtility.getProperties((Object)f, AbstractFormField.class, (IPropertyFilter)new FormDataPropertyFilter());
                    BeanUtility.setProperties((Object)data, (Map)properties, (boolean)false, null);
                    f.exportFormFieldData(data);
                    continue;
                }
                LOG.warn("cannot find field data for '" + fieldQId + " in form " + this.getClass().getName() + "'");
            }
        }
    }

    @Override
    public void importFormData(AbstractFormData source) throws ProcessingException {
        this.importFormData(source, false, null);
    }

    @Override
    public void importFormData(AbstractFormData source, boolean valueChangeTriggersEnabled) throws ProcessingException {
        this.importFormData(source, valueChangeTriggersEnabled, null);
    }

    @Override
    public void importFormData(AbstractFormData source, boolean valueChangeTriggersEnabled, IPropertyFilter filter) throws ProcessingException {
        this.importFormData(source, valueChangeTriggersEnabled, filter, null);
    }

    @Override
    public void importFormData(AbstractFormData source, boolean valueChangeTriggersEnabled, IPropertyFilter filter, IFormFieldFilter formFieldFilter) throws ProcessingException {
        AbstractPropertyData pd;
        Iterator it;
        Class stopClass;
        AbstractFormFieldData data;
        if (filter == null) {
            filter = new FormDataPropertyFilter();
        }
        Map properties = BeanUtility.getProperties((Object)source, AbstractFormData.class, (IPropertyFilter)filter);
        Iterator it2 = properties.keySet().iterator();
        while (it2.hasNext()) {
            AbstractPropertyData pd2 = source.getPropertyById((String)it2.next());
            if (pd2 == null || pd2.isValueSet()) continue;
            it2.remove();
        }
        BeanUtility.setProperties((Object)this, (Map)properties, (boolean)false, null);
        LinkedList<IFormField> masterList = new LinkedList<IFormField>();
        LinkedList<IFormField> slaveList = new LinkedList<IFormField>();
        HashMap<IFormField, AbstractFormFieldData> dataMap = new HashMap<IFormField, AbstractFormFieldData>();
        Map breathFirstMap = source.getAllFieldsRec();
        for (Map sourceMap : breathFirstMap.values()) {
            for (Map.Entry e : sourceMap.entrySet()) {
                String fieldQId = (String)e.getKey();
                AbstractFormFieldData data2 = (AbstractFormFieldData)e.getValue();
                FindFieldByFormDataIdVisitor v = new FindFieldByFormDataIdVisitor(fieldQId, this);
                this.visitFields(v);
                IFormField f = v.getField();
                if (formFieldFilter != null && !formFieldFilter.accept(f)) continue;
                if (f != null) {
                    dataMap.put(f, data2);
                    if (f.getMasterField() != null) {
                        int index = slaveList.indexOf(f.getMasterField());
                        if (index >= 0) {
                            slaveList.add(index + 1, f);
                            continue;
                        }
                        slaveList.add(0, f);
                        continue;
                    }
                    masterList.add(f);
                    continue;
                }
                LOG.warn("cannot find field data for '" + fieldQId + " in form " + this.getClass().getName() + "'");
            }
        }
        for (IFormField f : masterList) {
            data = (AbstractFormFieldData)dataMap.get(f);
            stopClass = data instanceof AbstractTableFieldData ? AbstractTableFieldData.class : (data instanceof AbstractValueFieldData ? AbstractValueFieldData.class : AbstractFormFieldData.class);
            properties = BeanUtility.getProperties((Object)data, stopClass, (IPropertyFilter)filter);
            it = properties.keySet().iterator();
            while (it.hasNext()) {
                pd = data.getPropertyById((String)it.next());
                if (pd == null || pd.isValueSet()) continue;
                it.remove();
            }
            BeanUtility.setProperties((Object)f, (Map)properties, (boolean)false, null);
            f.importFormFieldData(data, valueChangeTriggersEnabled);
        }
        for (IFormField f : slaveList) {
            data = (AbstractFormFieldData)dataMap.get(f);
            stopClass = data instanceof AbstractTableFieldData ? AbstractTableFieldData.class : (data instanceof AbstractValueFieldData ? AbstractValueFieldData.class : AbstractFormFieldData.class);
            properties = BeanUtility.getProperties((Object)data, stopClass, (IPropertyFilter)filter);
            it = properties.keySet().iterator();
            while (it.hasNext()) {
                pd = data.getPropertyById((String)it.next());
                if (pd == null || pd.isValueSet()) continue;
                it.remove();
            }
            BeanUtility.setProperties((Object)f, (Map)properties, (boolean)false, null);
            f.importFormFieldData(data, valueChangeTriggersEnabled);
        }
    }

    public static String parseFormId(String className) {
        String s = className;
        int i = Math.max(s.lastIndexOf(36), s.lastIndexOf(46));
        s = s.substring(i + 1);
        return s;
    }

    @Override
    public String getFormId() {
        return AbstractForm.parseFormId(this.getClass().getName());
    }

    @Override
    public IFormHandler getHandler() {
        return this.m_handler;
    }

    @Override
    public void setHandler(IFormHandler handler) {
        if (handler != this.m_handler) {
            if (this.m_handler != null) {
                this.m_handler.setFormInternal(null);
            }
            if (handler == null) {
                handler = new NullFormHandler();
            }
            this.m_handler = handler;
            this.m_handler.setFormInternal(this);
        }
    }

    @Override
    public IWizard getWizard() {
        return this.getWizardStep() != null ? this.getWizardStep().getWizard() : null;
    }

    @Override
    public IWizardStep getWizardStep() {
        return this.m_wizardStep;
    }

    @Override
    public IFormField getFocusOwner() {
        IFormField field;
        if (this.getDesktop() != null && (field = this.getDesktop().getFocusOwner()) != null) {
            IForm form = field.getForm();
            while (form != null) {
                if (form == this) {
                    return field;
                }
                form = form.getOuterForm();
            }
        }
        return null;
    }

    @Override
    public IFormField[] getAllFields() {
        P_AbstractCollectingFieldVisitor<IFormField> v = new P_AbstractCollectingFieldVisitor<IFormField>(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                this.collect(field);
                return true;
            }
        };
        this.visitFields(v);
        return v.getCollection().toArray(new IFormField[0]);
    }

    @Override
    public boolean visitFields(IFormFieldVisitor visitor) {
        return this.getRootGroupBox().visitFields(visitor, 0);
    }

    public IDesktop getDesktop() {
        return ClientSyncJob.getCurrentSession().getDesktop();
    }

    @Override
    public final SearchFilter getSearchFilter() {
        if (this.m_searchFilter == null) {
            this.resetSearchFilter();
        }
        return this.m_searchFilter;
    }

    @Override
    public final void setSearchFilter(SearchFilter searchFilter) {
        this.m_searchFilter = searchFilter;
    }

    public void rebuildSearchFilter() {
        this.resetSearchFilter();
    }

    @Override
    public void resetSearchFilter() {
        if (this.m_searchFilter == null) {
            ISearchFilterService sfs = (ISearchFilterService)SERVICES.getService(ISearchFilterService.class);
            SearchFilter filter = sfs != null ? sfs.createNewSearchFilter() : new SearchFilter();
            this.m_searchFilter = filter;
        }
        try {
            this.execResetSearchFilter(this.m_searchFilter);
        }
        catch (ProcessingException e) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
        catch (Throwable t) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
        }
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execResetSearchFilter(SearchFilter searchFilter) throws ProcessingException {
        searchFilter.clear();
        this.getRootGroupBox().applySearch(searchFilter);
        this.execAddSearchTerms(searchFilter);
        try {
            AbstractFormData data = this.execCreateFormData();
            if (data != null) {
                this.exportFormData(data);
                this.getSearchFilter().setFormData(data);
            }
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ProcessingException("Create form data", t);
        }
    }

    @ConfigOperation
    @Order(value=11.0)
    protected AbstractFormData execCreateFormData() throws ProcessingException {
        return null;
    }

    @Override
    public boolean isFormStored() {
        return this.m_formStored;
    }

    @Override
    public void setFormStored(boolean b) {
        this.m_formStored = b;
    }

    @Override
    public boolean isFormLoading() {
        return this.m_formLoading;
    }

    private void setFormLoading(boolean b) {
        this.m_formLoading = b;
    }

    @Override
    public IGroupBox getRootGroupBox() {
        return this.m_mainBox;
    }

    @Override
    public IForm getOuterForm() {
        return this.m_wrappedFormField != null ? this.m_wrappedFormField.getForm() : null;
    }

    @Override
    public IWrappedFormField getOuterFormField() {
        return this.m_wrappedFormField;
    }

    @Override
    public void setWrapperFieldInternal(IWrappedFormField w) {
        this.m_wrappedFormField = w;
    }

    @Override
    public IFormField getFieldById(String id) {
        return this.getRootGroupBox().getFieldById(id);
    }

    @Override
    public <T extends IFormField> T getFieldById(String id, Class<T> type) {
        return this.getRootGroupBox().getFieldById(id, type);
    }

    @Override
    public <T extends IFormField> T getFieldByClass(Class<T> c) {
        return this.getRootGroupBox().getFieldByClass(c);
    }

    protected void postInitConfig() throws ProcessingException {
        FormUtility.postInitConfig(this);
        FormUtility.rebuildFieldGrid(this, true);
    }

    @Override
    public void initForm() throws ProcessingException {
        this.initFormInternal();
        FormUtility.initFormFields(this);
        this.execInitForm();
    }

    protected void initFormInternal() throws ProcessingException {
    }

    @Override
    public int getCloseSystemType() {
        return this.m_closeType;
    }

    @Override
    public void setCloseSystemType(int type) {
        this.m_closeType = type;
    }

    protected void loadStateInternal() throws ProcessingException {
        this.fireFormLoadBefore();
        if (!this.isFormOpen()) {
            return;
        }
        this.getHandler().onLoad();
        if (!this.isFormOpen()) {
            return;
        }
        this.fireFormLoadAfter();
        if (!this.isFormOpen()) {
            return;
        }
        this.markSaved();
        this.setFormLoading(false);
        this.getHandler().onPostLoad();
        if (!this.isFormOpen()) {
            return;
        }
        if (this.getHandler().isGuiLess()) {
            this.touch();
        }
        this.fireFormLoadComplete();
    }

    protected void storeStateInternal() throws ProcessingException {
        if (!this.m_blockingCondition.isBlocking()) {
            String msg = TEXTS.get((String)"FormDisposedMessage", (String[])new String[]{this.getTitle()});
            LOG.error(msg);
            throw new VetoException(msg);
        }
        this.fireFormStoreBefore();
        this.m_formStored = true;
        try {
            this.rebuildSearchFilter();
            this.m_searchFilter.setCompleted(true);
            this.getHandler().onStore();
            this.execStored();
        }
        catch (ProcessingException e) {
            if (this.m_searchFilter != null) {
                this.m_searchFilter.clear();
            }
            this.m_formStored = false;
            this.throwVetoExceptionInternal(e);
            this.m_formStored = true;
        }
        catch (Throwable t) {
            if (this.m_searchFilter != null) {
                this.m_searchFilter.clear();
            }
            throw new ProcessingException("form: " + this.getTitle(), t);
        }
        this.fireFormStoreAfter();
    }

    protected void discardStateInternal() throws ProcessingException {
        this.fireFormDiscarded();
        this.getHandler().onDiscard();
    }

    @Override
    public void setCloseTimer(int seconds) {
        if (seconds > 0) {
            this.setCloseTimerArmed(true);
            this.m_scoutCloseTimer = new P_CloseTimer(seconds);
            this.m_scoutCloseTimer.start();
        } else {
            this.removeCloseTimer();
        }
    }

    protected void throwVetoExceptionInternal(ProcessingException e) throws ProcessingException {
        if (e instanceof VetoException && !e.isConsumed()) {
            this.execOnVetoException((VetoException)((Object)e), e.getStatus().getCode());
            e.consume();
        }
        throw e;
    }

    @Override
    public void removeCloseTimer() {
        this.setCloseTimerArmed(false);
        this.m_scoutCloseTimer = null;
        this.setSubTitle(null);
    }

    @Override
    public void validateForm() throws ProcessingException {
        this.m_currentValidateContentDescriptor = null;
        if (!this.execCheckFields()) {
            VetoException veto = new VetoException("Validate " + this.getClass().getSimpleName());
            veto.consume();
            throw veto;
        }
        if (!this.getHandler().onCheckFields()) {
            VetoException veto = new VetoException("Validate " + this.getClass().getSimpleName());
            veto.consume();
            throw veto;
        }
        final ArrayList invalidTexts = new ArrayList();
        final ArrayList mandatoryTexts = new ArrayList();
        P_AbstractCollectingFieldVisitor<IValidateContentDescriptor> v = new P_AbstractCollectingFieldVisitor<IValidateContentDescriptor>(){

            @Override
            public boolean visitField(IFormField f, int level, int fieldIndex) {
                IValidateContentDescriptor desc = f.validateContent();
                if (desc != null) {
                    if (desc.getErrorStatus() != null) {
                        invalidTexts.add(String.valueOf(desc.getDisplayText()) + ": " + desc.getErrorStatus().getMessage());
                    } else {
                        mandatoryTexts.add(desc.getDisplayText());
                    }
                    if (this.getCollectionCount() == 0) {
                        this.collect(desc);
                    }
                }
                return true;
            }
        };
        this.visitFields(v);
        if (v.getCollectionCount() > 0) {
            Iterator it;
            IValidateContentDescriptor firstProblem = (IValidateContentDescriptor)v.getCollection().get(0);
            if (LOG.isInfoEnabled()) {
                LOG.info("there are fields with errors");
            }
            StringBuffer buf = new StringBuffer();
            if (mandatoryTexts.size() > 0) {
                buf.append(String.valueOf(ScoutTexts.get((String)"FormEmptyMandatoryFieldsMessage", (String[])new String[0])) + "\n\n");
                it = mandatoryTexts.iterator();
                while (it.hasNext()) {
                    buf.append("- " + it.next() + "\n");
                }
                buf.append("\n");
            }
            if (invalidTexts.size() > 0) {
                buf.append(String.valueOf(ScoutTexts.get((String)"FormInvalidFieldsMessage", (String[])new String[0])) + "\n\n");
                it = invalidTexts.iterator();
                while (it.hasNext()) {
                    buf.append("- " + it.next() + "\n");
                }
            }
            String introText = ScoutTexts.get((String)"FormIncompleteIntro", (String[])new String[0]);
            this.m_currentValidateContentDescriptor = firstProblem;
            VetoException veto = new VetoException(introText, buf.toString());
            throw veto;
        }
        if (!this.execValidate()) {
            VetoException veto = new VetoException("Validate " + this.getClass().getSimpleName());
            veto.consume();
            throw veto;
        }
        if (!this.getHandler().onValidate()) {
            VetoException veto = new VetoException("Validate " + this.getClass().getSimpleName());
            veto.consume();
            throw veto;
        }
    }

    @Override
    public void setTimer(String timerId, int seconds) {
        this.removeTimer(timerId);
        if (seconds > 0) {
            P_Timer tim = new P_Timer(seconds, timerId);
            this.m_scoutTimerMap.put(timerId, tim);
            tim.start();
        }
    }

    @Override
    public void removeTimer(String timerId) {
        P_Timer tim = this.m_scoutTimerMap.remove(timerId);
        if (tim != null) {
            tim.setStopSignal();
        }
    }

    @Override
    public void doClose() throws ProcessingException {
        if (!this.isFormOpen()) {
            return;
        }
        this.m_closeType = 2;
        this.discardStateInternal();
        this.doFinally();
        this.disposeFormInternal();
    }

    @Override
    public void doCancel() throws ProcessingException {
        if (!this.isFormOpen()) {
            return;
        }
        this.m_closeType = 1;
        try {
            this.checkSaveNeeded();
            P_AbstractCollectingFieldVisitor<IFormField> collector = new P_AbstractCollectingFieldVisitor<IFormField>(){

                @Override
                public boolean visitField(IFormField field, int level, int fieldIndex) {
                    if (field.isSaveNeeded()) {
                        this.collect(field);
                        return false;
                    }
                    return true;
                }
            };
            this.visitFields(collector);
            if (collector.getCollectionCount() > 0 && this.isAskIfNeedSave()) {
                MessageBox messageBox = new MessageBox(null, this.getCancelVerificationText(), null, TEXTS.get((String)"YesButton"), TEXTS.get((String)"NoButton"), TEXTS.get((String)"CancelButton"));
                messageBox.setSeverity(1);
                int result = messageBox.startMessageBox();
                if (result == 0) {
                    this.doOk();
                    return;
                }
                if (result == 1) {
                    this.doClose();
                    return;
                }
                VetoException e = new VetoException(ScoutTexts.get((String)"UserCancelledOperation", (String[])new String[0]));
                e.consume();
                throw e;
            }
            this.discardStateInternal();
            this.doFinally();
            this.disposeFormInternal();
        }
        catch (ProcessingException e) {
            this.m_closeType = 0;
            throw e;
        }
    }

    @Override
    public void doReset() {
        this.setFormLoading(true);
        P_AbstractCollectingFieldVisitor v = new P_AbstractCollectingFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                if (field instanceof IValueField) {
                    IValueField f = (IValueField)field;
                    f.resetValue();
                } else if (field instanceof IComposerField) {
                    IComposerField f = (IComposerField)field;
                    f.resetValue();
                }
                return true;
            }
        };
        this.visitFields(v);
        try {
            this.initForm();
            this.loadStateInternal();
        }
        catch (ProcessingException e) {
            e.addContextMessage(String.valueOf(ScoutTexts.get((String)"FormReset", (String[])new String[0])) + " " + this.getTitle());
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
    }

    @Override
    public void doOk() throws ProcessingException {
        if (!this.isFormOpen()) {
            return;
        }
        try {
            this.m_closeType = 0;
            this.checkSaveNeeded();
            this.validateForm();
            this.m_closeType = 3;
            if (this.isSaveNeeded()) {
                this.storeStateInternal();
                this.markSaved();
            }
            this.doFinally();
            this.disposeFormInternal();
        }
        catch (ProcessingException e) {
            this.m_closeType = 0;
            this.throwVetoExceptionInternal(e);
        }
    }

    @Override
    public void doSaveWithoutMarkerChange() throws ProcessingException {
        if (!this.isFormOpen()) {
            return;
        }
        try {
            this.m_closeType = 0;
            this.checkSaveNeeded();
            this.validateForm();
            this.m_closeType = 6;
            this.storeStateInternal();
        }
        catch (ProcessingException e) {
            this.m_closeType = 0;
            this.throwVetoExceptionInternal(e);
        }
    }

    @Override
    public void doSave() throws ProcessingException {
        if (!this.isFormOpen()) {
            return;
        }
        try {
            this.m_closeType = 0;
            this.checkSaveNeeded();
            this.validateForm();
            this.m_closeType = 5;
            if (this.isSaveNeeded()) {
                this.storeStateInternal();
                this.markSaved();
            }
        }
        catch (ProcessingException e) {
            this.m_closeType = 0;
            this.throwVetoExceptionInternal(e);
        }
    }

    @Override
    public void setAllEnabled(final boolean b) {
        P_AbstractCollectingFieldVisitor v = new P_AbstractCollectingFieldVisitor(){

            @Override
            public boolean visitField(IFormField f, int level, int fieldIndex) {
                boolean filteredB = b;
                f.setEnabled(filteredB);
                return true;
            }
        };
        this.visitFields(v);
    }

    @Override
    public void doFinally() {
        try {
            this.getHandler().onFinally();
        }
        catch (ProcessingException se) {
            se.addContextMessage(String.valueOf(ScoutTexts.get((String)"FormFinally", (String[])new String[0])) + " " + this.getTitle());
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(se);
        }
        catch (Throwable t) {
            ProcessingException e = new ProcessingException(String.valueOf(ScoutTexts.get((String)"FormFinally", (String[])new String[0])) + " " + this.getTitle(), t);
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
    }

    @Override
    public String getCancelVerificationText() {
        return this.m_cancelVerificationText;
    }

    @Override
    public void setCancelVerificationText(String text) {
        this.m_cancelVerificationText = text;
    }

    @Override
    public List<? extends IFormField> getInvalidFields() {
        P_AbstractCollectingFieldVisitor<IFormField> v = new P_AbstractCollectingFieldVisitor<IFormField>(){

            @Override
            public boolean visitField(IFormField f, int level, int fieldIndex) {
                if (!f.isContentValid()) {
                    this.collect(f);
                }
                return true;
            }
        };
        this.visitFields(v);
        return v.getCollection();
    }

    @Override
    public final void checkSaveNeeded() {
        P_AbstractCollectingFieldVisitor<IFormField> v = new P_AbstractCollectingFieldVisitor<IFormField>(){

            @Override
            public boolean visitField(IFormField f, int level, int fieldIndex) {
                if (f instanceof IFormField) {
                    f.checkSaveNeeded();
                }
                return true;
            }
        };
        this.visitFields(v);
    }

    private boolean checkForVerifyingFields() {
        P_AbstractCollectingFieldVisitor v = new P_AbstractCollectingFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                IValueField f;
                return !(field instanceof IValueField) || !(f = (IValueField)field).isValueChanging() && !f.isValueParsing();
            }
        };
        return this.visitFields(v);
    }

    /*
     * Unable to fully structure code
     */
    private void closeFormInternal(boolean kill) {
        if (this.isFormOpen()) {
            try {
                enabledSystemTypes = new HashSet<Integer>();
                enabledSystemButtons = new HashSet<E>();
                v = new IFormFieldVisitor(){

                    @Override
                    public boolean visitField(IFormField field, int level, int fieldIndex) {
                        IButton b;
                        if (field instanceof IButton && (b = (IButton)field).isEnabled() && b.isVisible() && b.isEnabledProcessingButton()) {
                            enabledSystemTypes.add(b.getSystemType());
                            enabledSystemButtons.add(b);
                        }
                        return true;
                    }
                };
                try {
                    this.visitFields(v);
                    for (IButton b : enabledSystemButtons) {
                        b.setEnabledProcessingButton(false);
                    }
                    this.execOnCloseRequest(kill, enabledSystemTypes);
                }
                finally {
                    ** for (b : enabledSystemButtons)
                }
lbl-1000:
                // 1 sources

                {
                    b.setEnabledProcessingButton(true);
                    continue;
lbl18:
                    // 1 sources

                }
            }
            catch (ProcessingException se) {
                se.addContextMessage(String.valueOf(ScoutTexts.get((String)"FormClosing", (String[])new String[0])) + " " + this.getTitle());
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(se);
            }
            catch (Throwable t) {
                e = new ProcessingException(String.valueOf(ScoutTexts.get((String)"FormClosing", (String[])new String[0])) + " " + this.getTitle(), t);
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }
    }

    @Override
    public void touch() {
        this.getRootGroupBox().touch();
    }

    @Override
    public boolean isSaveNeeded() {
        return this.getRootGroupBox().isSaveNeeded();
    }

    @Override
    public void markSaved() {
        this.getRootGroupBox().markSaved();
    }

    @Override
    public boolean isEmpty() {
        return this.getRootGroupBox().isEmpty();
    }

    protected void disposeFormInternal() {
        if (!this.isFormOpen()) {
            return;
        }
        try {
            this.setButtonsArmed(false);
            this.setCloseTimerArmed(false);
            this.m_scoutCloseTimer = null;
            Iterator<P_Timer> it = this.m_scoutTimerMap.values().iterator();
            while (it.hasNext()) {
                it.next().setStopSignal();
            }
            this.m_scoutTimerMap.clear();
            this.m_displayHintLocked = false;
            this.m_formLoading = true;
        }
        catch (Throwable t) {
            LOG.warn("Form " + this.getClass().getName(), t);
        }
        FormUtility.disposeFormFields(this);
        try {
            this.execDisposeForm();
        }
        catch (Throwable t) {
            LOG.warn("Form " + this.getClass().getName(), t);
        }
        try {
            IDesktop desktop;
            if (this.isAutoAddRemoveOnDesktop() && (desktop = this.getDesktop()) != null) {
                desktop.removeForm(this);
            }
        }
        finally {
            this.m_blockingCondition.release();
            this.fireFormClosed();
        }
    }

    @Override
    public boolean isShowing() {
        IDesktop desktop = this.getDesktop();
        if (desktop != null) {
            return desktop.isShowing(this);
        }
        return false;
    }

    @Override
    public boolean isFormClosed() {
        return !this.isFormOpen();
    }

    @Override
    public boolean isFormOpen() {
        return this.m_blockingCondition.isBlocking();
    }

    @Override
    public Object getCustomProperty(String propName) {
        return this.getProperty(propName);
    }

    @Override
    public void setCustomProperty(String propName, Object o) {
        this.setProperty(propName, o);
    }

    @Override
    public Object getProperty(String name) {
        return this.propertySupport.getProperty(name);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.propertySupport.setProperty(name, value);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.propertySupport.hasProperty(name);
    }

    @Override
    public void setXML(String xml) throws ProcessingException {
        if (xml == null) {
            return;
        }
        SimpleXmlElement root = new SimpleXmlElement();
        try {
            root.parseString(xml);
        }
        catch (Throwable t) {
            throw new ProcessingException("Loading xml", t);
        }
        this.loadXML(root);
    }

    @Override
    public String getXML(String encoding) throws ProcessingException {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            SimpleXmlElement e = this.storeXML();
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.writeDocument((OutputStream)bo, null, encoding);
            return new String(bo.toByteArray(), Charset.forName(encoding));
        }
        catch (Throwable e) {
            if (e instanceof ProcessingException) {
                throw (ProcessingException)e;
            }
            throw new ProcessingException("form : " + this.getTitle() + ", encoding: " + encoding, e);
        }
    }

    @Override
    public SimpleXmlElement storeXML() throws ProcessingException {
        SimpleXmlElement root = new SimpleXmlElement("form-state");
        this.storeXML(root);
        return root;
    }

    @Override
    public void storeXML(SimpleXmlElement root) throws ProcessingException {
        root.setAttribute("formId", (Object)this.getFormId());
        root.setAttribute("formQname", (Object)this.getClass().getName());
        SimpleXmlElement xProps = new SimpleXmlElement("properties");
        root.addChild(xProps);
        IPropertyFilter filter = new IPropertyFilter(){

            public boolean accept(FastPropertyDescriptor descriptor) {
                if (descriptor.getPropertyType().isInstance(IFormField.class)) {
                    return false;
                }
                if (!descriptor.getPropertyType().isPrimitive() && !Serializable.class.isAssignableFrom(descriptor.getPropertyType())) {
                    return false;
                }
                return descriptor.getReadMethod() != null && descriptor.getWriteMethod() != null;
            }
        };
        Map props = BeanUtility.getProperties((Object)this, AbstractForm.class, (IPropertyFilter)filter);
        for (Map.Entry entry : props.entrySet()) {
            try {
                SimpleXmlElement xProp = new SimpleXmlElement("property");
                xProps.addChild(xProp);
                xProp.setAttribute("name", entry.getKey());
                xProp.setObjectAttribute("value", entry.getValue());
            }
            catch (Exception e) {
                throw new ProcessingException("property " + entry.getKey() + " with value " + entry.getValue(), (Throwable)e);
            }
        }
        final SimpleXmlElement xFields = new SimpleXmlElement("fields");
        root.addChild(xFields);
        final Holder exceptionHolder = new Holder(ProcessingException.class);
        P_AbstractCollectingFieldVisitor v = new P_AbstractCollectingFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                SimpleXmlElement xField = new SimpleXmlElement("field");
                try {
                    field.storeXML(xField);
                    xFields.addChild(xField);
                }
                catch (ProcessingException e) {
                    exceptionHolder.setValue((Object)e);
                    return false;
                }
                return true;
            }
        };
        this.visitFields(v);
        if (exceptionHolder.getValue() != null) {
            throw (ProcessingException)((Object)exceptionHolder.getValue());
        }
    }

    @Override
    public void loadXML(SimpleXmlElement root) throws ProcessingException {
        String xmlId;
        String formId = this.getFormId();
        if (!formId.equals(xmlId = root.getStringAttribute("formId", ""))) {
            throw new ProcessingException("xml id=" + xmlId + " does not match form id=" + formId);
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        SimpleXmlElement xProps = root.getChild("properties");
        if (xProps != null) {
            for (SimpleXmlElement xProp : xProps.getChildren("property")) {
                String name = xProp.getStringAttribute("name");
                try {
                    Object value = xProp.getObjectAttribute("value", null);
                    props.put(name, value);
                }
                catch (Exception e) {
                    LOG.warn("property " + name, (Throwable)e);
                }
            }
        }
        BeanUtility.setProperties((Object)this, props, (boolean)true, null);
        SimpleXmlElement xFields = root.getChild("fields");
        if (xFields != null) {
            for (SimpleXmlElement xField : xFields.getChildren("field")) {
                LinkedList<String> xmlFieldIds = new LinkedList<String>();
                for (SimpleXmlElement element : xField.getChildren("enclosingField")) {
                    xmlFieldIds.add(element.getStringAttribute("fieldId"));
                }
                xmlFieldIds.add(xField.getStringAttribute("fieldId"));
                FindFieldByXmlIdsVisitor v = new FindFieldByXmlIdsVisitor(xmlFieldIds.toArray(new String[xmlFieldIds.size()]));
                this.visitFields(v);
                IFormField f = v.getField();
                if (f == null) continue;
                f.loadXML(xField);
            }
        }
        this.getRootGroupBox().visitFields(new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                ITabBox tabBox;
                IGroupBox selbox;
                if (field instanceof ITabBox && ((selbox = (tabBox = (ITabBox)field).getSelectedTab()) == null || !selbox.isSaveNeeded())) {
                    IGroupBox[] iGroupBoxArray = tabBox.getGroupBoxes();
                    int n = iGroupBoxArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IGroupBox g = iGroupBoxArray[n2];
                        if (g.isSaveNeeded()) {
                            tabBox.setSelectedTab(g);
                            break;
                        }
                        ++n2;
                    }
                }
                return true;
            }
        }, 0);
    }

    @Override
    public void doExportXml(boolean saveAs) {
        while (true) {
            File path = this.m_lastXmlFileForStorage;
            if (saveAs || path == null) {
                File[] a;
                File dir = this.m_lastXmlFileForStorage;
                if (dir != null) {
                    dir = dir.getParentFile();
                }
                if ((a = new FileChooser(dir, new String[]{"xml"}, false).startChooser()).length == 0) break;
                path = a[0];
            }
            try {
                this.storeXML().writeDocument((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(path), "UTF-8"), null, "UTF-8");
                if (path == null) break;
                this.m_lastXmlFileForStorage = path;
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException(String.valueOf(ScoutTexts.get((String)"FormExportXml", (String[])new String[0])) + " " + this.getTitle(), t));
                saveAs = true;
                continue;
            }
            break;
        }
    }

    @Override
    public void doImportXml() {
        File[] a;
        File dir = this.m_lastXmlFileForStorage;
        if (dir != null) {
            dir = dir.getParentFile();
        }
        if ((a = new FileChooser(dir, new String[]{"xml"}, true).startChooser()).length == 1) {
            File newPath = a[0];
            String text = null;
            try {
                SimpleXmlElement e = new SimpleXmlElement();
                e.parseStream((InputStream)new FileInputStream(newPath));
                this.m_lastXmlFileForStorage = newPath;
                this.loadXML(e);
            }
            catch (Exception e) {
                LOG.warn("loading: " + newPath + " text: " + text + " Exception: " + e);
                new MessageBox(null, TEXTS.get((String)"LoadFormXmlFailedText"), null, TEXTS.get((String)"OkButton"), null, null).startMessageBox();
                this.m_lastXmlFileForStorage = null;
            }
        }
    }

    @Override
    public void printForm(PrintDevice device, Map<String, Object> parameters) {
        try {
            this.firePrint(null, device, parameters);
        }
        catch (ProcessingException e) {
            e.addContextMessage(String.valueOf(ScoutTexts.get((String)"FormPrint", (String[])new String[0])) + " " + this.getTitle());
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
    }

    @Override
    public void printField(IFormField field, PrintDevice device, Map<String, Object> parameters) {
        try {
            this.firePrint(field, device, parameters);
        }
        catch (ProcessingException e) {
            e.addContextMessage(String.valueOf(ScoutTexts.get((String)"FormPrint", (String[])new String[0])) + " " + (field != null ? field.getLabel() : this.getTitle()));
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
    }

    @Override
    public void activate() {
        if (this.getDesktop() != null) {
            this.getDesktop().ensureVisible(this);
        }
    }

    @Override
    public void requestFocus(IFormField f) {
        if (f == null || f.getForm() != this) {
            return;
        }
        this.fireRequestFocus(f);
    }

    public Map<Class<?>, Class<? extends IFormField>> getFormFieldReplacementsInternal() {
        return this.m_fieldReplacements;
    }

    public void registerFormFieldReplacementsInternal(Map<Class<?>, Class<? extends IFormField>> replacements) {
        if (replacements == null || replacements.isEmpty()) {
            return;
        }
        if (this.m_fieldReplacements == null) {
            this.m_fieldReplacements = new HashMap();
        }
        this.m_fieldReplacements.putAll(replacements);
    }

    @Override
    public void addFormListener(FormListener listener) {
        this.m_listenerList.add(FormListener.class, (EventListener)listener);
    }

    @Override
    public void removeFormListener(FormListener listener) {
        this.m_listenerList.remove(FormListener.class, (EventListener)listener);
    }

    protected IEventHistory<FormEvent> createEventHistory() {
        return new DefaultFormEventHistory(5000L);
    }

    @Override
    public IEventHistory<FormEvent> getEventHistory() {
        return this.m_eventHistory;
    }

    private void fireFormLoadBefore() throws ProcessingException {
        this.fireFormEvent(new FormEvent(this, 1000));
    }

    private void fireFormLoadAfter() throws ProcessingException {
        this.fireFormEvent(new FormEvent(this, 1010));
    }

    private void fireFormLoadComplete() throws ProcessingException {
        this.fireFormEvent(new FormEvent(this, 1020));
    }

    private void fireFormStoreBefore() throws ProcessingException {
        this.fireFormEvent(new FormEvent(this, 2010));
    }

    private void fireFormDiscarded() {
        try {
            this.fireFormEvent(new FormEvent(this, 3000));
        }
        catch (ProcessingException e) {
            e.addContextMessage(String.valueOf(ScoutTexts.get((String)"FormFireDiscarded", (String[])new String[0])) + " " + this.getTitle());
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
    }

    private void fireFormStoreAfter() throws ProcessingException {
        this.fireFormEvent(new FormEvent(this, 2020));
    }

    private void firePrint(IFormField root, PrintDevice device, Map<String, Object> parameters) throws ProcessingException {
        this.fireFormEvent(new FormEvent(this, 4000, root, device, parameters));
    }

    private void fireFormPrinted(File outputFile) {
        try {
            this.fireFormEvent(new FormEvent((IForm)this, 4010, outputFile));
        }
        catch (ProcessingException e) {
            e.addContextMessage(String.valueOf(ScoutTexts.get((String)"FormFirePrinted", (String[])new String[0])) + " " + this.getTitle());
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
    }

    private void fireFormActivated() {
        try {
            this.execFormActivated();
            this.fireFormEvent(new FormEvent(this, 510));
        }
        catch (ProcessingException e) {
            e.addContextMessage(String.valueOf(ScoutTexts.get((String)"FormFireActivated", (String[])new String[0])) + " " + this.getTitle());
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
    }

    private void fireFormClosed() {
        try {
            this.fireFormEvent(new FormEvent(this, 3010));
        }
        catch (ProcessingException e) {
            e.addContextMessage(String.valueOf(ScoutTexts.get((String)"FormFireClosed", (String[])new String[0])) + " " + this.getTitle());
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
    }

    private void fireFormEvent(FormEvent e) throws ProcessingException {
        IEventHistory<FormEvent> h;
        EventListener[] listeners = this.m_listenerList.getListeners(FormListener.class);
        if (listeners != null && listeners.length > 0) {
            ProcessingException pe = null;
            int i = 0;
            while (i < listeners.length) {
                block8: {
                    try {
                        ((FormListener)listeners[i]).formChanged(e);
                    }
                    catch (ProcessingException ex) {
                        if (pe == null) {
                            pe = ex;
                        }
                    }
                    catch (Throwable t) {
                        if (pe != null) break block8;
                        pe = new ProcessingException("Unexpected", t);
                    }
                }
                ++i;
            }
            if (pe != null) {
                throw pe;
            }
        }
        if ((h = this.getEventHistory()) != null) {
            h.notifyEvent(e);
        }
    }

    @Override
    public void structureChanged(IFormField causingField) {
        this.fireFormStructureChanged(causingField);
    }

    private void fireFormStructureChanged(IFormField causingField) {
        try {
            this.fireFormEvent(new FormEvent((IForm)this, 5000, causingField));
        }
        catch (ProcessingException e) {
            e.addContextMessage(String.valueOf(ScoutTexts.get((String)"FormFireStructureChanged", (String[])new String[0])) + " " + this.getTitle());
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
    }

    private void fireFormToFront() {
        try {
            this.fireFormEvent(new FormEvent(this, 6000));
        }
        catch (ProcessingException e) {
            e.addContextMessage(String.valueOf(ScoutTexts.get((String)"FormFireToFront", (String[])new String[0])) + " " + this.getTitle());
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
    }

    private void fireFormToBack() {
        try {
            this.fireFormEvent(new FormEvent(this, 6010));
        }
        catch (ProcessingException e) {
            e.addContextMessage(String.valueOf(ScoutTexts.get((String)"FormFireToBack", (String[])new String[0])) + " " + this.getTitle());
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
    }

    private void fireRequestFocus(IFormField f) {
        try {
            this.fireFormEvent(new FormEvent((IForm)this, 6020, f));
        }
        catch (ProcessingException e) {
            e.addContextMessage(String.valueOf(ScoutTexts.get((String)"FormFireRequestFocus", (String[])new String[0])) + " " + this.getTitle() + " for " + f.getLabel());
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
    }

    @Override
    public String getBasicTitle() {
        return this.m_basicTitle;
    }

    @Override
    public void setBasicTitle(String basicTitle) {
        this.m_basicTitle = basicTitle;
        this.composeTitle();
    }

    @Override
    public String getSubTitle() {
        return this.m_subTitle;
    }

    @Override
    public void setSubTitle(String subTitle) {
        this.m_subTitle = subTitle;
        this.composeTitle();
    }

    @Override
    public void setTitle(String s) {
        this.m_basicTitle = s;
        this.m_subTitle = null;
        this.composeTitle();
    }

    private void composeTitle() {
        String sub;
        StringBuffer buf = new StringBuffer();
        String basic = this.getBasicTitle();
        if (basic != null) {
            if (buf.length() > 0) {
                buf.append(" - ");
            }
            buf.append(basic);
        }
        if ((sub = this.getSubTitle()) != null) {
            if (buf.length() > 0) {
                buf.append(" - ");
            }
            buf.append(sub);
        }
        this.propertySupport.setPropertyString("title", buf.toString());
    }

    @Override
    public String getTitle() {
        return this.propertySupport.getPropertyString("title");
    }

    @Override
    public boolean isMaximizeEnabled() {
        return this.propertySupport.getPropertyBool("maximizeEnabled");
    }

    @Override
    public void setMaximizeEnabled(boolean b) {
        this.propertySupport.setPropertyBool("maximizeEnabled", b);
    }

    @Override
    public boolean isMinimizeEnabled() {
        return this.propertySupport.getPropertyBool("minimizeEnabled");
    }

    @Override
    public void setMinimizeEnabled(boolean b) {
        this.propertySupport.setPropertyBool("minimizeEnabled", b);
    }

    @Override
    public boolean isMaximized() {
        return this.propertySupport.getPropertyBool("maximized");
    }

    @Override
    public void setMaximized(boolean b) {
        if (this.isMaximizeEnabled()) {
            if (b) {
                this.propertySupport.setPropertyBool("minimized", false);
            }
            this.propertySupport.setPropertyAlwaysFire("maximized", (Object)b);
        }
    }

    @Override
    public boolean isMinimized() {
        return this.propertySupport.getPropertyBool("minimized");
    }

    @Override
    public void setMinimized(boolean b) {
        if (this.isMinimizeEnabled()) {
            if (b) {
                this.propertySupport.setPropertyBool("maximized", false);
            }
            this.propertySupport.setPropertyAlwaysFire("minimized", (Object)b);
        }
    }

    @Override
    public boolean isAutoAddRemoveOnDesktop() {
        return this.m_autoRegisterInDesktopOnStart;
    }

    @Override
    public void setAutoAddRemoveOnDesktop(boolean b) {
        this.m_autoRegisterInDesktopOnStart = b;
    }

    @Override
    public boolean isModal() {
        return this.m_modal;
    }

    @Override
    public void setModal(boolean b) {
        if (b) {
            switch (this.getDisplayHint()) {
                case 0: 
                case 12: {
                    this.m_modal = b;
                    break;
                }
                default: {
                    LOG.warn("cannot set property 'modal' to true with current display hint type");
                    break;
                }
            }
        } else {
            this.m_modal = b;
        }
    }

    @Override
    public void setCacheBounds(boolean cacheBounds) {
        this.m_cacheBounds = cacheBounds;
    }

    @Override
    public boolean isCacheBounds() {
        return this.m_cacheBounds;
    }

    @Override
    public String computeCacheBoundsKey() {
        return this.getClass().getName();
    }

    @Override
    public int getDisplayHint() {
        return this.m_displayHint;
    }

    @Override
    public void setDisplayHint(int i) {
        switch (i) {
            case 0: {
                this.m_displayHint = i;
                break;
            }
            case 10: {
                this.m_displayHint = i;
                this.setModal(false);
                break;
            }
            case 12: {
                this.m_displayHint = i;
                break;
            }
            case 20: {
                this.m_displayHint = i;
                this.setModal(false);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid displayHint " + i);
            }
        }
    }

    @Override
    public String getDisplayViewId() {
        return this.m_displayViewId;
    }

    @Override
    public void setDisplayViewId(String viewId) {
        this.m_displayViewId = viewId;
    }

    @Override
    public boolean isAskIfNeedSave() {
        return this.m_askIfNeedSave;
    }

    @Override
    public void setAskIfNeedSave(boolean b) {
        this.m_askIfNeedSave = b;
    }

    @Override
    public void toFront() {
        this.fireFormToFront();
    }

    @Override
    public void toBack() {
        this.fireFormToBack();
    }

    @Override
    public boolean isButtonsArmed() {
        return this.m_buttonsArmed;
    }

    @Override
    public void setButtonsArmed(boolean b) {
        this.m_buttonsArmed = b;
    }

    @Override
    public boolean isCloseTimerArmed() {
        return this.m_closeTimerArmed;
    }

    @Override
    public void setCloseTimerArmed(boolean b) {
        this.m_closeTimerArmed = b;
    }

    public String toString() {
        return "Form " + this.getFormId();
    }

    @Override
    public IFormUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    protected void handleSystemButtonEventInternal(ButtonEvent e) {
        switch (e.getType()) {
            case 1: {
                this.setCloseTimerArmed(false);
                if (!this.isButtonsArmed() || !this.checkForVerifyingFields()) break;
                try {
                    IButton src = (IButton)e.getSource();
                    switch (src.getSystemType()) {
                        case 1: {
                            this.doCancel();
                            break;
                        }
                        case 2: {
                            this.doClose();
                            break;
                        }
                        case 3: {
                            this.doOk();
                            break;
                        }
                        case 4: {
                            this.doReset();
                            break;
                        }
                        case 5: {
                            this.doSave();
                            break;
                        }
                        case 6: {
                            this.doSaveWithoutMarkerChange();
                        }
                    }
                }
                catch (ProcessingException se) {
                    se.addContextMessage(String.valueOf(ScoutTexts.get((String)"FormButtonClicked", (String[])new String[0])) + " " + this.getTitle() + "." + e.getButton().getLabel());
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(se);
                }
                if (this.m_currentValidateContentDescriptor == null) break;
                this.m_currentValidateContentDescriptor.activateProblemLocation();
                this.m_currentValidateContentDescriptor = null;
            }
        }
    }

    private static abstract class P_AbstractCollectingFieldVisitor<T>
    implements IFormFieldVisitor {
        private final ArrayList<T> m_list = new ArrayList();

        private P_AbstractCollectingFieldVisitor() {
        }

        public void collect(T o) {
            this.m_list.add(o);
        }

        public int getCollectionCount() {
            return this.m_list.size();
        }

        public List<T> getCollection() {
            return this.m_list;
        }
    }

    private class P_CloseTimer
    extends StoppableThread {
        private long m_seconds;
        private final IClientSession m_session;

        public P_CloseTimer(long seconds) {
            this.setName("IForm.P_CloseTimer");
            this.setDaemon(true);
            this.m_seconds = seconds;
            this.m_session = ClientSyncJob.getCurrentSession();
        }

        public void run() {
            while (this == AbstractForm.this.m_scoutCloseTimer && this.m_seconds > 0L && AbstractForm.this.isCloseTimerArmed()) {
                new ClientSyncJob("Form close countdown", this.m_session){

                    @Override
                    protected void runVoid(IProgressMonitor monitor) throws Throwable {
                        AbstractForm.this.setSubTitle("" + P_CloseTimer.this.m_seconds);
                    }
                }.schedule();
                try {
                    P_CloseTimer.sleep((long)1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                --this.m_seconds;
            }
            if (this == AbstractForm.this.m_scoutCloseTimer) {
                new ClientSyncJob("Form close timer", this.m_session){

                    @Override
                    protected void runVoid(IProgressMonitor monitor) throws Throwable {
                        try {
                            if (AbstractForm.this.isCloseTimerArmed()) {
                                AbstractForm.this.execCloseTimer();
                            } else {
                                AbstractForm.this.setSubTitle(null);
                            }
                        }
                        catch (ProcessingException se) {
                            se.addContextMessage(String.valueOf(ScoutTexts.get((String)"FormCloseTimerActivated", (String[])new String[0])) + " " + AbstractForm.this.getTitle());
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(se);
                        }
                    }
                }.schedule();
            }
        }
    }

    private class P_MainBoxPropertyChangeProxy
    implements PropertyChangeListener {
        private P_MainBoxPropertyChangeProxy() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("saveNeeded".equals(e.getPropertyName())) {
                AbstractForm.this.propertySupport.firePropertyChange("saveNeeded", e.getOldValue(), e.getNewValue());
            } else if ("empty".equals(e.getPropertyName())) {
                AbstractForm.this.propertySupport.firePropertyChange("empty", e.getOldValue(), e.getNewValue());
            }
        }
    }

    private class P_SystemButtonListener
    implements ButtonListener {
        private P_SystemButtonListener() {
        }

        @Override
        public void buttonChanged(ButtonEvent e) {
            if (AbstractForm.this.m_systemButtonListener != this) {
                ((IButton)e.getSource()).removeButtonListener(this);
                return;
            }
            AbstractForm.this.handleSystemButtonEventInternal(e);
        }
    }

    private class P_Timer
    extends StoppableThread {
        private final long m_intervalMillis;
        private final String m_timerId;
        private boolean m_execPending = false;
        private final IClientSession m_session;

        public P_Timer(long seconds, String timerId) {
            this.setDaemon(true);
            this.m_intervalMillis = seconds * 1000L;
            this.m_timerId = timerId;
            this.m_session = ClientSyncJob.getCurrentSession();
        }

        public void run() {
            long next = (System.currentTimeMillis() + 999L) / 1000L * 1000L + this.m_intervalMillis;
            while (AbstractForm.this.m_scoutTimerMap != null && !this.isStopSignal()) {
                try {
                    P_Timer.sleep((long)250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.m_execPending && !this.isStopSignal() && next < System.currentTimeMillis()) {
                    this.m_execPending = true;
                    new ClientSyncJob("Form timer", this.m_session){

                        @Override
                        protected void runVoid(IProgressMonitor monitor) throws Throwable {
                            try {
                                try {
                                    if (LOG.isInfoEnabled()) {
                                        LOG.info("timer " + P_Timer.this.m_timerId);
                                    }
                                    AbstractForm.this.execTimer(P_Timer.this.m_timerId);
                                }
                                catch (ProcessingException se) {
                                    se.addContextMessage(String.valueOf(ScoutTexts.get((String)"FormTimerActivated", (String[])new String[0])) + " " + AbstractForm.this.getTitle() + "." + P_Timer.this.m_timerId);
                                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(se);
                                    P_Timer.this.m_execPending = false;
                                }
                            }
                            finally {
                                P_Timer.this.m_execPending = false;
                            }
                        }
                    }.schedule();
                }
                while (next < System.currentTimeMillis()) {
                    next += this.m_intervalMillis;
                }
            }
        }
    }

    private class P_UIFacade
    implements IFormUIFacade {
        private P_UIFacade() {
        }

        @Override
        public void fireFormActivatedFromUI() {
            AbstractForm.this.fireFormActivated();
        }

        @Override
        public void fireFormClosingFromUI() {
            if (!AbstractForm.this.checkForVerifyingFields()) {
                return;
            }
            AbstractForm.this.closeFormInternal(false);
        }

        @Override
        public void fireFormKilledFromUI() {
            AbstractForm.this.closeFormInternal(true);
        }

        @Override
        public void fireFormPrintedFromUI(File outputFile) {
            AbstractForm.this.fireFormPrinted(outputFile);
        }
    }
}

