/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields;

import java.io.IOException;
import java.util.EventListener;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.VerboseUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.FormData;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.VetoException;
import org.eclipse.scout.commons.holders.IHolder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.xmlparser.SimpleXmlElement;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.client.ui.form.fields.MasterListener;
import org.eclipse.scout.rt.client.ui.form.fields.ParsingFailedStatus;
import org.eclipse.scout.rt.client.ui.form.fields.ValidationFailedStatus;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractValueFieldData;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

@FormData(value=AbstractValueFieldData.class, defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.CREATE, sdkCommand=FormData.SdkCommand.USE, genericOrdinal=0)
public abstract class AbstractValueField<T>
extends AbstractFormField
implements IValueField<T> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractValueField.class);
    private int m_valueChanging;
    private int m_valueParsing;
    private int m_valueValidating;
    private T m_initValue;
    private boolean m_autoDisplayText;
    private EventListenerList m_listeningSlaves;

    public AbstractValueField() {
        this(true);
    }

    public AbstractValueField(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=200.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredAutoDisplayText() {
        return true;
    }

    @Override
    protected void initConfig() {
        this.m_listeningSlaves = new EventListenerList();
        super.initConfig();
        this.setAutoDisplayText(this.getConfiguredAutoDisplayText());
    }

    @Override
    public void exportFormFieldData(AbstractFormFieldData target) throws ProcessingException {
        AbstractValueFieldData v = (AbstractValueFieldData)target;
        v.setValue(this.getValue());
    }

    @Override
    public void importFormFieldData(AbstractFormFieldData source, boolean valueChangeTriggersEnabled) {
        AbstractValueFieldData v = (AbstractValueFieldData)source;
        if (v.isValueSet()) {
            try {
                Class<T> castType;
                Object o;
                if (!valueChangeTriggersEnabled) {
                    this.setValueChangeTriggerEnabled(false);
                }
                Object newValue = (o = v.getValue()) != null ? ((castType = this.getHolderType()).isAssignableFrom(o.getClass()) ? o : TypeCastUtility.castValue((Object)o, castType)) : null;
                this.setValue(newValue);
            }
            finally {
                if (!valueChangeTriggersEnabled) {
                    this.setValueChangeTriggerEnabled(true);
                }
            }
        }
    }

    @Override
    public void storeXML(SimpleXmlElement x) throws ProcessingException {
        block2: {
            super.storeXML(x);
            T value = this.getValue();
            try {
                x.setObjectAttribute("value", value);
            }
            catch (IOException e) {
                if (!LOG.isInfoEnabled()) break block2;
                LOG.info("not serializable value in field " + this.getClass().getName() + "/" + this.getLabel() + ": " + e);
            }
        }
    }

    @Override
    public void loadXML(SimpleXmlElement x) throws ProcessingException {
        super.loadXML(x);
        try {
            Object value = TypeCastUtility.castValue((Object)x.getObjectAttribute("value", null), this.getHolderType());
            this.setValue(value);
        }
        catch (Exception e) {
            LOG.warn(null, (Throwable)e);
        }
    }

    @Override
    public void resetValue() {
        T newValue = this.getInitValue();
        this.setValue(newValue);
        this.checkSaveNeeded();
        this.checkEmpty();
    }

    @Override
    public void refreshDisplayText() {
        if (this.isAutoDisplayText()) {
            String t = this.execFormatValue(this.getValue());
            this.setDisplayText(t);
        }
    }

    @Override
    public void addMasterListener(MasterListener listener) {
        this.m_listeningSlaves.add(MasterListener.class, (EventListener)listener);
    }

    @Override
    public void removeMasterListener(MasterListener listener) {
        this.m_listeningSlaves.remove(MasterListener.class, (EventListener)listener);
    }

    private void fireMasterChanged() {
        EventListener[] a = this.m_listeningSlaves.getListeners(MasterListener.class);
        if (a != null && a.length > 0) {
            T masterValue = this.getValue();
            int i = 0;
            while (i < a.length) {
                ((MasterListener)a[i]).masterChanged(masterValue);
                ++i;
            }
        }
    }

    @Override
    public void setInitValue(T initValue) {
        this.m_initValue = initValue;
    }

    @Override
    public T getInitValue() {
        return this.m_initValue;
    }

    @Override
    protected boolean execIsSaveNeeded() throws ProcessingException {
        T initValue;
        T value = this.getValue();
        return !CompareUtility.equals(value, initValue = this.getInitValue());
    }

    @Override
    protected void execMarkSaved() throws ProcessingException {
        super.execMarkSaved();
        T value = this.getValue();
        this.setInitValue(value);
    }

    @Override
    protected boolean execIsEmpty() throws ProcessingException {
        return this.getValue() == null;
    }

    @Override
    public T getValue() {
        if (this.isValueValidating() && ClientSyncJob.isSyncClientJob()) {
            throw new IllegalStateException("The value of " + this.getClass().getSimpleName() + " can not be accessed while the value is beeing validated");
        }
        int i = 0;
        while (this.isValueValidating() && i < 100) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
        return (T)this.propertySupport.getProperty("value");
    }

    @Override
    public final void setValue(T rawValue) {
        if (this.isValueChanging()) {
            Exception caller1 = new Exception();
            LOG.warn("Loop detection in " + this.getClass().getName() + " with value " + rawValue, (Throwable)caller1);
            return;
        }
        try {
            this.setFieldChanging(true);
            this.setValueChanging(true);
            T validatedValue = null;
            if (this.getErrorStatus() instanceof ValidationFailedStatus) {
                this.clearErrorStatus();
            }
            try {
                validatedValue = this.validateValue(rawValue);
                if (this.getErrorStatus() instanceof ParsingFailedStatus) {
                    this.clearErrorStatus();
                }
            }
            catch (Throwable t) {
                ProcessingException e;
                ProcessingException processingException = e = t instanceof ProcessingException ? (ProcessingException)t : new ProcessingException("Unexpected", t);
                if (!(this.getErrorStatus() instanceof ParsingFailedStatus)) {
                    this.setErrorStatus((IProcessingStatus)new ValidationFailedStatus(e.getStatus()));
                }
                e.consume();
                e.addContextMessage(String.valueOf(this.getLabel()) + " = " + rawValue);
                if (!(e instanceof VetoException)) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                }
                this.setValueChanging(false);
                this.setFieldChanging(false);
                return;
            }
            T oldValue = this.getValue();
            boolean changed = this.propertySupport.setPropertyNoFire("value", validatedValue);
            if (this.isAutoDisplayText()) {
                String t = this.execFormatValue(validatedValue);
                this.setDisplayText(t);
            }
            if (changed) {
                this.propertySupport.firePropertyChange("value", oldValue, validatedValue);
                this.valueChangedInternal();
                this.checkSaveNeeded();
                this.checkEmpty();
                this.fireMasterChanged();
                if (this.isValueChangeTriggerEnabled()) {
                    try {
                        this.execChangedValue();
                    }
                    catch (ProcessingException ex) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
                    }
                }
            }
        }
        finally {
            this.setValueChanging(false);
            this.setFieldChanging(false);
        }
    }

    protected void valueChangedInternal() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.valueOf(this.getLabel()) + " " + VerboseUtility.dumpObject(this.getValue()));
        }
    }

    @Override
    public boolean isValueChanging() {
        return this.m_valueChanging > 0;
    }

    private void setValueChanging(boolean b) {
        this.m_valueChanging = b ? ++this.m_valueChanging : --this.m_valueChanging;
    }

    @Override
    public boolean isValueParsing() {
        return this.m_valueParsing > 0;
    }

    private void setValueParsing(boolean b) {
        this.m_valueParsing = b ? ++this.m_valueParsing : --this.m_valueParsing;
    }

    @Override
    public boolean isValueValidating() {
        return this.m_valueValidating > 0;
    }

    private void setValueValidating(boolean b) {
        this.m_valueValidating = b ? ++this.m_valueValidating : --this.m_valueValidating;
    }

    @Override
    public final void fireValueChanged() {
        try {
            this.setValueChanging(true);
            try {
                this.execChangedValue();
            }
            catch (ProcessingException ex) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
            }
            this.fireMasterChanged();
        }
        finally {
            this.setValueChanging(false);
        }
    }

    private T validateValue(T rawValue) throws ProcessingException {
        try {
            this.setValueValidating(true);
            T o = rawValue;
            o = this.validateValueInternal(o);
            T t = o = this.execValidateValue(o);
            return t;
        }
        finally {
            this.setValueValidating(false);
        }
    }

    protected T validateValueInternal(T rawValue) throws ProcessingException {
        return rawValue;
    }

    @ConfigOperation
    @Order(value=190.0)
    protected T execValidateValue(T rawValue) throws ProcessingException {
        return rawValue;
    }

    @ConfigOperation
    @Order(value=220.0)
    protected void execChangedValue() throws ProcessingException {
    }

    @Override
    public final boolean parseValue(String text) {
        if (this.isValueParsing()) {
            LOG.warn("Loop detection in " + this.getLabel() + " with text " + text);
            return false;
        }
        try {
            this.setFieldChanging(true);
            this.setValueParsing(true);
            T parsedValue = this.execParseValue(text);
            IProcessingStatus oldErrorStatus = this.getErrorStatus();
            String oldDisplayText = this.getDisplayText();
            if (this.getErrorStatus() instanceof ParsingFailedStatus) {
                this.clearErrorStatus();
            }
            this.setValue(parsedValue);
            if (oldErrorStatus instanceof ValidationFailedStatus && this.getErrorStatus() == null && StringUtility.nvl((Object)text, (String)"").equals(StringUtility.nvl((Object)oldDisplayText, (String)""))) {
                this.setErrorStatus(oldErrorStatus);
            } else if (this.getErrorStatus() instanceof ValidationFailedStatus) {
                this.setErrorStatus((IProcessingStatus)new ParsingFailedStatus(this.getErrorStatus(), text));
            }
            return true;
        }
        catch (Throwable t) {
            ProcessingException e;
            if (t instanceof ProcessingException) {
                e = (ProcessingException)t;
            } else {
                LOG.warn(null, t);
                e = new ProcessingException(ScoutTexts.get((String)"InvalidValueMessageX", (String[])new String[]{text}), t);
            }
            ParsingFailedStatus internalStatus = new ParsingFailedStatus(e.getStatus(), text);
            this.setErrorStatus((IProcessingStatus)internalStatus);
            return false;
        }
        finally {
            this.setValueParsing(false);
            this.setFieldChanging(false);
        }
    }

    protected T parseValueInternal(String text) throws ProcessingException {
        throw new ProcessingException("Not implemented");
    }

    @ConfigOperation
    @Order(value=200.0)
    protected T execParseValue(String text) throws ProcessingException {
        return this.parseValueInternal(text);
    }

    @ConfigOperation
    @Order(value=210.0)
    protected String execFormatValue(T validValue) {
        return this.formatValueInternal(validValue);
    }

    protected String formatValueInternal(T validValue) {
        return validValue != null ? validValue.toString() : "";
    }

    @Override
    public String getDisplayText() {
        return this.propertySupport.getPropertyString("displayText");
    }

    @Override
    public void setDisplayText(String s) {
        this.propertySupport.setPropertyStringAlwaysFire("displayText", s);
    }

    @Override
    public boolean isAutoDisplayText() {
        return this.m_autoDisplayText;
    }

    @Override
    public void setAutoDisplayText(boolean b) {
        this.m_autoDisplayText = b;
    }

    @Override
    protected void execChangedMasterValue(Object newMasterValue) throws ProcessingException {
        this.setValue(null);
    }

    public Class<T> getHolderType() {
        return TypeCastUtility.getGenericsParameterClass(this.getClass(), IHolder.class);
    }

    public void updateFrom(IHolder<T> other) {
        this.setValue(other.getValue());
    }

    @Override
    public boolean isContentValid() {
        boolean b = super.isContentValid();
        if (b && this.isMandatory() && this.getValue() == null) {
            return false;
        }
        return b;
    }
}

