/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.composer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.FormData;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerValueField;
import org.eclipse.scout.rt.client.ui.form.fields.datefield.AbstractDateField;
import org.eclipse.scout.rt.client.ui.form.fields.datefield.AbstractTimeField;
import org.eclipse.scout.rt.client.ui.form.fields.doublefield.AbstractDoubleField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.integerfield.AbstractIntegerField;
import org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBox;
import org.eclipse.scout.rt.client.ui.form.fields.longfield.AbstractLongField;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.AbstractSequenceBox;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.ISequenceBox;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.AbstractSmartField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.AbstractStringField;
import org.eclipse.scout.rt.client.ui.form.fields.treebox.AbstractTreeBox;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttributeOp;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;

public abstract class AbstractComposerValueBox
extends AbstractGroupBox {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractComposerValueBox.class);
    private Map<Integer, Map<Integer, IComposerValueField>> m_opTypeToFieldMap;
    private IDataModelAttribute m_attribute;
    private IComposerValueField m_selectedField;
    private PropertyChangeListener m_valueChangedListener;

    public AbstractComposerValueBox() {
        this(true);
    }

    public AbstractComposerValueBox(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected boolean getConfiguredBorderVisible() {
        return false;
    }

    @Override
    protected int getConfiguredGridColumnCount() {
        return 1;
    }

    @Override
    protected int getConfiguredGridW() {
        return 1;
    }

    @ConfigOperation
    @Order(value=50.0)
    protected void execChangedValue() throws ProcessingException {
    }

    @Override
    protected void execAddSearchTerms(SearchFilter search) {
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.m_opTypeToFieldMap = new HashMap<Integer, Map<Integer, IComposerValueField>>();
        HashMap<Integer, IComposerValueField> betweenMap = new HashMap<Integer, IComposerValueField>();
        betweenMap.put(5, this.getFieldByClass(BetweenDateField.class));
        betweenMap.put(7, this.getFieldByClass(BetweenDateTimeField.class));
        betweenMap.put(10, this.getFieldByClass(BetweenDoubleField.class));
        betweenMap.put(17, this.getFieldByClass(BetweenIntegerField.class));
        betweenMap.put(8, this.getFieldByClass(BetweenIntegerField.class));
        betweenMap.put(9, this.getFieldByClass(BetweenLongField.class));
        betweenMap.put(14, this.getFieldByClass(BetweenDoubleField.class));
        betweenMap.put(13, this.getFieldByClass(BetweenDoubleField.class));
        betweenMap.put(11, this.getFieldByClass(BetweenIntegerField.class));
        betweenMap.put(12, this.getFieldByClass(BetweenLongField.class));
        betweenMap.put(6, this.getFieldByClass(BetweenTimeField.class));
        this.m_opTypeToFieldMap.put(45, betweenMap);
        this.m_opTypeToFieldMap.put(47, betweenMap);
        this.m_opTypeToFieldMap.put(48, betweenMap);
        HashMap<Integer, IComposerValueField> defaultMap = new HashMap<Integer, IComposerValueField>();
        defaultMap.put(5, this.getFieldByClass(DateField.class));
        defaultMap.put(7, this.getFieldByClass(DateTimeField.class));
        defaultMap.put(10, this.getFieldByClass(DoubleField.class));
        defaultMap.put(17, this.getFieldByClass(IntegerField.class));
        defaultMap.put(8, this.getFieldByClass(IntegerField.class));
        defaultMap.put(3, this.getFieldByClass(ListBoxField.class));
        defaultMap.put(4, this.getFieldByClass(TreeBoxField.class));
        defaultMap.put(1, this.getFieldByClass(ListBoxField.class));
        defaultMap.put(2, this.getFieldByClass(TreeBoxField.class));
        defaultMap.put(9, this.getFieldByClass(LongField.class));
        defaultMap.put(14, this.getFieldByClass(DoubleField.class));
        defaultMap.put(13, this.getFieldByClass(DoubleField.class));
        defaultMap.put(11, this.getFieldByClass(IntegerField.class));
        defaultMap.put(12, this.getFieldByClass(LongField.class));
        defaultMap.put(15, this.getFieldByClass(StringField.class));
        defaultMap.put(18, this.getFieldByClass(StringField.class));
        defaultMap.put(16, this.getFieldByClass(SmartField.class));
        defaultMap.put(6, this.getFieldByClass(TimeField.class));
        this.m_opTypeToFieldMap.put(0, defaultMap);
        this.m_valueChangedListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if ("value".equals(e.getPropertyName())) {
                    try {
                        AbstractComposerValueBox.this.execChangedValue();
                    }
                    catch (Throwable t) {
                        LOG.error("fire value change on " + e.getSource(), t);
                    }
                }
            }
        };
        IFormField[] iFormFieldArray = this.getFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField f = iFormFieldArray[n2];
            f.setLabelVisible(false);
            f.setLabel(ScoutTexts.get((String)"Value", (String[])new String[0]));
            f.setVisible(false);
            if (f instanceof ISequenceBox) {
                IFormField[] sequenceBoxChildFields = ((ISequenceBox)f).getFields();
                if (sequenceBoxChildFields.length > 0) {
                    sequenceBoxChildFields[0].setLabelVisible(false);
                }
                if (sequenceBoxChildFields.length > 1 && sequenceBoxChildFields[1].getLabel() == null) {
                    sequenceBoxChildFields[1].setLabel(ScoutTexts.get((String)"and", (String[])new String[0]));
                }
            }
            ++n2;
        }
    }

    public IComposerValueField getSelectedField() {
        return this.m_selectedField;
    }

    public void setSelectionContext(IDataModelAttribute attribute, IDataModelAttributeOp op, Object[] values) {
        Map<Integer, IComposerValueField> typeToFieldMap;
        if (op == null) {
            return;
        }
        if (values == null && this.getSelectedField() != null) {
            values = this.getSelectedField().getValues();
        }
        this.m_attribute = attribute;
        int dataType = op.getType();
        if (dataType == -1) {
            dataType = attribute.getType();
        }
        if ((typeToFieldMap = this.m_opTypeToFieldMap.get(op.getOperator())) == null) {
            typeToFieldMap = this.m_opTypeToFieldMap.get(0);
        }
        IComposerValueField valueField = typeToFieldMap.get(dataType);
        if (this.m_selectedField != null) {
            this.m_selectedField.removeValueChangeListenerFromTarget(this.m_valueChangedListener);
            this.m_selectedField.clearSelectionContext();
        }
        this.m_selectedField = valueField;
        if (this.m_selectedField != null) {
            this.m_selectedField.addValueChangeListenerToTarget(this.m_valueChangedListener);
            this.m_selectedField.setSelectionContext(this.m_attribute, dataType, op, values);
        }
        IFormField[] iFormFieldArray = this.getFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField f = iFormFieldArray[n2];
            if (f == this.m_selectedField) {
                f.setVisible(true);
            } else {
                f.setVisible(false);
            }
            ++n2;
        }
    }

    public void clearSelectionContext() {
        if (this.m_selectedField != null) {
            this.m_selectedField.clearSelectionContext();
        }
        this.m_selectedField = null;
        IFormField[] iFormFieldArray = this.getFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField f = iFormFieldArray[n2];
            f.setVisible(false);
            ++n2;
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class BetweenDateField
    extends AbstractSequenceBox
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            IFormField[] iFormFieldArray = this.getFields();
            int n = iFormFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFormField f = iFormFieldArray[n2];
                f.addPropertyChangeListener(listener);
                ++n2;
            }
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            IFormField[] iFormFieldArray = this.getFields();
            int n = iFormFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFormField f = iFormFieldArray[n2];
                f.removePropertyChangeListener(listener);
                ++n2;
            }
        }

        @Override
        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, Object[] values) {
            try {
                this.getFieldByClass(DateFromField.class).setValue(null);
                this.getFieldByClass(DateToField.class).setValue(null);
                if (values != null && values.length == 2) {
                    if (values[0] instanceof Date) {
                        this.getFieldByClass(DateFromField.class).setValue((Date)values[0]);
                    }
                    if (values[1] instanceof Date) {
                        this.getFieldByClass(DateToField.class).setValue((Date)values[1]);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void clearSelectionContext() {
            this.getFieldByClass(DateFromField.class).setValue(null);
            this.getFieldByClass(DateToField.class).setValue(null);
        }

        @Override
        public Object[] getValues() {
            Object a = this.getFieldByClass(DateFromField.class).getValue();
            Object b = this.getFieldByClass(DateToField.class).getValue();
            if (a != null || b != null) {
                return new Object[]{a, b};
            }
            return null;
        }

        @Override
        public String[] getTexts() {
            String a = this.getFieldByClass(DateFromField.class).getDisplayText();
            String b = this.getFieldByClass(DateToField.class).getDisplayText();
            return new String[]{a, b};
        }

        @Order(value=10.0)
        public class DateFromField
        extends AbstractDateField {
        }

        @Order(value=20.0)
        public class DateToField
        extends AbstractDateField {
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class BetweenDateTimeField
    extends AbstractSequenceBox
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            IFormField[] iFormFieldArray = this.getFields();
            int n = iFormFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFormField f = iFormFieldArray[n2];
                f.addPropertyChangeListener(listener);
                ++n2;
            }
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            IFormField[] iFormFieldArray = this.getFields();
            int n = iFormFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFormField f = iFormFieldArray[n2];
                f.removePropertyChangeListener(listener);
                ++n2;
            }
        }

        @Override
        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, Object[] values) {
            try {
                this.getFieldByClass(DateTimeFromField.class).setValue(null);
                this.getFieldByClass(DateTimeToField.class).setValue(null);
                if (values != null && values.length == 2) {
                    if (values[0] instanceof Date) {
                        this.getFieldByClass(DateTimeFromField.class).setValue((Date)values[0]);
                    }
                    if (values[1] instanceof Date) {
                        this.getFieldByClass(DateTimeToField.class).setValue((Date)values[1]);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void clearSelectionContext() {
            this.getFieldByClass(DateTimeFromField.class).setValue(null);
            this.getFieldByClass(DateTimeToField.class).setValue(null);
        }

        @Override
        public Object[] getValues() {
            Object a = this.getFieldByClass(DateTimeFromField.class).getValue();
            Object b = this.getFieldByClass(DateTimeToField.class).getValue();
            if (a != null || b != null) {
                return new Object[]{a, b};
            }
            return null;
        }

        @Override
        public String[] getTexts() {
            String a = this.getFieldByClass(DateTimeFromField.class).getDisplayText();
            String b = this.getFieldByClass(DateTimeToField.class).getDisplayText();
            return new String[]{a, b};
        }

        @Order(value=10.0)
        public class DateTimeFromField
        extends AbstractDateField {
            @Override
            protected boolean getConfiguredHasTime() {
                return true;
            }
        }

        @Order(value=20.0)
        public class DateTimeToField
        extends AbstractDateField {
            @Override
            protected boolean getConfiguredHasTime() {
                return true;
            }
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class BetweenDoubleField
    extends AbstractSequenceBox
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            IFormField[] iFormFieldArray = this.getFields();
            int n = iFormFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFormField f = iFormFieldArray[n2];
                f.addPropertyChangeListener(listener);
                ++n2;
            }
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            IFormField[] iFormFieldArray = this.getFields();
            int n = iFormFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFormField f = iFormFieldArray[n2];
                f.removePropertyChangeListener(listener);
                ++n2;
            }
        }

        @Override
        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, Object[] values) {
            try {
                this.getFieldByClass(DoubleFromField.class).setValue(null);
                this.getFieldByClass(DoubleToField.class).setValue(null);
                if (values != null && values.length == 2) {
                    if (values[0] instanceof Double) {
                        this.getFieldByClass(DoubleFromField.class).setValue((Double)values[0]);
                    }
                    if (values[1] instanceof Double) {
                        this.getFieldByClass(DoubleToField.class).setValue((Double)values[1]);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void clearSelectionContext() {
            this.getFieldByClass(DoubleFromField.class).setValue(null);
            this.getFieldByClass(DoubleToField.class).setValue(null);
        }

        @Override
        public Object[] getValues() {
            Object a = this.getFieldByClass(DoubleFromField.class).getValue();
            Object b = this.getFieldByClass(DoubleToField.class).getValue();
            if (a != null || b != null) {
                return new Object[]{a, b};
            }
            return null;
        }

        @Override
        public String[] getTexts() {
            String a = this.getFieldByClass(DoubleFromField.class).getDisplayText();
            String b = this.getFieldByClass(DoubleToField.class).getDisplayText();
            return new String[]{a, b};
        }

        @Order(value=10.0)
        public class DoubleFromField
        extends AbstractDoubleField {
        }

        @Order(value=20.0)
        public class DoubleToField
        extends AbstractDoubleField {
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class BetweenIntegerField
    extends AbstractSequenceBox
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            IFormField[] iFormFieldArray = this.getFields();
            int n = iFormFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFormField f = iFormFieldArray[n2];
                f.addPropertyChangeListener(listener);
                ++n2;
            }
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            IFormField[] iFormFieldArray = this.getFields();
            int n = iFormFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFormField f = iFormFieldArray[n2];
                f.removePropertyChangeListener(listener);
                ++n2;
            }
        }

        @Override
        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, Object[] values) {
            try {
                this.getFieldByClass(IntegerFromField.class).setValue(null);
                this.getFieldByClass(IntegerToField.class).setValue(null);
                if (values != null && values.length == 2) {
                    if (values[0] instanceof Integer) {
                        this.getFieldByClass(IntegerFromField.class).setValue((Integer)values[0]);
                    }
                    if (values[1] instanceof Integer) {
                        this.getFieldByClass(IntegerToField.class).setValue((Integer)values[1]);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void clearSelectionContext() {
            this.getFieldByClass(IntegerFromField.class).setValue(null);
            this.getFieldByClass(IntegerToField.class).setValue(null);
        }

        @Override
        public Object[] getValues() {
            Object a = this.getFieldByClass(IntegerFromField.class).getValue();
            Object b = this.getFieldByClass(IntegerToField.class).getValue();
            if (a != null || b != null) {
                return new Object[]{a, b};
            }
            return null;
        }

        @Override
        public String[] getTexts() {
            String a = this.getFieldByClass(IntegerFromField.class).getDisplayText();
            String b = this.getFieldByClass(IntegerToField.class).getDisplayText();
            return new String[]{a, b};
        }

        @Order(value=10.0)
        public class IntegerFromField
        extends AbstractIntegerField {
        }

        @Order(value=20.0)
        public class IntegerToField
        extends AbstractIntegerField {
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class BetweenLongField
    extends AbstractSequenceBox
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            IFormField[] iFormFieldArray = this.getFields();
            int n = iFormFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFormField f = iFormFieldArray[n2];
                f.addPropertyChangeListener(listener);
                ++n2;
            }
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            IFormField[] iFormFieldArray = this.getFields();
            int n = iFormFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFormField f = iFormFieldArray[n2];
                f.removePropertyChangeListener(listener);
                ++n2;
            }
        }

        @Override
        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, Object[] values) {
            try {
                this.getFieldByClass(LongFromField.class).setValue(null);
                this.getFieldByClass(LongToField.class).setValue(null);
                if (values != null && values.length == 2) {
                    if (values[0] instanceof Long) {
                        this.getFieldByClass(LongFromField.class).setValue((Long)values[0]);
                    }
                    if (values[1] instanceof Long) {
                        this.getFieldByClass(LongToField.class).setValue((Long)values[1]);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void clearSelectionContext() {
            this.getFieldByClass(LongFromField.class).setValue(null);
            this.getFieldByClass(LongToField.class).setValue(null);
        }

        @Override
        public Object[] getValues() {
            Object a = this.getFieldByClass(LongFromField.class).getValue();
            Object b = this.getFieldByClass(LongToField.class).getValue();
            if (a != null || b != null) {
                return new Object[]{a, b};
            }
            return null;
        }

        @Override
        public String[] getTexts() {
            String a = this.getFieldByClass(LongFromField.class).getDisplayText();
            String b = this.getFieldByClass(LongToField.class).getDisplayText();
            return new String[]{a, b};
        }

        @Order(value=10.0)
        public class LongFromField
        extends AbstractLongField {
        }

        @Order(value=20.0)
        public class LongToField
        extends AbstractLongField {
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class BetweenTimeField
    extends AbstractSequenceBox
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            IFormField[] iFormFieldArray = this.getFields();
            int n = iFormFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFormField f = iFormFieldArray[n2];
                f.addPropertyChangeListener(listener);
                ++n2;
            }
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            IFormField[] iFormFieldArray = this.getFields();
            int n = iFormFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFormField f = iFormFieldArray[n2];
                f.removePropertyChangeListener(listener);
                ++n2;
            }
        }

        @Override
        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, Object[] values) {
            try {
                this.getFieldByClass(TimeFromField.class).setValue(null);
                this.getFieldByClass(TimeToField.class).setValue(null);
                if (values != null && values.length == 2) {
                    if (values[0] instanceof Double) {
                        this.getFieldByClass(TimeFromField.class).setTimeValue((Double)values[0]);
                    } else if (values[0] instanceof Date) {
                        this.getFieldByClass(TimeFromField.class).setValue((Date)values[0]);
                    }
                    if (values[1] instanceof Double) {
                        this.getFieldByClass(TimeToField.class).setTimeValue((Double)values[1]);
                    } else if (values[1] instanceof Date) {
                        this.getFieldByClass(TimeToField.class).setValue((Date)values[1]);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void clearSelectionContext() {
            this.getFieldByClass(TimeFromField.class).setValue(null);
            this.getFieldByClass(TimeToField.class).setValue(null);
        }

        @Override
        public Object[] getValues() {
            Object a = this.getFieldByClass(TimeFromField.class).getValue();
            Object b = this.getFieldByClass(TimeToField.class).getValue();
            if (a != null || b != null) {
                return new Object[]{a, b};
            }
            return null;
        }

        @Override
        public String[] getTexts() {
            String a = this.getFieldByClass(TimeFromField.class).getDisplayText();
            String b = this.getFieldByClass(TimeToField.class).getDisplayText();
            return new String[]{a, b};
        }

        @Order(value=10.0)
        public class TimeFromField
        extends AbstractTimeField {
        }

        @Order(value=20.0)
        public class TimeToField
        extends AbstractTimeField {
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class DateField
    extends AbstractDateField
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            this.addPropertyChangeListener(listener);
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            this.removePropertyChangeListener(listener);
        }

        @Override
        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, Object[] values) {
            try {
                if (values != null && values.length == 1 && values[0] instanceof Date) {
                    this.setValue((Date)values[0]);
                } else {
                    this.setValue(null);
                }
            }
            catch (Exception e) {
                this.setValue(null);
            }
        }

        @Override
        public void clearSelectionContext() {
            this.setValue(null);
        }

        @Override
        public Object[] getValues() {
            if (this.getValue() != null) {
                return new Object[]{this.getValue()};
            }
            return null;
        }

        @Override
        public String[] getTexts() {
            return new String[]{this.getDisplayText()};
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class DateTimeField
    extends AbstractDateField
    implements IComposerValueField {
        @Override
        protected boolean getConfiguredHasTime() {
            return true;
        }

        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            this.addPropertyChangeListener(listener);
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            this.removePropertyChangeListener(listener);
        }

        @Override
        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, Object[] values) {
            try {
                if (values != null && values.length == 1 && values[0] instanceof Date) {
                    this.setValue((Date)values[0]);
                } else {
                    this.setValue(null);
                }
            }
            catch (Exception e) {
                this.setValue(null);
            }
        }

        @Override
        public void clearSelectionContext() {
            this.setValue(null);
        }

        @Override
        public Object[] getValues() {
            if (this.getValue() != null) {
                return new Object[]{this.getValue()};
            }
            return null;
        }

        @Override
        public String[] getTexts() {
            return new String[]{this.getDisplayText()};
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class DoubleField
    extends AbstractDoubleField
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            this.addPropertyChangeListener(listener);
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            this.removePropertyChangeListener(listener);
        }

        @Override
        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, Object[] values) {
            switch (dataType) {
                case 10: {
                    this.setGroupingUsed(true);
                    this.setPercent(false);
                    break;
                }
                case 14: {
                    this.setGroupingUsed(true);
                    this.setPercent(true);
                    break;
                }
                case 13: {
                    this.setGroupingUsed(false);
                    this.setPercent(false);
                }
            }
            try {
                if (values != null && values.length == 1 && values[0] instanceof Double) {
                    this.setValue((Double)values[0]);
                } else {
                    this.setValue(null);
                }
            }
            catch (Exception e) {
                this.setValue(null);
            }
        }

        @Override
        public void clearSelectionContext() {
            this.setValue(null);
        }

        @Override
        public Object[] getValues() {
            if (this.getValue() != null) {
                return new Object[]{this.getValue()};
            }
            return null;
        }

        @Override
        public String[] getTexts() {
            return new String[]{this.getDisplayText()};
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class IntegerField
    extends AbstractIntegerField
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            this.addPropertyChangeListener(listener);
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            this.removePropertyChangeListener(listener);
        }

        @Override
        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, Object[] values) {
            switch (dataType) {
                case 8: {
                    this.setGroupingUsed(true);
                    break;
                }
                case 11: {
                    this.setGroupingUsed(false);
                }
            }
            try {
                if (values != null && values.length == 1 && values[0] instanceof Integer) {
                    this.setValue((Integer)values[0]);
                } else {
                    this.setValue(null);
                }
            }
            catch (Exception e) {
                this.setValue(null);
            }
        }

        @Override
        public void clearSelectionContext() {
            this.setValue(null);
        }

        @Override
        public Object[] getValues() {
            if (this.getValue() != null) {
                return new Object[]{this.getValue()};
            }
            return null;
        }

        @Override
        public String[] getTexts() {
            return new String[]{this.getDisplayText()};
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class ListBoxField
    extends AbstractListBox<Object>
    implements IComposerValueField {
        @Override
        protected boolean getConfiguredAutoLoad() {
            return false;
        }

        @Override
        protected int getConfiguredGridH() {
            return 4;
        }

        @Override
        protected void execPrepareLookup(LookupCall call) throws ProcessingException {
            if (AbstractComposerValueBox.this.m_attribute != null) {
                call.setActive(this.isFilterActiveRows() ? null : TriState.TRUE);
                AbstractComposerValueBox.this.m_attribute.prepareLookup(call);
            }
        }

        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            this.addPropertyChangeListener(listener);
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            this.removePropertyChangeListener(listener);
        }

        @Override
        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, Object[] values) {
            this.setFilterActiveRowsValue(TriState.TRUE);
            this.setFilterActiveRows(attribute.isActiveFilterEnabled());
            LookupCall newCall = attribute.getLookupCall();
            if (this.getLookupCall() != newCall) {
                this.setLookupCall(attribute.getLookupCall());
                try {
                    this.loadListBoxData();
                }
                catch (Exception e) {
                    LOG.warn(null, (Throwable)e);
                }
            }
            try {
                if (values != null && values.length == 1 && values[0] instanceof Object[]) {
                    this.setValue((Object[])values[0]);
                } else {
                    this.setValue(null);
                }
            }
            catch (Exception e) {
                this.setValue(null);
            }
        }

        @Override
        public void clearSelectionContext() {
            this.setValue(null);
        }

        @Override
        public Object[] getValues() {
            if (this.getCheckedKeyCount() > 0) {
                return new Object[]{this.getValue()};
            }
            return null;
        }

        @Override
        public String[] getTexts() {
            return new String[]{this.getDisplayText()};
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class LongField
    extends AbstractLongField
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            this.addPropertyChangeListener(listener);
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            this.removePropertyChangeListener(listener);
        }

        @Override
        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, Object[] values) {
            switch (dataType) {
                case 9: {
                    this.setGroupingUsed(true);
                    break;
                }
                case 12: {
                    this.setGroupingUsed(false);
                }
            }
            try {
                if (values != null && values.length == 1 && values[0] instanceof Long) {
                    this.setValue((Long)values[0]);
                } else {
                    this.setValue(null);
                }
            }
            catch (Exception e) {
                this.setValue(null);
            }
        }

        @Override
        public void clearSelectionContext() {
            this.setValue(null);
        }

        @Override
        public Object[] getValues() {
            if (this.getValue() != null) {
                return new Object[]{this.getValue()};
            }
            return null;
        }

        @Override
        public String[] getTexts() {
            return new String[]{this.getDisplayText()};
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class SmartField
    extends AbstractSmartField<Object>
    implements IComposerValueField {
        @Override
        protected String getConfiguredBrowseIconId() {
            return "empty";
        }

        @Override
        protected void execPrepareLookup(LookupCall call) throws ProcessingException {
            if (AbstractComposerValueBox.this.m_attribute != null) {
                call.setActive(this.isActiveFilterEnabled() ? this.getActiveFilter() : TriState.TRUE);
                AbstractComposerValueBox.this.m_attribute.prepareLookup(call);
            }
        }

        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            this.addPropertyChangeListener(listener);
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            this.removePropertyChangeListener(listener);
        }

        @Override
        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, Object[] values) {
            this.setActiveFilterEnabled(attribute.isActiveFilterEnabled());
            LookupCall newCall = attribute.getLookupCall();
            if (this.getLookupCall() != newCall) {
                this.setLookupCall(newCall);
            }
            try {
                if (values != null && values.length == 1) {
                    this.setValue(values[0]);
                } else {
                    this.setValue(null);
                }
            }
            catch (Exception e) {
                this.setValue(null);
            }
        }

        @Override
        public void clearSelectionContext() {
            this.setValue(null);
        }

        @Override
        public Object[] getValues() {
            if (this.getValue() != null) {
                return new Object[]{this.getValue()};
            }
            return null;
        }

        @Override
        public String[] getTexts() {
            return new String[]{this.getDisplayText()};
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class StringField
    extends AbstractStringField
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            this.addPropertyChangeListener(listener);
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            this.removePropertyChangeListener(listener);
        }

        @Override
        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, Object[] values) {
            try {
                if (values != null && values.length == 1 && values[0] instanceof String) {
                    this.setValue((String)values[0]);
                } else {
                    this.setValue(null);
                }
            }
            catch (Exception e) {
                this.setValue(null);
            }
        }

        @Override
        public void clearSelectionContext() {
            this.setValue(null);
        }

        @Override
        public Object[] getValues() {
            if (this.getValue() != null) {
                return new Object[]{this.getValue()};
            }
            return null;
        }

        @Override
        public String[] getTexts() {
            return new String[]{this.getDisplayText()};
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class TimeField
    extends AbstractTimeField
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            this.addPropertyChangeListener(listener);
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            this.removePropertyChangeListener(listener);
        }

        @Override
        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, Object[] values) {
            try {
                if (values != null && values.length == 1) {
                    if (values[0] instanceof Double) {
                        this.setTimeValue((Double)values[0]);
                    } else if (values[0] instanceof Date) {
                        this.setValue((Date)values[0]);
                    } else {
                        this.setValue(null);
                    }
                } else {
                    this.setValue(null);
                }
            }
            catch (Exception e) {
                this.setValue(null);
            }
        }

        @Override
        public void clearSelectionContext() {
            this.setValue(null);
        }

        @Override
        public Object[] getValues() {
            if (this.getValue() != null) {
                return new Object[]{this.getValue()};
            }
            return null;
        }

        @Override
        public String[] getTexts() {
            return new String[]{this.getDisplayText()};
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class TreeBoxField
    extends AbstractTreeBox<Object>
    implements IComposerValueField {
        @Override
        protected boolean getConfiguredAutoLoad() {
            return false;
        }

        @Override
        protected int getConfiguredGridH() {
            return 4;
        }

        @Override
        protected void execPrepareLookup(LookupCall call, ITreeNode parent) throws ProcessingException {
            if (AbstractComposerValueBox.this.m_attribute != null) {
                call.setActive(this.isFilterActiveNodes() ? null : TriState.TRUE);
                AbstractComposerValueBox.this.m_attribute.prepareLookup(call);
            }
        }

        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            this.addPropertyChangeListener(listener);
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            this.removePropertyChangeListener(listener);
        }

        @Override
        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, Object[] values) {
            this.setFilterActiveNodesValue(TriState.TRUE);
            this.setFilterActiveNodes(attribute.isActiveFilterEnabled());
            LookupCall newCall = attribute.getLookupCall();
            if (this.getLookupCall() != newCall) {
                this.setLookupCall(newCall);
                try {
                    this.loadRootNode();
                    this.getTree().setNodeExpanded(this.getTree().getRootNode(), true);
                }
                catch (Exception e) {
                    LOG.warn(null, (Throwable)e);
                }
            }
            try {
                if (values != null && values.length == 1 && values[0] instanceof Object[]) {
                    this.setValue((Object[])values[0]);
                } else {
                    this.setValue(null);
                }
            }
            catch (Exception e) {
                this.setValue(null);
            }
        }

        @Override
        public void clearSelectionContext() {
            this.setValue(null);
        }

        @Override
        public Object[] getValues() {
            if (this.getCheckedKeyCount() > 0) {
                return new Object[]{this.getValue()};
            }
            return null;
        }

        @Override
        public String[] getTexts() {
            return new String[]{this.getDisplayText()};
        }
    }
}

