/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.internal;

import java.util.ArrayList;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.internal.GridDataBuilder;

public class RadioButtonGroupGrid {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RadioButtonGroupGrid.class);
    private ICompositeField m_group = null;
    private IFormField[] m_fields;
    private int m_gridColumns;
    private int m_gridRows;

    public RadioButtonGroupGrid(ICompositeField group) {
        this.m_group = group;
    }

    public void validate() {
        this.m_gridColumns = 0;
        this.m_gridRows = 0;
        ArrayList<IFormField> list = new ArrayList<IFormField>();
        IFormField[] iFormFieldArray = this.m_group.getFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField f = iFormFieldArray[n2];
            if (f.isVisible()) {
                list.add(f);
            } else {
                GridData data = GridDataBuilder.createFromHints(f, 1);
                f.setGridDataInternal(data);
            }
            ++n2;
        }
        this.m_fields = list.toArray(new IFormField[list.size()]);
        this.layoutStatic();
    }

    private void layoutStatic() {
        GridData parentData = this.m_group.getGridData();
        if (parentData.h <= 0) {
            LOG.error(String.valueOf(this.m_group.getClass().getName()) + " has gridData.h=" + parentData.h + "; expected value>0");
            this.m_gridRows = 1;
        } else if (this.m_fields.length <= 0) {
            LOG.error(String.valueOf(this.m_group.getClass().getName()) + " has fieldCount=" + this.m_fields.length + "; expected value>0");
            this.m_gridRows = 1;
        } else {
            this.m_gridRows = Math.min(parentData.h, this.m_fields.length);
        }
        this.m_gridColumns = (this.m_fields.length + this.m_gridRows - 1) / this.m_gridRows;
        int i = 0;
        int r = 0;
        while (r < this.m_gridRows) {
            int c = 0;
            while (c < this.m_gridColumns) {
                if (i >= this.m_fields.length) break;
                GridData data = GridDataBuilder.createFromHints(this.m_fields[i], 1);
                data.x = c++;
                data.y = r;
                this.m_fields[i].setGridDataInternal(data);
                ++i;
            }
            ++r;
        }
    }

    public int getGridColumnCount() {
        return this.m_gridColumns;
    }

    public int getGridRowCount() {
        return this.m_gridRows;
    }
}

