/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.tablefield;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import org.eclipse.scout.commons.BooleanUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.ListUtility;
import org.eclipse.scout.commons.NumberUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.FormData;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.ProcessingStatus;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.xmlparser.SimpleXmlElement;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.keystroke.KeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITable2;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableAdapter;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IBigDecimalColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IDoubleColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IIntegerColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.ILongColumn;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValidateContentDescriptor;
import org.eclipse.scout.rt.client.ui.form.fields.ValidateFormFieldDescriptor;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.ITableField;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.ValidateTableFieldDescriptor;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.tablefield.AbstractTableFieldBeanData;
import org.eclipse.scout.rt.shared.data.form.fields.tablefield.AbstractTableFieldData;

@FormData(value=AbstractTableFieldData.class, sdkCommand=FormData.SdkCommand.USE, defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.CREATE)
public abstract class AbstractTableField<T extends ITable>
extends AbstractFormField
implements ITableField<T> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractTableField.class);
    private T m_table;
    private boolean m_tableExternallyManaged;
    private P_ManagedTableListener m_managedTableListener;
    private P_TableStatusListener m_tableStatusListener;

    public AbstractTableField() {
        this(true);
    }

    public AbstractTableField(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigOperation
    @Order(value=190.0)
    protected void execReloadTableData() throws ProcessingException {
    }

    @Override
    public String createDefaultTableStatus() {
        StringBuilder statusText = new StringBuilder();
        T table = this.getTable();
        if (table != null) {
            int nTotal = table.getFilteredRowCount();
            if (nTotal == 1) {
                statusText.append(ScoutTexts.get((String)"OneRow", (String[])new String[0]));
            } else {
                statusText.append(ScoutTexts.get((String)"XRows", (String[])new String[]{NumberUtility.format((Number)nTotal)}));
            }
            int fTotal = table.getRowCount() - nTotal;
            if (fTotal == 1) {
                statusText.append(", " + ScoutTexts.get((String)"OneFiltered", (String[])new String[0]));
            } else if (fTotal > 1) {
                statusText.append(", " + ScoutTexts.get((String)"XFiltered", (String[])new String[]{NumberUtility.format((Number)fTotal)}));
            }
            int nSel = table.getSelectedRowCount();
            if (nSel == 1) {
                statusText.append(", " + ScoutTexts.get((String)"OneSelected", (String[])new String[0]));
            } else if (nSel > 1) {
                statusText.append(", " + ScoutTexts.get((String)"XSelected", (String[])new String[]{NumberUtility.format((Number)nSel)}));
                IColumn[] iColumnArray = table.getColumnSet().getVisibleColumns();
                int n = iColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IColumn c = iColumnArray[n2];
                    NumberFormat fmt = null;
                    Number sum = null;
                    if (c instanceof IBigDecimalColumn) {
                        fmt = ((IBigDecimalColumn)c).getNumberFormat();
                        double d = NumberUtility.sum((double[])((double[])TypeCastUtility.castValue(c.getSelectedValues(), double[].class)));
                        if (d != 0.0) {
                            sum = d;
                        }
                    } else if (c instanceof IDoubleColumn) {
                        fmt = ((IDoubleColumn)c).getNumberFormat();
                        double d = NumberUtility.sum((double[])((double[])TypeCastUtility.castValue(c.getSelectedValues(), double[].class)));
                        if (d != 0.0) {
                            sum = d;
                        }
                    } else if (c instanceof ILongColumn) {
                        fmt = ((ILongColumn)c).getNumberFormat();
                        long d = NumberUtility.sum((long[])((long[])TypeCastUtility.castValue(c.getSelectedValues(), long[].class)));
                        if (d != 0L) {
                            sum = d;
                        }
                    } else if (c instanceof IIntegerColumn) {
                        fmt = ((IIntegerColumn)c).getNumberFormat();
                        long d = NumberUtility.sum((long[])((long[])TypeCastUtility.castValue(c.getSelectedValues(), long[].class)));
                        if (d != 0L) {
                            sum = d;
                        }
                    }
                    if (fmt != null && sum != null) {
                        statusText.append(", " + c.getHeaderCell().getText() + ": " + fmt.format(sum));
                    }
                    ++n2;
                }
            }
        }
        if (statusText.length() == 0) {
            return null;
        }
        return statusText.toString();
    }

    @ConfigOperation
    @Order(value=195.0)
    protected void execUpdateTableStatus() {
        if (!this.isTableStatusVisible()) {
            return;
        }
        this.setTableStatus(this.createDefaultTableStatus());
    }

    @ConfigOperation
    @Order(value=200.0)
    protected void execSave(ITableRow[] insertedRows, ITableRow[] updatedRows, ITableRow[] deletedRows) {
    }

    @ConfigOperation
    @Order(value=210.0)
    protected void execSaveDeletedRow(ITableRow row) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=220.0)
    protected void execSaveInsertedRow(ITableRow row) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=230.0)
    protected void execSaveUpdatedRow(ITableRow row) throws ProcessingException {
    }

    @Override
    protected void execChangedMasterValue(Object newMasterValue) throws ProcessingException {
        this.reloadTableData();
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=200.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredTableStatusVisible() {
        return false;
    }

    private Class<? extends ITable> getConfiguredTable() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        Class[] f = ConfigurationUtility.filterClasses((Class[])dca, ITable.class);
        if (f.length == 1) {
            return f[0];
        }
        Class[] classArray = f;
        int n = f.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            if (c.getDeclaringClass() != AbstractTableField.class) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    @Override
    @ConfigPropertyValue(value="1")
    protected double getConfiguredGridWeightY() {
        return 1.0;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setTableStatusVisible(this.getConfiguredTableStatusVisible());
        if (this.getConfiguredTable() != null) {
            try {
                this.setTableInternal((ITable)ConfigurationUtility.newInnerInstance((Object)this, this.getConfiguredTable()));
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
        }
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (AbstractTableField.this.m_table != null) {
                    AbstractTableField.this.m_table.setEnabled(AbstractTableField.this.isEnabled());
                }
            }
        });
    }

    @Override
    protected void initFieldInternal() throws ProcessingException {
        if (this.m_table != null && !this.m_tableExternallyManaged) {
            this.m_table.initTable();
        }
        super.initFieldInternal();
    }

    @Override
    protected void disposeFieldInternal() {
        super.disposeFieldInternal();
        if (this.m_table != null && !this.m_tableExternallyManaged) {
            this.m_table.disposeTable();
        }
    }

    @Override
    public final T getTable() {
        return this.m_table;
    }

    @Override
    public void setTable(T newTable, boolean externallyManaged) {
        this.m_tableExternallyManaged = externallyManaged;
        this.setTableInternal(newTable);
    }

    private void setTableInternal(T table) {
        boolean changed;
        if (this.m_table == table) {
            return;
        }
        if (this.m_table instanceof AbstractTable) {
            ((AbstractTable)this.m_table).setContainerInternal(null);
        }
        if (this.m_table != null) {
            if (!this.m_tableExternallyManaged && this.m_managedTableListener != null) {
                this.m_table.removeTableListener(this.m_managedTableListener);
                this.m_managedTableListener = null;
            }
            if (this.m_tableStatusListener != null) {
                this.m_table.removeTableListener(this.m_tableStatusListener);
                this.m_tableStatusListener = null;
            }
        }
        this.m_table = table;
        if (this.m_table instanceof AbstractTable) {
            ((AbstractTable)this.m_table).setContainerInternal(this);
        }
        if (this.m_table != null) {
            if (!this.m_tableExternallyManaged) {
                this.m_managedTableListener = new P_ManagedTableListener();
                this.m_table.addTableListener(this.m_managedTableListener);
            }
            this.m_tableStatusListener = new P_TableStatusListener();
            this.m_table.addTableListener(this.m_tableStatusListener);
            this.updateTableStatus();
            this.m_table.setEnabled(this.isEnabled());
        }
        if (changed = this.propertySupport.setProperty("table", this.m_table)) {
            if (this.getForm() != null) {
                this.getForm().structureChanged(this);
            }
            this.updateKeyStrokes();
        }
    }

    @Override
    public void exportFormFieldData(AbstractFormFieldData target) throws ProcessingException {
        if (this.m_table != null) {
            if (target instanceof AbstractTableFieldData) {
                AbstractTableFieldData tableFieldData = (AbstractTableFieldData)target;
                this.m_table.extractTableData(tableFieldData);
            } else if (this.m_table instanceof ITable2 && target instanceof AbstractTableFieldBeanData) {
                AbstractTableFieldBeanData tableBeanData = (AbstractTableFieldBeanData)target;
                ((ITable2)this.m_table).exportToTableBeanData(tableBeanData);
                target.setValueSet(true);
            }
        }
    }

    @Override
    public void importFormFieldData(AbstractFormFieldData source, boolean valueChangeTriggersEnabled) throws ProcessingException {
        if (source.isValueSet() && this.m_table != null) {
            try {
                if (!valueChangeTriggersEnabled) {
                    this.setValueChangeTriggerEnabled(false);
                }
                if (source instanceof AbstractTableFieldData) {
                    AbstractTableFieldData tableFieldData = (AbstractTableFieldData)source;
                    this.m_table.updateTable(tableFieldData);
                } else if (this.m_table instanceof ITable2 && source instanceof AbstractTableFieldBeanData) {
                    AbstractTableFieldBeanData tableBeanData = (AbstractTableFieldBeanData)source;
                    ((ITable2)this.m_table).importFromTableBeanData(tableBeanData);
                }
                if (this.m_table.isCheckable() && this.m_table.getCheckableColumn() != null) {
                    ITableRow[] iTableRowArray = this.m_table.getRows();
                    int n = iTableRowArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITableRow row = iTableRowArray[n2];
                        row.setChecked(BooleanUtility.nvl((Boolean)((Boolean)this.m_table.getCheckableColumn().getValue(row))));
                        ++n2;
                    }
                }
            }
            finally {
                if (!valueChangeTriggersEnabled) {
                    this.setValueChangeTriggerEnabled(true);
                }
            }
        }
    }

    @Override
    public void loadXML(SimpleXmlElement x) throws ProcessingException {
        super.loadXML(x);
        if (this.m_table != null) {
            int[] selectedRowIndices = null;
            try {
                selectedRowIndices = (int[])x.getObjectAttribute("selectedRowIndices", null);
            }
            catch (Exception e) {
                LOG.warn("reading attribute 'selectedRowIndices'", (Throwable)e);
            }
            Object[][] dataMatrix = null;
            try {
                dataMatrix = (Object[][])x.getObjectAttribute("rows", null);
            }
            catch (Exception e) {
                LOG.warn("reading attribute 'rows'", (Throwable)e);
            }
            this.m_table.discardAllRows();
            if (dataMatrix != null && dataMatrix.length > 0) {
                this.m_table.addRowsByMatrix(dataMatrix);
            }
            if (selectedRowIndices != null && selectedRowIndices.length > 0) {
                this.m_table.selectRows(this.m_table.getRows(selectedRowIndices));
            }
        }
    }

    @Override
    public void storeXML(SimpleXmlElement x) throws ProcessingException {
        super.storeXML(x);
        if (this.m_table != null) {
            ITableRow[] selectedRows = this.m_table.getSelectedRows();
            int[] selectedRowIndices = new int[selectedRows.length];
            int i = 0;
            while (i < selectedRowIndices.length) {
                selectedRowIndices[i] = selectedRows[i].getRowIndex();
                ++i;
            }
            try {
                x.setObjectAttribute("selectedRowIndices", (Object)selectedRowIndices);
            }
            catch (Exception e) {
                LOG.warn("writing attribute 'selectedRowIndices'", (Throwable)e);
            }
            Object[][] dataMatrix = this.m_table.getTableData();
            int r = 0;
            while (r < dataMatrix.length) {
                int c = 0;
                while (c < dataMatrix[r].length) {
                    Object o = dataMatrix[r][c];
                    if (o != null && !(o instanceof Serializable)) {
                        LOG.warn("ignoring not serializable value at row=" + r + ", col=" + c + ": " + o + "[" + o.getClass() + "]");
                        dataMatrix[r][c] = null;
                    }
                    ++c;
                }
                ++r;
            }
            try {
                x.setObjectAttribute("rows", (Object)dataMatrix);
            }
            catch (Exception e) {
                LOG.warn("writing attribute 'rows'", (Throwable)e);
            }
        }
    }

    @Override
    protected boolean execIsSaveNeeded() throws ProcessingException {
        boolean b = false;
        if (this.m_table != null && !this.m_tableExternallyManaged) {
            if (!b && this.m_table.getDeletedRowCount() > 0) {
                b = true;
            }
            if (!b && this.m_table.getInsertedRowCount() > 0) {
                b = true;
            }
            if (!b && this.m_table.getUpdatedRowCount() > 0) {
                b = true;
            }
        }
        return b;
    }

    @Override
    protected void execMarkSaved() throws ProcessingException {
        super.execMarkSaved();
        if (this.m_table != null && !this.m_tableExternallyManaged) {
            try {
                this.m_table.setTableChanging(true);
                int i = 0;
                while (i < this.m_table.getRowCount()) {
                    ITableRow row = this.m_table.getRow(i);
                    if (!row.isStatusNonchanged()) {
                        row.setStatusNonchanged();
                    }
                    ++i;
                }
                this.m_table.discardAllDeletedRows();
            }
            finally {
                this.m_table.setTableChanging(false);
            }
        }
    }

    @Override
    protected boolean execIsEmpty() throws ProcessingException {
        if (this.m_table != null) {
            return this.m_table.getRowCount() == 0;
        }
        return true;
    }

    @Override
    public IValidateContentDescriptor validateContent() {
        IValidateContentDescriptor desc = super.validateContent();
        if (desc != null) {
            return desc;
        }
        T table = this.getTable();
        if (this.isMandatory() && (table == null || table.getRowCount() < 1)) {
            return new ValidateFormFieldDescriptor(this);
        }
        HashSet invisbleColumnsWithErrors = new HashSet();
        ValidateTableFieldDescriptor tableDesc = null;
        TreeSet<String> columnNames = new TreeSet<String>();
        if (table != null) {
            ITableRow[] iTableRowArray = table.getRows();
            int n = iTableRowArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITableRow iTableRow = iTableRowArray[n2];
                IColumn<?>[] iColumnArray = table.getColumns();
                int n3 = iColumnArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IColumn<?> col = iColumnArray[n4];
                    if (col.isCellEditable(iTableRow)) {
                        try {
                            ICell cell = iTableRow.getCell(col);
                            if (cell.getErrorStatus() != null) {
                                if (col.isDisplayable() && !col.isVisible()) {
                                    invisbleColumnsWithErrors.add(col);
                                }
                                if (tableDesc == null) {
                                    tableDesc = new ValidateTableFieldDescriptor(this, iTableRow, col);
                                }
                                columnNames.add(col.getHeaderCell().getText());
                            }
                        }
                        catch (Throwable t) {
                            LOG.error("validating " + this.getClass().getSimpleName() + " for row " + iTableRow.getRowIndex() + " for column " + col.getClass().getSimpleName(), t);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        for (IColumn iColumn : invisbleColumnsWithErrors) {
            iColumn.setVisible(true);
        }
        if (tableDesc == null) {
            return null;
        }
        tableDesc.setDisplayText(String.valueOf(ScoutTexts.get((String)"TableName", (String[])new String[0])) + " " + this.getLabel() + ": " + ListUtility.format(columnNames));
        return tableDesc;
    }

    @Override
    public String getTableStatus() {
        IProcessingStatus status = this.getTableSelectionStatus();
        return status != null ? status.getMessage() : null;
    }

    @Override
    public void setTableStatus(String status) {
        this.setTableSelectionStatus((IProcessingStatus)(status != null ? new ProcessingStatus(status, 1) : null));
    }

    @Override
    public IProcessingStatus getTableSelectionStatus() {
        return (IProcessingStatus)this.propertySupport.getProperty("tableSelectionStatus");
    }

    @Override
    public void setTableSelectionStatus(IProcessingStatus status) {
        this.propertySupport.setProperty("tableSelectionStatus", (Object)status);
    }

    @Override
    public IProcessingStatus getTablePopulateStatus() {
        return (IProcessingStatus)this.propertySupport.getProperty("tablePopulateStatus");
    }

    @Override
    public void setTablePopulateStatus(IProcessingStatus status) {
        this.propertySupport.setProperty("tablePopulateStatus", (Object)status);
    }

    @Override
    public boolean isTableStatusVisible() {
        return this.propertySupport.getPropertyBool("tableStatusVisible");
    }

    @Override
    public void setTableStatusVisible(boolean b) {
        this.propertySupport.setPropertyBool("tableStatusVisible", b);
        if (b) {
            this.updateTableStatus();
        }
    }

    @Override
    public void updateTableStatus() {
        try {
            this.execUpdateTableStatus();
        }
        catch (Throwable t) {
            LOG.warn("Updating status of " + this.getClass().getName(), t);
        }
    }

    @Override
    public void doSave() throws ProcessingException {
        if (this.m_table != null && !this.m_tableExternallyManaged) {
            try {
                ITableRow mr;
                this.m_table.setTableChanging(true);
                this.execSave(this.m_table.getInsertedRows(), this.m_table.getUpdatedRows(), this.m_table.getDeletedRows());
                ITableRow[] insertedRows = this.m_table.getInsertedRows();
                ITableRow[] updatedRows = this.m_table.getUpdatedRows();
                ITableRow[] deletedRows = this.m_table.getDeletedRows();
                int i = 0;
                while (i < deletedRows.length) {
                    this.execSaveDeletedRow(deletedRows[i]);
                    ++i;
                }
                i = 0;
                while (i < insertedRows.length) {
                    mr = insertedRows[i];
                    this.execSaveInsertedRow(mr);
                    mr.setStatusNonchanged();
                    this.m_table.updateRow(mr);
                    ++i;
                }
                i = 0;
                while (i < updatedRows.length) {
                    mr = updatedRows[i];
                    this.execSaveUpdatedRow(mr);
                    mr.setStatusNonchanged();
                    this.m_table.updateRow(mr);
                    ++i;
                }
            }
            finally {
                this.m_table.setTableChanging(false);
            }
        }
        this.markSaved();
    }

    @Override
    public void reloadTableData() throws ProcessingException {
        this.execReloadTableData();
    }

    @Override
    public IKeyStroke[] getContributedKeyStrokes() {
        HashMap<String, KeyStroke> ksMap = new HashMap<String, KeyStroke>();
        if (this.getTable() != null) {
            IMenu[] iMenuArray = this.getTable().getMenus();
            int n = iMenuArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMenu m = iMenuArray[n2];
                String s = m.getKeyStroke();
                if (s != null && s.trim().length() > 0) {
                    KeyStroke ks = new KeyStroke(s, m);
                    ksMap.put(ks.getKeyStroke().toUpperCase(), ks);
                }
                ++n2;
            }
        }
        return ksMap.values().toArray(new IKeyStroke[ksMap.size()]);
    }

    private class P_ManagedTableListener
    extends TableAdapter {
        private P_ManagedTableListener() {
        }

        @Override
        public void tableChanged(TableEvent e) {
            switch (e.getType()) {
                case 1: 
                case 100: 
                case 101: 
                case 102: 
                case 105: {
                    AbstractTableField.this.checkSaveNeeded();
                    AbstractTableField.this.checkEmpty();
                }
            }
        }
    }

    private class P_TableStatusListener
    extends TableAdapter {
        private P_TableStatusListener() {
        }

        @Override
        public void tableChanged(TableEvent e) {
            switch (e.getType()) {
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 105: 
                case 210: 
                case 820: {
                    AbstractTableField.this.updateTableStatus();
                }
            }
        }
    }
}

