/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.scheduler;

import java.text.ParseException;
import org.eclipse.scout.commons.VerboseUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.scheduler.AbstractSchedulerJob;
import org.eclipse.scout.rt.server.scheduler.ISchedulingFormula;
import org.eclipse.scout.rt.server.scheduler.TickSignal;
import org.eclipse.scout.rt.server.scheduler.internal.FormulaParser;
import org.eclipse.scout.rt.server.scheduler.internal.SchedulingFormula;

public abstract class AbstractSchedulerJobWithFormula
extends AbstractSchedulerJob {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractSchedulerJobWithFormula.class);
    private ISchedulingFormula m_formulaCompiled;
    private String m_action;
    private Object[] m_args;

    public AbstractSchedulerJobWithFormula(String groupId, String jobId, String formula) throws ProcessingException {
        this(groupId, jobId, formula, null, new Object[0]);
    }

    public AbstractSchedulerJobWithFormula(String groupId, String jobId, String formula, String action, Object ... args) throws ProcessingException {
        super(groupId, jobId);
        this.m_action = action;
        this.m_args = args;
        this.m_formulaCompiled = AbstractSchedulerJobWithFormula.createFormula(formula);
    }

    public ISchedulingFormula getFormula() {
        return this.m_formulaCompiled;
    }

    public String getAction() {
        return this.m_action;
    }

    public Object[] getArgs() {
        return this.m_args;
    }

    @Override
    public final boolean acceptTick(TickSignal signal) {
        return this.m_formulaCompiled.eval(signal, this.getArgs());
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.getGroupId() + "." + this.getJobId() + " formula=" + this.m_formulaCompiled + ", action=" + this.m_action + ", args=" + VerboseUtility.dumpObjects((Object[])this.m_args) + "]";
    }

    public static ISchedulingFormula createFormula(String formula) throws ProcessingException {
        try {
            return new SchedulingFormula(new FormulaParser().parse(formula));
        }
        catch (ParseException e) {
            throw new ProcessingException("invalid formula: " + formula, (Throwable)e);
        }
    }
}

