/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.code;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.ServerJob;
import org.eclipse.scout.rt.server.services.common.clientnotification.AllUserFilter;
import org.eclipse.scout.rt.server.services.common.clientnotification.IClientNotificationService;
import org.eclipse.scout.rt.server.services.common.code.CodeTypeCache;
import org.eclipse.scout.rt.shared.services.common.clientnotification.IClientNotification;
import org.eclipse.scout.rt.shared.services.common.code.CodeTypeChangedNotification;
import org.eclipse.scout.service.SERVICES;

public class CodeTypeStore {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(CodeTypeStore.class);
    private Object m_storeLock = new Object();
    private HashMap<PartitionLanguageComposite, CodeTypeCache> m_store = new HashMap();

    public CodeTypeCache getCodeTypeCache(Locale locale) {
        Long partitionId = 0L;
        Map sharedVariableMap = ServerJob.getCurrentSession().getSharedVariableMap();
        if (sharedVariableMap.containsKey("partitionId")) {
            partitionId = (Long)sharedVariableMap.get("partitionId");
        }
        return this.getCodeTypeCache(partitionId, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeTypeCache getCodeTypeCache(Long partitionId, Locale locale) {
        Object object = this.m_storeLock;
        synchronized (object) {
            String key = locale.toString();
            PartitionLanguageComposite comp = new PartitionLanguageComposite(partitionId, key);
            CodeTypeCache cache = this.m_store.get(comp);
            if (cache == null) {
                cache = new CodeTypeCache();
                this.m_store.put(comp, cache);
            }
            return cache;
        }
    }

    public void unloadCodeTypeCache(Class ... types) {
        for (CodeTypeCache cache : this.m_store.values()) {
            cache.unloadCodeTypes(types);
        }
        ((IClientNotificationService)SERVICES.getService(IClientNotificationService.class)).putNotification((IClientNotification)new CodeTypeChangedNotification(types), new AllUserFilter(120000L));
    }

    private class PartitionLanguageComposite {
        private Long partitionId;
        private String language;

        public PartitionLanguageComposite(Long partitionId, String language) {
            this.partitionId = partitionId;
            this.language = language;
        }

        public Long getPartitionId() {
            return this.partitionId;
        }

        public String getLanguage() {
            return this.language;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
            result = 31 * result + (this.partitionId == null ? 0 : this.partitionId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PartitionLanguageComposite other = (PartitionLanguageComposite)obj;
            if (this.language == null ? other.language != null : !this.language.equals(other.language)) {
                return false;
            }
            return !(this.partitionId == null ? other.partitionId != null : !this.partitionId.equals(other.partitionId));
        }
    }
}

