/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.dict;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.eclipse.scout.rt.server.services.common.jdbc.dict.ColumnDesc;
import org.eclipse.scout.rt.server.services.common.jdbc.dict.DataDictionary;
import org.eclipse.scout.rt.server.services.common.jdbc.dict.IndexDesc;
import org.eclipse.scout.rt.server.services.common.jdbc.dict.PrimaryKeyDesc;
import org.eclipse.scout.rt.server.services.common.jdbc.dict.SequenceDesc;
import org.eclipse.scout.rt.server.services.common.jdbc.dict.TableDesc;
import org.eclipse.scout.rt.server.services.common.jdbc.dict.ViewDesc;

public class OracleDataDictionaryBuilder {
    public static final int SOURCE_TYPE_ORACLE_SERVER = 100;
    public static final int SOURCE_TYPE_ORACLE_CLIENT_LITE = 101;
    public static final int SOURCE_TYPE_ORACLE_PPC_LITE = 102;
    private static final String SELECT_ALL_TABLES = "select table_name from all_tables where owner=?";
    private static final String SELECT_ALL_VIEWS_ORACLE = "select view_name,text_length,text from all_views where owner=?";
    private static final String SELECT_ALL_VIEWS_LITE = "select view_name,text_length,to_char(text) from all_views where owner=?";
    private static final String SELECT_ALL_SEQUENCES = "select SEQUENCE_NAME,MIN_VALUE,MAX_VALUE,INCREMENT_BY from all_sequences where sequence_owner=?";
    private static final String SELECT_PRIMARY_KEY_COLUMNS = "select table_name,constraint_name,column_name from all_cons_columns where owner=? and table_name not like 'BIN$%' and constraint_name in (select constraint_name from all_constraints where owner=? and constraint_type='P') order by table_name,constraint_name,position";
    private static final String SELECT_ALL_INDEXES = "select table_name,index_name,uniqueness,index_type from all_indexes where owner=? order by table_name,index_name";
    private static final String SELECT_ALL_INDEXES_ORACLELITE = "select table_name,index_name,uniqueness,'NORMAL' from all_indexes where owner=? order by table_name,index_name";
    private static final String SELECT_ALL_INDEX_COLUMNS = "select index_name,column_name from all_ind_columns where index_owner=? order by index_name,column_position";
    private static final String SELECT_ALL_COLUMNS = "select table_name,COLUMN_NAME,DATA_TYPE,DATA_LENGTH,DATA_PRECISION,DATA_SCALE,NULLABLE,COLUMN_ID,DATA_DEFAULT from all_tab_columns where owner=? and table_name in (select table_name from all_tables where owner=?) order by table_name,column_id";

    public DataDictionary build(Connection conn, String schema, boolean lite) throws SQLException {
        schema = schema.toUpperCase();
        DataDictionary dd = new DataDictionary(schema);
        dd.setSourceType(lite ? 101 : 100);
        PreparedStatement stm = null;
        try {
            String indexName;
            stm = conn.prepareStatement(SELECT_ALL_TABLES);
            stm.setString(1, schema);
            ResultSet rs = stm.executeQuery();
            while (rs.next()) {
                TableDesc td = new TableDesc(rs.getString(1), schema);
                dd.addTable(td);
            }
            stm.close();
            stm = null;
            stm = conn.prepareStatement(lite ? SELECT_ALL_VIEWS_LITE : SELECT_ALL_VIEWS_ORACLE);
            stm.setString(1, schema);
            rs = stm.executeQuery();
            while (rs.next()) {
                ViewDesc vd = new ViewDesc(rs.getString(1), schema, rs.getString(3).trim());
                dd.addView(vd);
            }
            stm.close();
            stm = null;
            stm = conn.prepareStatement(SELECT_ALL_SEQUENCES);
            stm.setString(1, schema);
            rs = stm.executeQuery();
            while (rs.next()) {
                SequenceDesc sd = new SequenceDesc(rs.getString(1), rs.getBigDecimal(2), rs.getBigDecimal(3), rs.getBigDecimal(4));
                dd.addSequence(sd);
            }
            stm.close();
            stm = null;
            stm = conn.prepareStatement(SELECT_PRIMARY_KEY_COLUMNS);
            stm.setString(1, schema);
            stm.setString(2, schema);
            rs = stm.executeQuery();
            TableDesc curTableDesc = null;
            PrimaryKeyDesc curPk = null;
            while (rs.next()) {
                String tableName = rs.getString(1);
                String pkName = rs.getString(2);
                String colName = rs.getString(3);
                if (curPk == null || !curPk.getName().equals(pkName)) {
                    curTableDesc = dd.getTable(tableName);
                    curPk = new PrimaryKeyDesc(pkName);
                    curTableDesc.setPrimaryKey(curPk);
                }
                curPk.addColumnName(colName);
            }
            stm.close();
            stm = null;
            HashMap<String, IndexDesc> allIndexes = new HashMap<String, IndexDesc>();
            stm = lite ? conn.prepareStatement(SELECT_ALL_INDEXES_ORACLELITE) : conn.prepareStatement(SELECT_ALL_INDEXES);
            stm.setString(1, schema);
            rs = stm.executeQuery();
            curTableDesc = null;
            curPk = null;
            while (rs.next()) {
                String tableName = rs.getString(1);
                indexName = rs.getString(2);
                String unique = rs.getString(3);
                String indexType = rs.getString(4).toUpperCase();
                if (indexType.startsWith("FUNCTION-BASED")) continue;
                if (curTableDesc == null || !curTableDesc.getName().equals(tableName)) {
                    curTableDesc = dd.getTable(tableName);
                    curPk = curTableDesc.getPrimaryKey();
                }
                IndexDesc id = new IndexDesc(indexName, unique.equalsIgnoreCase("unique"));
                if (curPk == null || !curPk.getName().equalsIgnoreCase(indexName)) {
                    curTableDesc.addIndex(id);
                }
                allIndexes.put(indexName, id);
            }
            stm.close();
            stm = null;
            stm = conn.prepareStatement(SELECT_ALL_INDEX_COLUMNS);
            stm.setString(1, schema);
            rs = stm.executeQuery();
            IndexDesc curIndexDesc = null;
            while (rs.next()) {
                indexName = rs.getString(1);
                String colName = rs.getString(2);
                if (curIndexDesc == null || !curIndexDesc.getName().equals(indexName)) {
                    curIndexDesc = (IndexDesc)allIndexes.get(indexName);
                }
                if (curIndexDesc == null) continue;
                curIndexDesc.addColumnName(colName);
            }
            stm.close();
            stm = null;
            stm = conn.prepareStatement(SELECT_ALL_COLUMNS);
            stm.setString(1, schema);
            stm.setString(2, schema);
            rs = stm.executeQuery();
            curTableDesc = null;
            while (rs.next()) {
                String tableName = rs.getString(1);
                if (curTableDesc == null || !curTableDesc.getName().equals(tableName)) {
                    curTableDesc = dd.getTable(tableName);
                }
                ColumnDesc cd = new ColumnDesc(rs.getString(2).toUpperCase(), rs.getString(3), rs.getLong(4), rs.getLong(5), rs.getLong(6), rs.getString(7).equalsIgnoreCase("y"), rs.getString(9));
                curTableDesc.addColumn(cd);
            }
            stm.close();
            stm = null;
        }
        finally {
            if (stm != null) {
                try {
                    stm.close();
                }
                catch (Exception exception) {}
            }
        }
        return dd;
    }
}

