/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.pwd;

import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.VetoException;
import org.eclipse.scout.rt.server.services.common.pwd.IPasswordPolicy;
import org.eclipse.scout.rt.shared.ScoutTexts;

public class DefaultPasswordPolicy
implements IPasswordPolicy {
    private static final int MIN_PASSWORD_LENGTH = 8;

    @Override
    public String getText() {
        return ScoutTexts.get((String)"DefaultPasswordPolicyText", (String[])new String[0]);
    }

    @Override
    public void check(String userId, String newPassword, String userName, int historyIndex) throws ProcessingException {
        if (newPassword == null || newPassword.length() < 8) {
            this.throwFailure("PasswordMin8Chars");
        }
        if (!newPassword.matches(".*[0-9]+.*")) {
            this.throwFailure("PasswordMinOneDigit");
        }
        if (!newPassword.matches(".*[[a-z]|[A-Z]]+.*")) {
            this.throwFailure("PasswordMinOneChar");
        }
        if (!newPassword.matches(".*[!|@|#|\\$|%|\\^|&|\\*|\\(|\\)|_|\\+|\\||~|\\-|=|\\\\|`|\\{|\\}|\\[|\\]|:|\"|;|'|<|>|?|,|.|/]+.*")) {
            this.throwFailure("PasswordMinOnNonStdChar");
        }
        if (userName != null && newPassword.toUpperCase().indexOf(userName.toUpperCase()) >= 0) {
            this.throwFailure("PasswordUsernameNotPartOfPass");
        }
        if (historyIndex >= 0) {
            this.throwFailure("PasswordNotSameAsLasts");
        }
    }

    protected void throwFailure(String msgId) throws ProcessingException {
        throw new VetoException(ScoutTexts.get((String)msgId, (String[])new String[0]));
    }
}

