/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.smtp;

import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.eclipse.scout.commons.BundleContextUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.services.common.smtp.ISMTPService;
import org.eclipse.scout.service.AbstractService;

public abstract class AbstractSMTPService
extends AbstractService
implements ISMTPService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractSMTPService.class);
    private String m_host;
    private int m_port;
    private String m_username;
    private String m_password;
    private boolean m_useAuthentication;
    private String m_debugReceiverEmail;
    private String m_subjectPrefix;
    public String m_defaultFromEmail;
    private String m_sslProtocols;
    private boolean m_useSmtps;

    public AbstractSMTPService() {
        this.init();
    }

    @ConfigProperty(value="STRING")
    @Order(value=10.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredHost() {
        return null;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=20.0)
    @ConfigPropertyValue(value="-1")
    protected int getConfiguredPort() {
        return -1;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=30.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredUseAuthentication() {
        return false;
    }

    @ConfigProperty(value="STRING")
    @Order(value=40.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredUsername() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=50.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredPassword() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=60.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredSubjectPrefix() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=70.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredDefaultFromEmail() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=80.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredUseSmtps() {
        return false;
    }

    @ConfigProperty(value="STRING")
    @Order(value=90.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredSslProtocols() {
        return null;
    }

    private void init() {
        this.setHost(this.getConfiguredHost());
        this.setPort(this.getConfiguredPort());
        this.setUsername(this.getConfiguredUsername());
        this.setPassword(this.getConfiguredPassword());
        this.setSubjectPrefix(this.getConfiguredSubjectPrefix());
        this.setDefaultFromEmail(this.getConfiguredDefaultFromEmail());
        this.setUseSmtps(this.getConfiguredUseSmtps());
        this.setSslProtocols(this.getConfiguredSslProtocols());
    }

    @Override
    public String getHost() {
        return this.m_host;
    }

    @Override
    public void setHost(String s) {
        this.m_host = s;
    }

    @Override
    public int getPort() {
        return this.m_port;
    }

    @Override
    public void setPort(int s) {
        this.m_port = s;
    }

    @Override
    public boolean isUseAuthentication() {
        return this.m_useAuthentication;
    }

    @Override
    public void setUseAuthentication(boolean useAuthentication) {
        this.m_useAuthentication = useAuthentication;
    }

    @Override
    public String getUsername() {
        return this.m_username;
    }

    @Override
    public void setUsername(String s) {
        this.m_username = s;
    }

    @Override
    public String getPassword() {
        return this.m_password;
    }

    @Override
    public void setPassword(String s) {
        this.m_password = s;
    }

    @Override
    public String getSubjectPrefix() {
        return this.m_subjectPrefix;
    }

    @Override
    public void setSubjectPrefix(String subjectPrefix) {
        this.m_subjectPrefix = subjectPrefix;
    }

    @Override
    public String getDefaultFromEmail() {
        return this.m_defaultFromEmail;
    }

    @Override
    public void setDefaultFromEmail(String defaultFromEmail) {
        this.m_defaultFromEmail = defaultFromEmail;
    }

    @Override
    public String getDebugReceiverEmail() {
        return this.m_debugReceiverEmail;
    }

    public void setDebugReceiverEmail(String emailAddress) {
        this.m_debugReceiverEmail = BundleContextUtility.resolve((String)emailAddress);
    }

    protected String getProtocol() {
        return this.isUseSmtps() ? "smtps" : "smtp";
    }

    @Override
    public boolean isUseSmtps() {
        return this.m_useSmtps;
    }

    @Override
    public void setUseSmtps(boolean useSmtps) {
        this.m_useSmtps = useSmtps;
    }

    @Override
    public String getSslProtocols() {
        return this.m_sslProtocols;
    }

    @Override
    public void setSslProtocols(String sslProtocols) {
        this.m_sslProtocols = sslProtocols;
    }

    @Override
    public void sendMessage(MimeMessage message) throws ProcessingException {
        this.sendMessage(message, null);
    }

    @Override
    public void sendMessage(MimeMessage message, Session session) throws ProcessingException {
        Transport transport = null;
        try {
            try {
                String defaultFromEmail;
                Address[] fromAddresses;
                if (session == null) {
                    session = this.createSession();
                }
                transport = session.getTransport(this.getProtocol());
                if (!StringUtility.isNullOrEmpty((String)this.getUsername())) {
                    if (StringUtility.isNullOrEmpty((String)this.getHost())) {
                        transport.connect(System.getProperty("mail." + this.getProtocol() + ".host"), this.getUsername(), this.getPassword());
                    } else {
                        transport.connect(this.getHost(), this.getUsername(), this.getPassword());
                    }
                } else {
                    transport.connect();
                }
                String subjectPrefix = this.getSubjectPrefix();
                if (!StringUtility.isNullOrEmpty((String)subjectPrefix)) {
                    String subject = String.valueOf(subjectPrefix) + (message.getSubject() != null ? message.getSubject() : "");
                    message.setSubject(subject);
                }
                Address[] allRecipients = message.getAllRecipients();
                String debugReceiverEmail = this.getDebugReceiverEmail();
                if (debugReceiverEmail != null) {
                    allRecipients = new Address[]{new InternetAddress(debugReceiverEmail)};
                    LOG.debug("SMTP Service: debug receiver email set to: " + debugReceiverEmail);
                }
                if (!((fromAddresses = message.getFrom()) != null && fromAddresses.length != 0 || StringUtility.isNullOrEmpty((String)(defaultFromEmail = this.getDefaultFromEmail())))) {
                    message.setFrom((Address)new InternetAddress(defaultFromEmail));
                }
                if (allRecipients != null && allRecipients.length > 0) {
                    transport.sendMessage((Message)message, allRecipients);
                    transport.close();
                    transport = null;
                }
            }
            catch (Exception e) {
                throw new ProcessingException("cannot send Mime Message.", (Throwable)e);
            }
        }
        finally {
            try {
                if (transport != null) {
                    transport.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected Session createSession() {
        Properties props = new Properties();
        props.setProperty("mail.transport.protocol", this.getProtocol());
        props.setProperty("mail." + this.getProtocol() + ".quitwait", "false");
        if (!StringUtility.isNullOrEmpty((String)this.m_host)) {
            props.setProperty("mail." + this.getProtocol() + ".host", this.m_host);
        }
        if (this.m_port > 0) {
            props.setProperty("mail." + this.getProtocol() + ".port", "" + this.m_port);
        }
        if (!StringUtility.isNullOrEmpty((String)this.m_username)) {
            props.setProperty("mail." + this.getProtocol() + ".user", this.m_username);
            props.setProperty("mail." + this.getProtocol() + ".auth", "" + this.m_useAuthentication);
        }
        if (!StringUtility.isNullOrEmpty((String)this.getSslProtocols())) {
            props.setProperty("mail." + this.getProtocol() + ".ssl.protocols", this.getSslProtocols());
        }
        return Session.getInstance((Properties)props, null);
    }
}

