/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.scout.rt.shared.TextsThreadLocal;
import org.eclipse.scout.rt.shared.services.common.text.ITextProviderService;
import org.eclipse.scout.service.SERVICES;

public class ScoutTexts {
    public static final QualifiedName JOB_PROPERTY_NAME = new QualifiedName(ScoutTexts.class.getName(), "ref");
    private static final ScoutTexts defaultInstance = new ScoutTexts();
    private final ITextProviderService[] m_textProviders;

    public ScoutTexts() {
        this((ITextProviderService[])SERVICES.getServices(ITextProviderService.class));
    }

    public ScoutTexts(ITextProviderService[] textProviders) {
        this.m_textProviders = textProviders;
    }

    public static String get(String key, String ... messageArguments) {
        return ScoutTexts.getInstance().getText(key, messageArguments);
    }

    public static String get(Locale locale, String key, String ... messageArguments) {
        return ScoutTexts.getInstance().getText(locale, key, messageArguments);
    }

    public static ScoutTexts getInstance() {
        ScoutTexts t = TextsThreadLocal.get();
        if (t == null) {
            t = defaultInstance;
        }
        return t;
    }

    public final String getText(String key, String ... messageArguments) {
        return this.getText((Locale)null, key, messageArguments);
    }

    public final String getText(Locale locale, String key, String ... messageArguments) {
        return this.getTextInternal(locale, key, messageArguments);
    }

    public Map<String, String> getTextMap(Locale locale) {
        HashMap<String, String> map = new HashMap<String, String>();
        ITextProviderService[] providers = this.getTextProviders();
        int i = providers.length - 1;
        while (i >= 0) {
            map.putAll(providers[i].getTextMap(locale));
            --i;
        }
        return map;
    }

    protected ITextProviderService[] getTextProviders() {
        return this.m_textProviders;
    }

    protected String getTextInternal(Locale locale, String key, String ... messageArguments) {
        ITextProviderService[] iTextProviderServiceArray = this.getTextProviders();
        int n = iTextProviderServiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITextProviderService provider = iTextProviderServiceArray[n2];
            String result = provider.getText(locale, key, messageArguments);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        return "{undefined text " + key + "}";
    }
}

