/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.form.fields;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.annotations.Replace;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.data.form.FormDataUtility;
import org.eclipse.scout.rt.shared.data.form.properties.AbstractPropertyData;

public abstract class AbstractFormFieldData
implements Serializable {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractFormFieldData.class);
    private static final long serialVersionUID = 1L;
    private Map<Class<?>, Class<? extends AbstractFormFieldData>> m_fieldDataReplacements;
    private Map<Class<? extends AbstractPropertyData>, AbstractPropertyData> m_propertyMap;
    private Map<Class<? extends AbstractFormFieldData>, AbstractFormFieldData> m_fieldMap;
    private boolean m_valueSet;

    public AbstractFormFieldData() {
        this.initConfig();
    }

    private Class<? extends AbstractPropertyData>[] getConfiguredPropertyDatas() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClasses((Class[])dca, AbstractPropertyData.class);
    }

    private Class<? extends AbstractFormFieldData>[] getConfiguredFieldDatas() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        Class[] fca = ConfigurationUtility.filterClasses((Class[])dca, AbstractFormFieldData.class);
        return ConfigurationUtility.removeReplacedClasses((Class[])fca);
    }

    protected void initConfig() {
        this.m_propertyMap = new HashMap<Class<? extends AbstractPropertyData>, AbstractPropertyData>();
        Class<? extends AbstractPropertyData>[] propArray = this.getConfiguredPropertyDatas();
        int i = 0;
        while (i < propArray.length) {
            try {
                AbstractPropertyData p = (AbstractPropertyData)ConfigurationUtility.newInnerInstance((Object)this, propArray[i]);
                this.m_propertyMap.put(p.getClass(), p);
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
            ++i;
        }
        HashMap<Class<? extends AbstractFormFieldData>, AbstractFormFieldData> map = new HashMap<Class<? extends AbstractFormFieldData>, AbstractFormFieldData>();
        Class[] fieldArray = this.getConfiguredFieldDatas();
        int i2 = 0;
        while (i2 < fieldArray.length) {
            try {
                AbstractFormFieldData f = (AbstractFormFieldData)ConfigurationUtility.newInnerInstance((Object)this, fieldArray[i2]);
                map.put(f.getClass(), f);
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
            ++i2;
        }
        if (map.size() > 0) {
            this.m_fieldMap = map;
            Map replacements = ConfigurationUtility.getReplacementMapping((Class[])fieldArray);
            if (!replacements.isEmpty()) {
                this.m_fieldDataReplacements = replacements;
            }
        }
    }

    public Map<String, Object> getValidationRules() {
        HashMap<String, Object> ruleMap = new HashMap<String, Object>();
        this.initValidationRules(ruleMap);
        return ruleMap;
    }

    protected void initValidationRules(Map<String, Object> ruleMap) {
    }

    public String getFieldId() {
        Class<?> c = this.getClass();
        while (c.isAnnotationPresent(Replace.class)) {
            c = c.getSuperclass();
        }
        String s = c.getName();
        int i = Math.max(s.lastIndexOf(36), s.lastIndexOf(46));
        s = s.substring(i + 1);
        return s;
    }

    public boolean isValueSet() {
        return this.m_valueSet;
    }

    public void setValueSet(boolean b) {
        this.m_valueSet = b;
    }

    public AbstractPropertyData getPropertyById(String id) {
        for (AbstractPropertyData p : this.m_propertyMap.values()) {
            if (!p.getPropertyId().equalsIgnoreCase(id)) continue;
            return p;
        }
        return null;
    }

    public <T extends AbstractPropertyData> T getPropertyByClass(Class<T> c) {
        return (T)this.m_propertyMap.get(c);
    }

    public <T extends AbstractPropertyData> void setPropertyByClass(Class<T> c, T v) {
        if (v == null) {
            this.m_propertyMap.remove(c);
        } else {
            this.m_propertyMap.put(c, v);
        }
    }

    public AbstractPropertyData[] getAllProperties() {
        return this.m_propertyMap != null ? this.m_propertyMap.values().toArray(new AbstractPropertyData[this.m_propertyMap.size()]) : new AbstractPropertyData[]{};
    }

    public AbstractFormFieldData getFieldById(String id) {
        if (this.m_fieldMap == null) {
            return null;
        }
        String fieldDataId = FormDataUtility.getFieldDataId(id);
        for (AbstractFormFieldData f : this.m_fieldMap.values()) {
            if (!f.getFieldId().equals(fieldDataId)) continue;
            return f;
        }
        return null;
    }

    public <T extends AbstractFormFieldData> T getFieldByClass(Class<T> c) {
        if (this.m_fieldMap == null) {
            return null;
        }
        Class<T> clazz = this.getReplacingFieldDataClass(c);
        return (T)this.m_fieldMap.get(clazz);
    }

    public <T extends AbstractFormFieldData> void setFieldByClass(Class<T> c, T v) {
        Class<T> clazz = this.getReplacingFieldDataClass(c);
        if (v == null) {
            if (this.m_fieldMap != null) {
                this.m_fieldMap.remove(clazz);
            }
        } else {
            if (this.m_fieldMap == null) {
                this.m_fieldMap = new HashMap<Class<? extends AbstractFormFieldData>, AbstractFormFieldData>();
            }
            this.m_fieldMap.put(clazz, v);
        }
    }

    private <T> Class<? extends T> getReplacingFieldDataClass(Class<T> c) {
        Class<? extends AbstractFormFieldData> replacingFieldClass;
        if (this.m_fieldDataReplacements != null && (replacingFieldClass = this.m_fieldDataReplacements.get(c)) != null) {
            return replacingFieldClass;
        }
        return c;
    }

    public AbstractFormFieldData[] getFields() {
        if (this.m_fieldMap == null) {
            return new AbstractFormFieldData[0];
        }
        return this.m_fieldMap.values().toArray(new AbstractFormFieldData[this.m_fieldMap.size()]);
    }
}

