/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.model;

import java.io.Serializable;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.beans.AbstractPropertyObserver;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelEntity;
import org.eclipse.scout.rt.shared.services.common.security.IAccessControlService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractDataModelEntity
extends AbstractPropertyObserver
implements IDataModelEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractDataModelEntity.class);
    private String m_id;
    private Permission m_visiblePermission;
    private boolean m_visibleGranted;
    private boolean m_visibleProperty;
    private boolean m_visible;
    private boolean m_oneToMany;
    private String m_text;
    private String m_iconId;
    private ArrayList<IDataModelAttribute> m_attributes = new ArrayList();
    private ArrayList<IDataModelEntity> m_entities = new ArrayList();
    private IDataModelEntity m_parentEntity;
    private boolean m_initializedChildEntities;
    private boolean m_initialized;

    public AbstractDataModelEntity() {
        this(true);
    }

    public AbstractDataModelEntity(boolean callInitConfig) {
        if (callInitConfig) {
            this.callInitConfig();
        }
    }

    protected void callInitConfig() {
        this.initConfig();
    }

    @ConfigProperty(value="TEXT")
    @Order(value=20.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredText() {
        return null;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=10.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredIconId() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=50.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=50.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredOneToMany() {
        return true;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execInitEntity() throws ProcessingException {
    }

    private Class<? extends IDataModelAttribute>[] getConfiguredAttributes() {
        Class[] c = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.sortFilteredClassesByOrderAnnotation((Class[])c, IDataModelAttribute.class);
    }

    private Class<? extends IDataModelEntity>[] getConfiguredEntities() {
        Class[] c = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.sortFilteredClassesByOrderAnnotation((Class[])c, IDataModelEntity.class);
    }

    protected void initConfig() {
        this.m_visibleGranted = true;
        this.setText(this.getConfiguredText());
        this.setIconId(this.getConfiguredIconId());
        this.setVisible(this.getConfiguredVisible());
        this.setOneToMany(this.getConfiguredOneToMany());
        ArrayList<IDataModelAttribute> attributes = new ArrayList<IDataModelAttribute>();
        Class<? extends IDataModelAttribute>[] classArray = this.getConfiguredAttributes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends IDataModelAttribute> c = classArray[n2];
            try {
                IDataModelAttribute a = (IDataModelAttribute)ConfigurationUtility.newInnerInstance((Object)this, c);
                attributes.add(a);
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
            ++n2;
        }
        this.injectAttributesInternal(attributes);
        this.m_attributes = new ArrayList();
        this.m_attributes.addAll(attributes);
        for (IDataModelAttribute a : this.m_attributes) {
            a.setParentEntity(this);
        }
        this.m_entities = new ArrayList();
    }

    @Override
    public Map<String, String> getMetaDataOfEntity() {
        return null;
    }

    @Override
    public final void initEntity() throws ProcessingException {
        if (this.m_initialized) {
            return;
        }
        try {
            this.execInitEntity();
        }
        catch (Throwable t) {
            LOG.error("entity " + this, t);
        }
        IPropertyObserver[] iPropertyObserverArray = this.getAttributes();
        int n = iPropertyObserverArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDataModelAttribute a = iPropertyObserverArray[n2];
            try {
                a.initAttribute();
            }
            catch (Throwable t) {
                LOG.error("attribute " + this + "/" + a, t);
            }
            ++n2;
        }
        this.m_initialized = true;
        iPropertyObserverArray = this.getEntities();
        n = iPropertyObserverArray.length;
        n2 = 0;
        while (n2 < n) {
            IPropertyObserver e = iPropertyObserverArray[n2];
            try {
                e.initEntity();
            }
            catch (Throwable t) {
                LOG.error("entity " + this + "/" + e, t);
            }
            ++n2;
        }
    }

    @Override
    public Permission getVisiblePermission() {
        return this.m_visiblePermission;
    }

    @Override
    public void setVisiblePermission(Permission p) {
        this.m_visiblePermission = p;
        boolean b = p != null ? ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).checkPermission(p) : true;
        this.setVisibleGranted(b);
    }

    @Override
    public boolean isVisibleGranted() {
        return this.m_visibleGranted;
    }

    @Override
    public void setVisibleGranted(boolean b) {
        this.m_visibleGranted = b;
        this.calculateVisible();
    }

    @Override
    public boolean isVisible() {
        return this.m_visible;
    }

    @Override
    public void setVisible(boolean b) {
        this.m_visibleProperty = b;
        this.calculateVisible();
    }

    @Override
    public boolean isOneToMany() {
        return this.m_oneToMany;
    }

    @Override
    public void setOneToMany(boolean b) {
        this.m_oneToMany = b;
    }

    private void calculateVisible() {
        this.m_visible = this.m_visibleGranted && this.m_visibleProperty;
    }

    @Override
    public String getIconId() {
        return this.m_iconId;
    }

    @Override
    public void setIconId(String s) {
        this.m_iconId = s;
    }

    @Override
    public String getText() {
        return this.m_text;
    }

    @Override
    public void setText(String s) {
        this.m_text = s;
    }

    @Override
    public IDataModelAttribute[] getAttributes() {
        return this.m_attributes.toArray(new IDataModelAttribute[0]);
    }

    @Override
    public IDataModelEntity[] getEntities() {
        return this.m_entities.toArray(new IDataModelEntity[0]);
    }

    @Override
    public IDataModelAttribute getAttribute(Class<? extends IDataModelAttribute> attributeClazz) {
        for (IDataModelAttribute attribute : this.m_attributes) {
            if (attribute.getClass() != attributeClazz) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public IDataModelEntity getEntity(Class<? extends IDataModelEntity> entityClazz) {
        for (IDataModelEntity entity : this.m_entities) {
            if (entity.getClass() != entityClazz) continue;
            return entity;
        }
        return null;
    }

    @Override
    public IDataModelEntity getParentEntity() {
        return this.m_parentEntity;
    }

    @Override
    public void setParentEntity(IDataModelEntity parent) {
        this.m_parentEntity = parent;
    }

    @Override
    public void initializeChildEntities(Map<Class<? extends IDataModelEntity>, IDataModelEntity> instanceMap) {
        if (!this.m_initializedChildEntities) {
            this.m_initializedChildEntities = true;
            ArrayList<IDataModelEntity> newConfiguredInstances = new ArrayList<IDataModelEntity>();
            ArrayList<IDataModelEntity> entities = new ArrayList<IDataModelEntity>();
            Class<? extends IDataModelEntity>[] classArray = this.getConfiguredEntities();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<? extends IDataModelEntity> c = classArray[n2];
                try {
                    IDataModelEntity e = instanceMap.get(c);
                    if (e == null) {
                        e = (IDataModelEntity)ConfigurationUtility.newInnerInstance((Object)this, c);
                        newConfiguredInstances.add(e);
                        instanceMap.put(c, e);
                    }
                    entities.add(e);
                }
                catch (Exception ex) {
                    LOG.warn(null, (Throwable)ex);
                }
                ++n2;
            }
            this.injectEntitiesInternal(entities);
            this.m_entities.clear();
            this.m_entities.addAll(entities);
            for (IDataModelEntity e : this.m_entities) {
                if (e.getParentEntity() == this) continue;
                e.setParentEntity(this);
            }
            for (IDataModelEntity e : this.m_entities) {
                if (!newConfiguredInstances.contains(e) && instanceMap.containsKey(e.getClass())) continue;
                e.initializeChildEntities(instanceMap);
            }
        }
    }

    protected void injectAttributesInternal(List<IDataModelAttribute> attributeList) {
    }

    protected void injectEntitiesInternal(List<IDataModelEntity> entityList) {
    }
}

