/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.model;

import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.model.DataModelConstants;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttributeOp;

public final class DataModelAttributeOp
implements DataModelConstants {
    private DataModelAttributeOp() {
    }

    public static IDataModelAttributeOp create(int operator) {
        switch (operator) {
            case 45: {
                return new Between(45);
            }
            case 47: {
                return new Between(47);
            }
            case 48: {
                return new Between(48);
            }
            case 27: {
                return new NEQ(27);
            }
            case 59: {
                return new NEQ(59);
            }
            case 60: {
                return new NEQ(60);
            }
            case 26: {
                return new LT(26);
            }
            case 57: {
                return new LT(57);
            }
            case 58: {
                return new LT(58);
            }
            case 25: {
                return new LE(25);
            }
            case 55: {
                return new LE(55);
            }
            case 56: {
                return new LE(56);
            }
            case 20: {
                return new EQ(20);
            }
            case 49: {
                return new EQ(49);
            }
            case 50: {
                return new EQ(50);
            }
            case 23: {
                return new GT(23);
            }
            case 53: {
                return new GT(53);
            }
            case 54: {
                return new GT(54);
            }
            case 22: {
                return new GE(22);
            }
            case 51: {
                return new GE(51);
            }
            case 52: {
                return new GE(52);
            }
            case 2: {
                return new DateIsInDays(2);
            }
            case 3: {
                return new DateIsInGEDays(3);
            }
            case 4: {
                return new DateIsInGEMonths(4);
            }
            case 5: {
                return new DateIsInLEDays(5);
            }
            case 6: {
                return new DateIsInLEMonths(6);
            }
            case 7: {
                return new DateIsInLastDays(7);
            }
            case 8: {
                return new DateIsInLastMonths(8);
            }
            case 9: {
                return new DateIsInMonths(9);
            }
            case 10: {
                return new DateIsInNextDays(10);
            }
            case 11: {
                return new DateIsInNextMonths(11);
            }
            case 12: {
                return new DateIsNotToday(12);
            }
            case 13: {
                return new DateIsToday(13);
            }
            case 14: {
                return new DateTimeIsInGEHours(14);
            }
            case 15: {
                return new DateTimeIsInGEMinutes(15);
            }
            case 16: {
                return new DateTimeIsInLEHours(16);
            }
            case 17: {
                return new DateTimeIsInLEMinutes(17);
            }
            case 18: {
                return new DateTimeIsNotNow(18);
            }
            case 19: {
                return new DateTimeIsNow(19);
            }
            case 21: {
                return new EndsWith(21);
            }
            case 29: {
                return new NotEndsWith(29);
            }
            case 24: {
                return new In(24);
            }
            case 1: {
                return new Contains(1);
            }
            case 46: {
                return new Like(46);
            }
            case 30: {
                return new NotIn(30);
            }
            case 28: {
                return new NotContains(28);
            }
            case 31: {
                return new NotNull(31);
            }
            case 34: {
                return new NumberNotNull(34);
            }
            case 33: {
                return new Null(33);
            }
            case 35: {
                return new NumberNull(35);
            }
            case 36: {
                return new StartsWith(36);
            }
            case 32: {
                return new NotStartsWith(32);
            }
            case 37: {
                return new TimeIsInGEHours(37);
            }
            case 38: {
                return new TimeIsInGEMinutes(38);
            }
            case 39: {
                return new TimeIsInHours(39);
            }
            case 40: {
                return new TimeIsInLEHours(40);
            }
            case 41: {
                return new TimeIsInLEMinutes(41);
            }
            case 42: {
                return new TimeIsInMinutes(42);
            }
            case 44: {
                return new TimeIsNow(44);
            }
            case 43: {
                return new TimeIsNotNow(43);
            }
        }
        return null;
    }

    private static abstract class AbstractDataModelOp
    implements IDataModelAttributeOp,
    DataModelConstants {
        private final int m_operator;

        AbstractDataModelOp(int operator) {
            this.m_operator = operator;
        }

        @Override
        public final int getOperator() {
            return this.m_operator;
        }

        @Override
        public String getShortText() {
            return this.getText();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return this.getClass() == obj.getClass() && this.m_operator == ((AbstractDataModelOp)obj).m_operator;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public static String buildText(Integer aggregationType, String attributeText, String opText, String ... valueTexts) {
            String verboseValue;
            String text1 = null;
            if (valueTexts != null && valueTexts.length > 0) {
                text1 = valueTexts[0];
            }
            String text2 = null;
            if (valueTexts != null && valueTexts.length > 1) {
                text2 = valueTexts[1];
            }
            StringBuilder b = new StringBuilder();
            if (aggregationType != null) {
                switch (aggregationType) {
                    case 5: {
                        b.append(ScoutTexts.get("ComposerFieldAggregationAvg", attributeText));
                        break;
                    }
                    case 1: {
                        b.append(ScoutTexts.get("ComposerFieldAggregationCount", attributeText));
                        break;
                    }
                    case 4: {
                        b.append(ScoutTexts.get("ComposerFieldAggregationMax", attributeText));
                        break;
                    }
                    case 6: {
                        b.append(ScoutTexts.get("ComposerFieldAggregationMedian", attributeText));
                        break;
                    }
                    case 3: {
                        b.append(ScoutTexts.get("ComposerFieldAggregationMin", attributeText));
                        break;
                    }
                    case 2: {
                        b.append(ScoutTexts.get("ComposerFieldAggregationSum", attributeText));
                        break;
                    }
                    default: {
                        b.append(attributeText);
                        break;
                    }
                }
            } else {
                b.append(attributeText);
            }
            if (opText.indexOf("{0}") >= 0) {
                verboseValue = opText;
                if (verboseValue.indexOf("{0}") >= 0 && text1 != null) {
                    verboseValue = verboseValue.replace("{0}", text1);
                }
                if (verboseValue.indexOf("{1}") >= 0 && text2 != null) {
                    verboseValue = verboseValue.replace("{1}", text2);
                }
            } else {
                verboseValue = opText;
                if (text1 != null) {
                    verboseValue = String.valueOf(verboseValue) + " " + text1;
                }
                if (text2 != null) {
                    verboseValue = String.valueOf(verboseValue) + " " + text2;
                }
            }
            b.append(" ");
            b.append(verboseValue);
            return b.toString();
        }
    }

    private static class Between
    extends AbstractDataModelOp {
        Between(int operator) {
            super(operator);
        }

        @Override
        public String getShortText() {
            return ScoutTexts.get("LogicBetweenShort", new String[0]);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            if (StringUtility.isNullOrEmpty((String)valueTexts[0])) {
                return Between.buildText(aggregationType, attributeText, ScoutTexts.get("LogicLE", new String[0]), valueTexts[1]);
            }
            if (StringUtility.isNullOrEmpty((String)valueTexts[1])) {
                return Between.buildText(aggregationType, attributeText, ScoutTexts.get("LogicGE", new String[0]), valueTexts[0]);
            }
            return Between.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicBetween", new String[0]);
        }

        @Override
        public int getType() {
            return -1;
        }
    }

    private static class Contains
    extends AbstractDataModelOp {
        Contains(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return Contains.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicLike", new String[0]);
        }

        @Override
        public int getType() {
            return -1;
        }
    }

    private static class DateIsInDays
    extends AbstractDataModelOp {
        DateIsInDays(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return DateIsInDays.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicDateIsInDays", new String[0]);
        }

        @Override
        public int getType() {
            return 8;
        }
    }

    private static class DateIsInGEDays
    extends AbstractDataModelOp {
        DateIsInGEDays(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return DateIsInGEDays.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicDateIsInGEDays", new String[0]);
        }

        @Override
        public int getType() {
            return 8;
        }
    }

    private static class DateIsInGEMonths
    extends AbstractDataModelOp {
        DateIsInGEMonths(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return DateIsInGEMonths.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicDateIsInGEMonths", new String[0]);
        }

        @Override
        public int getType() {
            return 8;
        }
    }

    private static class DateIsInLEDays
    extends AbstractDataModelOp {
        DateIsInLEDays(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return DateIsInLEDays.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicDateIsInLEDays", new String[0]);
        }

        @Override
        public int getType() {
            return 8;
        }
    }

    private static class DateIsInLEMonths
    extends AbstractDataModelOp {
        DateIsInLEMonths(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return DateIsInLEMonths.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicDateIsInLEMonths", new String[0]);
        }

        @Override
        public int getType() {
            return 8;
        }
    }

    private static class DateIsInLastDays
    extends AbstractDataModelOp {
        DateIsInLastDays(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return DateIsInLastDays.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicDateIsInLastDays", new String[0]);
        }

        @Override
        public int getType() {
            return 8;
        }
    }

    private static class DateIsInLastMonths
    extends AbstractDataModelOp {
        DateIsInLastMonths(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return DateIsInLastMonths.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicDateIsInLastMonths", new String[0]);
        }

        @Override
        public int getType() {
            return 8;
        }
    }

    private static class DateIsInMonths
    extends AbstractDataModelOp {
        DateIsInMonths(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return DateIsInMonths.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicDateIsInMonths", new String[0]);
        }

        @Override
        public int getType() {
            return 8;
        }
    }

    private static class DateIsInNextDays
    extends AbstractDataModelOp {
        DateIsInNextDays(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return DateIsInNextDays.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicDateIsInNextDays", new String[0]);
        }

        @Override
        public int getType() {
            return 8;
        }
    }

    private static class DateIsInNextMonths
    extends AbstractDataModelOp {
        DateIsInNextMonths(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return DateIsInNextMonths.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicDateIsInNextMonths", new String[0]);
        }

        @Override
        public int getType() {
            return 8;
        }
    }

    private static class DateIsNotToday
    extends AbstractDataModelOp {
        DateIsNotToday(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return DateIsNotToday.buildText(aggregationType, attributeText, ScoutTexts.get("LogicDateIsNotToday", new String[0]), new String[0]);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicDateIsNotToday", new String[0]);
        }

        @Override
        public int getType() {
            return 0;
        }
    }

    private static class DateIsToday
    extends AbstractDataModelOp {
        DateIsToday(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return DateIsToday.buildText(aggregationType, attributeText, ScoutTexts.get("LogicDateIsToday", new String[0]), new String[0]);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicDateIsToday", new String[0]);
        }

        @Override
        public int getType() {
            return 0;
        }
    }

    private static class DateTimeIsInGEHours
    extends AbstractDataModelOp {
        DateTimeIsInGEHours(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return DateTimeIsInGEHours.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicDateTimeIsInGEHours", new String[0]);
        }

        @Override
        public int getType() {
            return 8;
        }
    }

    private static class DateTimeIsInGEMinutes
    extends AbstractDataModelOp {
        DateTimeIsInGEMinutes(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return DateTimeIsInGEMinutes.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicDateTimeIsInGEMinutes", new String[0]);
        }

        @Override
        public int getType() {
            return 8;
        }
    }

    private static class DateTimeIsInLEHours
    extends AbstractDataModelOp {
        DateTimeIsInLEHours(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return DateTimeIsInLEHours.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicDateTimeIsInLEHours", new String[0]);
        }

        @Override
        public int getType() {
            return 8;
        }
    }

    private static class DateTimeIsInLEMinutes
    extends AbstractDataModelOp {
        DateTimeIsInLEMinutes(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return DateTimeIsInLEMinutes.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicDateTimeIsInLEMinutes", new String[0]);
        }

        @Override
        public int getType() {
            return 8;
        }
    }

    private static class DateTimeIsNotNow
    extends AbstractDataModelOp {
        DateTimeIsNotNow(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return DateTimeIsNotNow.buildText(aggregationType, attributeText, ScoutTexts.get("LogicDateTimeIsNotNow", new String[0]), new String[0]);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicDateTimeIsNotNow", new String[0]);
        }

        @Override
        public int getType() {
            return 0;
        }
    }

    private static class DateTimeIsNow
    extends AbstractDataModelOp {
        DateTimeIsNow(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return DateTimeIsNow.buildText(aggregationType, attributeText, ScoutTexts.get("LogicDateTimeIsNow", new String[0]), new String[0]);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicDateTimeIsNow", new String[0]);
        }

        @Override
        public int getType() {
            return 0;
        }
    }

    private static class EQ
    extends AbstractDataModelOp {
        EQ(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return EQ.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicEQ", new String[0]);
        }

        @Override
        public int getType() {
            return -1;
        }
    }

    private static class EndsWith
    extends AbstractDataModelOp {
        EndsWith(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return EndsWith.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicEndsWith", new String[0]);
        }

        @Override
        public int getType() {
            return -1;
        }
    }

    private static class GE
    extends AbstractDataModelOp {
        GE(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return GE.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicGE", new String[0]);
        }

        @Override
        public int getType() {
            return -1;
        }
    }

    private static class GT
    extends AbstractDataModelOp {
        GT(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return GT.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicGT", new String[0]);
        }

        @Override
        public int getType() {
            return -1;
        }
    }

    private static class In
    extends AbstractDataModelOp {
        In(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return In.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicIn", new String[0]);
        }

        @Override
        public int getType() {
            return -1;
        }
    }

    private static class LE
    extends AbstractDataModelOp {
        LE(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return LE.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicLE", new String[0]);
        }

        @Override
        public int getType() {
            return -1;
        }
    }

    private static class LT
    extends AbstractDataModelOp {
        LT(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return LT.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicLT", new String[0]);
        }

        @Override
        public int getType() {
            return -1;
        }
    }

    private static class Like
    extends AbstractDataModelOp {
        Like(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return Like.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicEQ", new String[0]);
        }

        @Override
        public int getType() {
            return 15;
        }
    }

    private static class NEQ
    extends AbstractDataModelOp {
        NEQ(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return NEQ.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicNEQ", new String[0]);
        }

        @Override
        public int getType() {
            return -1;
        }
    }

    private static class NotContains
    extends AbstractDataModelOp {
        NotContains(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return NotContains.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicNotLike", new String[0]);
        }

        @Override
        public int getType() {
            return -1;
        }
    }

    private static class NotEndsWith
    extends AbstractDataModelOp {
        NotEndsWith(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return NotEndsWith.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicNotEndsWith", new String[0]);
        }

        @Override
        public int getType() {
            return -1;
        }
    }

    private static class NotIn
    extends AbstractDataModelOp {
        NotIn(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return NotIn.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicNotIn", new String[0]);
        }

        @Override
        public int getType() {
            return -1;
        }
    }

    private static class NotNull
    extends AbstractDataModelOp {
        NotNull(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return NotNull.buildText(aggregationType, attributeText, ScoutTexts.get("LogicNotNull", new String[0]), new String[0]);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicNotNull", new String[0]);
        }

        @Override
        public int getType() {
            return 0;
        }
    }

    private static class NotStartsWith
    extends AbstractDataModelOp {
        NotStartsWith(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return NotStartsWith.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicNotStartsWith", new String[0]);
        }

        @Override
        public int getType() {
            return -1;
        }
    }

    private static class Null
    extends AbstractDataModelOp {
        Null(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return Null.buildText(aggregationType, attributeText, ScoutTexts.get("LogicNull", new String[0]), new String[0]);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicNull", new String[0]);
        }

        @Override
        public int getType() {
            return 0;
        }
    }

    private static class NumberNotNull
    extends AbstractDataModelOp {
        NumberNotNull(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return NumberNotNull.buildText(aggregationType, attributeText, ScoutTexts.get("LogicNotNull", new String[0]), new String[0]);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicNotNull", new String[0]);
        }

        @Override
        public int getType() {
            return 0;
        }
    }

    private static class NumberNull
    extends AbstractDataModelOp {
        NumberNull(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return NumberNull.buildText(aggregationType, attributeText, ScoutTexts.get("LogicNull", new String[0]), new String[0]);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicNull", new String[0]);
        }

        @Override
        public int getType() {
            return 0;
        }
    }

    private static class StartsWith
    extends AbstractDataModelOp {
        StartsWith(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return StartsWith.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicStartsWith", new String[0]);
        }

        @Override
        public int getType() {
            return -1;
        }
    }

    private static class TimeIsInGEHours
    extends AbstractDataModelOp {
        TimeIsInGEHours(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return TimeIsInGEHours.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicTimeIsInGEHours", new String[0]);
        }

        @Override
        public int getType() {
            return 8;
        }
    }

    private static class TimeIsInGEMinutes
    extends AbstractDataModelOp {
        TimeIsInGEMinutes(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return TimeIsInGEMinutes.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicTimeIsInGEMinutes", new String[0]);
        }

        @Override
        public int getType() {
            return 8;
        }
    }

    private static class TimeIsInHours
    extends AbstractDataModelOp {
        TimeIsInHours(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return TimeIsInHours.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicTimeIsInHours", new String[0]);
        }

        @Override
        public int getType() {
            return 8;
        }
    }

    private static class TimeIsInLEHours
    extends AbstractDataModelOp {
        TimeIsInLEHours(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return TimeIsInLEHours.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicTimeIsInLEHours", new String[0]);
        }

        @Override
        public int getType() {
            return 8;
        }
    }

    private static class TimeIsInLEMinutes
    extends AbstractDataModelOp {
        TimeIsInLEMinutes(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return TimeIsInLEMinutes.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicTimeIsInLEMinutes", new String[0]);
        }

        @Override
        public int getType() {
            return 8;
        }
    }

    private static class TimeIsInMinutes
    extends AbstractDataModelOp {
        TimeIsInMinutes(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return TimeIsInMinutes.buildText(aggregationType, attributeText, this.getText(), valueTexts);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicTimeIsInMinutes", new String[0]);
        }

        @Override
        public int getType() {
            return 8;
        }
    }

    private static class TimeIsNotNow
    extends AbstractDataModelOp {
        TimeIsNotNow(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return TimeIsNotNow.buildText(aggregationType, attributeText, ScoutTexts.get("LogicTimeIsNotNow", new String[0]), new String[0]);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicTimeIsNotNow", new String[0]);
        }

        @Override
        public int getType() {
            return 0;
        }
    }

    private static class TimeIsNow
    extends AbstractDataModelOp {
        TimeIsNow(int operator) {
            super(operator);
        }

        @Override
        public String createVerboseText(Integer aggregationType, String attributeText, String[] valueTexts) {
            return TimeIsNow.buildText(aggregationType, attributeText, ScoutTexts.get("LogicTimeIsNow", new String[0]), new String[0]);
        }

        @Override
        public String getText() {
            return ScoutTexts.get("LogicTimeIsNow", new String[0]);
        }

        @Override
        public int getType() {
            return 0;
        }
    }
}

