/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.scout.rt.shared.data.model.AttributePath;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelEntity;

public final class EntityPath {
    public static final EntityPath EMPTY = new EntityPath();
    private final List<IDataModelEntity> m_entityPath;
    private final int m_hashCode;

    public EntityPath() {
        this(null);
    }

    public EntityPath(List<IDataModelEntity> entityPath) {
        this(entityPath, true);
    }

    public EntityPath(List<IDataModelEntity> entityPath, boolean useCopyOfList) {
        this.m_entityPath = entityPath == null || entityPath.size() == 0 ? Collections.emptyList() : (useCopyOfList ? Collections.unmodifiableList(new ArrayList<IDataModelEntity>(entityPath)) : Collections.unmodifiableList(entityPath));
        this.m_hashCode = this.m_entityPath.hashCode();
    }

    public List<IDataModelEntity> elements() {
        return this.m_entityPath;
    }

    public IDataModelEntity firstElement() {
        return this.m_entityPath.size() > 0 ? this.m_entityPath.get(0) : null;
    }

    public IDataModelEntity lastElement() {
        return this.m_entityPath.size() > 0 ? this.m_entityPath.get(this.m_entityPath.size() - 1) : null;
    }

    public int size() {
        return this.m_entityPath.size();
    }

    public IDataModelEntity get(int index) {
        return this.m_entityPath.get(index);
    }

    public boolean isEmpty() {
        return this == EMPTY || this.size() == 0;
    }

    public EntityPath parent() {
        if (this.size() <= 1) {
            return EMPTY;
        }
        return new EntityPath(this.m_entityPath.subList(0, this.m_entityPath.size() - 1), false);
    }

    public EntityPath subPath(int fromIndex, int toIndex) {
        if (this.size() <= 0) {
            return EMPTY;
        }
        return new EntityPath(this.m_entityPath.subList(fromIndex, toIndex), false);
    }

    public EntityPath addToFront(IDataModelEntity e) {
        if (e == null) {
            return this;
        }
        ArrayList<IDataModelEntity> newList = new ArrayList<IDataModelEntity>(this.size() + 1);
        newList.add(e);
        newList.addAll(this.m_entityPath);
        return new EntityPath(newList, false);
    }

    public EntityPath addToEnd(IDataModelEntity e) {
        if (e == null) {
            return this;
        }
        ArrayList<IDataModelEntity> newList = new ArrayList<IDataModelEntity>(this.size() + 1);
        newList.addAll(this.m_entityPath);
        newList.add(e);
        return new EntityPath(newList, false);
    }

    public EntityPath addToFront(EntityPath p) {
        if (p == null || p.size() == 0) {
            return this;
        }
        ArrayList<IDataModelEntity> newList = new ArrayList<IDataModelEntity>(this.size() + 1);
        newList.addAll(p.m_entityPath);
        newList.addAll(this.m_entityPath);
        return new EntityPath(newList, false);
    }

    public EntityPath addToEnd(EntityPath p) {
        if (p == null || p.size() == 0) {
            return this;
        }
        ArrayList<IDataModelEntity> newList = new ArrayList<IDataModelEntity>(this.size() + 1);
        newList.addAll(this.m_entityPath);
        newList.addAll(p.m_entityPath);
        return new EntityPath(newList, false);
    }

    public AttributePath addToEnd(IDataModelAttribute a) {
        if (a == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        return new AttributePath(this, a);
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EntityPath)) {
            return false;
        }
        EntityPath other = (EntityPath)obj;
        return this.m_entityPath.equals(other.m_entityPath);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append("[");
        if (this.isEmpty()) {
            buf.append("<EMPTY>");
        } else {
            int index = 0;
            for (IDataModelEntity e : this.m_entityPath) {
                if (index > 0) {
                    buf.append(".");
                }
                buf.append(e.getClass().getSimpleName());
                buf.append("(" + e.getText() + ")");
                ++index;
            }
        }
        buf.append("]");
        return buf.toString();
    }
}

