/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.calendar;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.scout.rt.shared.services.common.calendar.RecurrenceException;

public class RecurrencePattern
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_DAILY = 119535;
    public static final int TYPE_WEEKLY = 119536;
    public static final int TYPE_MONTHLY = 119537;
    public static final int TYPE_MONTHLY_SPEC = 119538;
    public static final int TYPE_YEARLY = 119539;
    public static final int TYPE_YEARLY_SPEC = 119540;
    public static final int INST_FIRST = 119530;
    public static final int INST_SECOND = 119531;
    public static final int INST_THIRD = 119532;
    public static final int INST_FOURTH = 119533;
    public static final int INST_LAST = 119534;
    public static final int INST_NONE = 0;
    public static final int MASK_SUN = 1;
    public static final int MASK_MON = 2;
    public static final int MASK_TUE = 4;
    public static final int MASK_WED = 8;
    public static final int MASK_THU = 16;
    public static final int MASK_FRI = 32;
    public static final int MASK_SAT = 64;
    private long m_lastModified;
    private boolean m_regenerate;
    private int m_startTimeMinutes;
    private int m_endTimeMinutes;
    private int m_durationMinutes;
    private Date m_firstDate;
    private Date m_lastDate;
    private int m_occurrences;
    private boolean m_noEndDate;
    private int m_type;
    private int m_interval;
    private int m_instance;
    private int m_dayOfWeekBits;
    private int m_dayOfMonth;
    private int m_monthOfYear;
    private ArrayList<RecurrenceException> m_recurrenceExceptions = new ArrayList();

    public long getLastModified() {
        return this.m_lastModified;
    }

    public void setLastModified(long b) {
        this.m_lastModified = b;
    }

    public void setRegenerate(boolean v) {
        this.m_regenerate = v;
    }

    public boolean isRegenerate() {
        return this.m_regenerate;
    }

    public void setStartTimeMinutes(int v) {
        this.m_startTimeMinutes = v;
    }

    public int getStartTimeMinutes() {
        return this.m_startTimeMinutes;
    }

    public void setEndTimeMinutes(int v) {
        this.m_endTimeMinutes = v;
    }

    public int getEndTimeMinutes() {
        return this.m_endTimeMinutes;
    }

    public void setStartTimeAsDate(Date d) {
        if (d != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(d);
            this.m_startTimeMinutes = c.get(11) * 60 + c.get(12);
        }
    }

    public Date getStartTimeAsDate() {
        Calendar c = Calendar.getInstance();
        c.set(2000, 1, 1, this.m_startTimeMinutes / 60, this.m_startTimeMinutes % 60, 0);
        return c.getTime();
    }

    public void setEndTimeAsDate(Date d) {
        if (d != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(d);
            this.m_endTimeMinutes = c.get(11) * 60 + c.get(12);
        }
    }

    public Date getEndTimeAsDate() {
        Calendar c = Calendar.getInstance();
        c.set(2000, 1, 1, this.m_endTimeMinutes / 60, this.m_endTimeMinutes % 60, 0);
        return c.getTime();
    }

    public void setDurationMinutes(int v) {
        if (v > 0x10000000) {
            v = 0;
        }
        this.m_durationMinutes = v;
    }

    public int getDurationMinutes() {
        return this.m_durationMinutes;
    }

    public void setFirstDate(Date v) {
        this.m_firstDate = v;
    }

    public Date getFirstDate() {
        return this.m_firstDate;
    }

    public void setLastDate(Date v) {
        this.m_lastDate = v;
    }

    public Date getLastDate() {
        return this.m_lastDate;
    }

    public void setOccurrences(int v) {
        this.m_occurrences = v;
    }

    public int getOccurrences() {
        return this.m_occurrences;
    }

    public void setNoEndDate(boolean v) {
        this.m_noEndDate = v;
    }

    public boolean getNoEndDate() {
        return this.m_noEndDate;
    }

    public void setType(int v) {
        if (v < 119535 || v > 119540) {
            throw new IllegalArgumentException("type (" + v + ") must be in [TYPE_DAILY,TYPE_YEARLY_SPEC]");
        }
        this.m_type = v;
    }

    public int getType() {
        return this.m_type;
    }

    public void setInterval(int v) {
        this.m_interval = v;
    }

    public int getInterval() {
        return this.m_interval;
    }

    public void setInstance(int v) {
        if (v != 0 && (v < 119530 || v > 119534)) {
            throw new IllegalArgumentException("instance (" + v + ") must be in [INST_FIRST,INST_LAST]");
        }
        this.m_instance = v;
    }

    public int getInstance() {
        return this.m_instance;
    }

    public void setDayOfWeek(int bits) {
        this.m_dayOfWeekBits = bits;
    }

    public int getDayOfWeek() {
        return this.m_dayOfWeekBits;
    }

    public void setDayOfMonth(int v) {
        this.m_dayOfMonth = v;
    }

    public int getDayOfMonth() {
        return this.m_dayOfMonth;
    }

    public void setMonthOfYear(int v) {
        this.m_monthOfYear = v;
    }

    public int getMonthOfYear() {
        return this.m_monthOfYear;
    }

    public List<RecurrenceException> getRecurrenceExceptions() {
        return this.m_recurrenceExceptions;
    }

    public void addRecurrenceException(RecurrenceException ex) {
        this.m_recurrenceExceptions.add(ex);
    }

    public Set<Date> createStartDates(Date startDate, Date endDate) {
        if (this.m_firstDate != null && this.m_firstDate.after(startDate)) {
            startDate = this.m_firstDate;
        }
        if (this.m_lastDate != null && this.m_lastDate.before(endDate)) {
            endDate = this.m_lastDate;
        }
        startDate = RecurrencePattern.applyTime(startDate, 0, 0, 0);
        endDate = RecurrencePattern.applyTime(endDate, 23, 59, 59);
        int min = this.getStartTimeMinutes() % 1440;
        GregorianCalendar startRecCal = new GregorianCalendar();
        startRecCal.setTime(RecurrencePattern.applyTime(this.m_firstDate, min / 60, min % 60, 0));
        TreeSet<Date> list = new TreeSet<Date>();
        if (this.m_interval <= 0) {
            this.m_interval = 1;
        }
        switch (this.getType()) {
            case 119535: {
                this.createDailyStartDates(startRecCal, startDate, endDate, list);
                break;
            }
            case 119536: {
                this.createWeeklyStartDates(startRecCal, startDate, endDate, list);
                break;
            }
            case 119537: {
                this.createMonthlyStartDates(startRecCal, startDate, endDate, list);
                break;
            }
            case 119538: {
                this.createMonthlySpecStartDates(startRecCal, startDate, endDate, list);
                break;
            }
            case 119539: {
                this.createYearlyStartDates(startRecCal, startDate, endDate, list);
                break;
            }
            case 119540: {
                this.createYearlySpecStartDates(startRecCal, startDate, endDate, list);
            }
        }
        for (RecurrenceException recEx : this.m_recurrenceExceptions) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(recEx.getOriginalStartDate());
            cal.set(10, 0);
            cal.set(11, min / 60);
            cal.set(12, min % 60);
            cal.set(13, 0);
            cal.set(14, 0);
            list.remove(cal.getTime());
        }
        return list;
    }

    private void createDailyStartDates(Calendar cal, Date startDate, Date endDate, Set<Date> list) {
        Date d = cal.getTime();
        int count = 0;
        while (d.compareTo(endDate) <= 0) {
            ++count;
            if (d.compareTo(startDate) >= 0) {
                list.add(d);
            }
            cal.add(5, this.m_interval);
            d = cal.getTime();
            if (!this.m_noEndDate && this.m_lastDate == null && count >= this.m_occurrences) break;
        }
    }

    private boolean isInWeekMask(int bitMask, Calendar cal) {
        return (bitMask & 1 << cal.get(7) - 1) != 0;
    }

    private void createWeeklyStartDates(Calendar cal, Date startDate, Date endDate, Set<Date> list) {
        Date d = cal.getTime();
        int count = 0;
        while (d.compareTo(endDate) <= 0) {
            Calendar weekCal = Calendar.getInstance();
            weekCal.setTime(d);
            int i = 0;
            while (i < 7) {
                if (this.isInWeekMask(this.m_dayOfWeekBits, weekCal)) {
                    Date dWeek = weekCal.getTime();
                    ++count;
                    if (dWeek.compareTo(startDate) >= 0) {
                        list.add(dWeek);
                    }
                    if (!this.m_noEndDate && this.m_lastDate == null && count >= this.m_occurrences) break;
                }
                weekCal.add(5, 1);
                ++i;
            }
            cal.add(3, this.m_interval);
            d = cal.getTime();
            if (!this.m_noEndDate && this.m_lastDate == null && count >= this.m_occurrences) break;
        }
    }

    private void createMonthlyStartDates(Calendar cal, Date startDate, Date endDate, Set<Date> list) {
        Date d = cal.getTime();
        int count = 0;
        while (d.compareTo(endDate) <= 0) {
            Calendar monthCal = Calendar.getInstance();
            monthCal.setTime(d);
            int dayOfCurrentMonth = this.m_dayOfMonth;
            if (dayOfCurrentMonth > monthCal.getActualMaximum(5)) {
                dayOfCurrentMonth = monthCal.getActualMaximum(5);
            }
            int i = 0;
            while (i < 31) {
                if (monthCal.get(5) == dayOfCurrentMonth) {
                    Date dMonth = monthCal.getTime();
                    ++count;
                    if (dMonth.compareTo(startDate) < 0) break;
                    list.add(dMonth);
                    break;
                }
                monthCal.add(5, 1);
                ++i;
            }
            cal.add(2, this.m_interval);
            d = cal.getTime();
            if (!this.m_noEndDate && this.m_lastDate == null && count >= this.m_occurrences) break;
        }
    }

    private void createMonthlySpecStartDates(Calendar cal, Date startDate, Date endDate, Set<Date> list) {
        Date d = cal.getTime();
        int count = 0;
        int inst = 0;
        switch (this.m_instance) {
            case 119530: {
                inst = 1;
                break;
            }
            case 119531: {
                inst = 2;
                break;
            }
            case 119532: {
                inst = 3;
                break;
            }
            case 119533: {
                inst = 4;
                break;
            }
            case 119534: {
                inst = 1000000;
            }
        }
        while (d.compareTo(endDate) <= 0) {
            Calendar monthCal = Calendar.getInstance();
            monthCal.setTime(d);
            int instCount = 0;
            Date lastValid = null;
            int i = 1;
            int ni = monthCal.getActualMaximum(5);
            while (i <= ni) {
                monthCal.set(5, i);
                if (this.isInWeekMask(this.m_dayOfWeekBits, monthCal)) {
                    lastValid = monthCal.getTime();
                    if (++instCount == inst) break;
                }
                ++i;
            }
            if (lastValid != null && lastValid.compareTo(this.m_firstDate) >= 0) {
                ++count;
                if (lastValid.compareTo(startDate) >= 0) {
                    list.add(lastValid);
                }
            }
            cal.add(2, this.m_interval);
            d = cal.getTime();
            if (!this.m_noEndDate && this.m_lastDate == null && count >= this.m_occurrences) break;
        }
    }

    private void createYearlyStartDates(Calendar cal, Date startDate, Date endDate, Set<Date> list) {
        Date d = cal.getTime();
        int count = 0;
        while (d.compareTo(endDate) <= 0) {
            Calendar monthCal = Calendar.getInstance();
            monthCal.setTime(d);
            monthCal.set(5, 1);
            monthCal.set(2, this.m_monthOfYear - 1);
            monthCal.set(5, this.m_dayOfMonth);
            if (monthCal.getTime().compareTo(this.m_firstDate) >= 0) {
                Date dMonth = monthCal.getTime();
                ++count;
                if (dMonth.compareTo(startDate) >= 0) {
                    list.add(dMonth);
                }
            }
            cal.add(1, this.m_interval);
            d = cal.getTime();
            if (!this.m_noEndDate && this.m_lastDate == null && count >= this.m_occurrences) break;
        }
    }

    private void createYearlySpecStartDates(Calendar cal, Date startDate, Date endDate, Set<Date> list) {
        Date d = cal.getTime();
        int count = 0;
        int inst = 0;
        switch (this.m_instance) {
            case 119530: {
                inst = 1;
                break;
            }
            case 119531: {
                inst = 2;
                break;
            }
            case 119532: {
                inst = 3;
                break;
            }
            case 119533: {
                inst = 4;
                break;
            }
            case 119534: {
                inst = 100000;
            }
        }
        while (d.compareTo(endDate) <= 0) {
            Calendar monthCal = Calendar.getInstance();
            monthCal.setTime(d);
            monthCal.set(5, 1);
            monthCal.set(2, this.m_monthOfYear - 1);
            int instCount = 0;
            Date lastValid = null;
            int i = 1;
            int ni = monthCal.getActualMaximum(5);
            while (i <= ni) {
                monthCal.set(5, i);
                if (this.isInWeekMask(this.m_dayOfWeekBits, monthCal)) {
                    lastValid = monthCal.getTime();
                    if (++instCount == inst) break;
                }
                ++i;
            }
            if (lastValid != null && lastValid.compareTo(this.m_firstDate) >= 0) {
                ++count;
                if (lastValid.compareTo(startDate) >= 0) {
                    list.add(lastValid);
                }
            }
            cal.add(1, this.m_interval);
            d = cal.getTime();
            if (!this.m_noEndDate && this.m_lastDate == null && count >= this.m_occurrences) break;
        }
    }

    public static Date applyTime(Date d, int hour, int minute, int second) {
        if (d != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(d);
            cal.set(10, 0);
            cal.set(11, hour);
            cal.set(12, minute);
            cal.set(13, second);
            cal.set(14, 0);
            d = cal.getTime();
        }
        return d;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("Pattern[");
        buf.append("startTimeMinutes=" + this.m_startTimeMinutes + ",");
        buf.append("endTimeMinutes=" + this.m_endTimeMinutes + ",");
        buf.append("durationMinutes=" + this.m_durationMinutes + ",");
        buf.append("firstDate=" + this.m_firstDate + ",");
        buf.append("lastDate=" + this.m_lastDate + ",");
        buf.append("occurrences=" + this.m_occurrences + ",");
        buf.append("type=" + this.m_type + ",");
        buf.append("interval=" + this.m_interval + ",");
        buf.append("instance=" + this.m_instance + ",");
        buf.append("dayOfWeekBits=" + Integer.toBinaryString(this.m_dayOfWeekBits) + ",");
        buf.append("dayOfMonth=" + this.m_dayOfMonth + ",");
        buf.append("regenerate=" + this.m_regenerate + ",");
        buf.append("]");
        return buf.toString();
    }
}

