/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.testing.client;

import java.util.HashMap;
import java.util.List;
import javax.security.auth.Subject;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.services.common.session.IClientSessionRegistryService;
import org.eclipse.scout.rt.shared.ui.UserAgent;
import org.eclipse.scout.rt.testing.shared.TestingUtility;
import org.eclipse.scout.service.AbstractService;
import org.eclipse.scout.service.SERVICES;
import org.eclipse.scout.testing.client.Activator;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;

public class TestingClientSessionRegistryService
extends AbstractService
implements IClientSessionRegistryService {
    private final HashMap<String, IClientSession> m_cache = new HashMap();
    private final Object m_cacheLock = new Object();
    private final IClientSessionRegistryService m_delegate;
    private List<ServiceRegistration> m_serviceRegistrations;

    public TestingClientSessionRegistryService(IClientSessionRegistryService delegate) {
        this.m_delegate = delegate;
    }

    public static TestingClientSessionRegistryService registerTestingClientSessionRegistryService() {
        IClientSessionRegistryService delegateClientSessionRegistryService = (IClientSessionRegistryService)SERVICES.getService(IClientSessionRegistryService.class);
        TestingClientSessionRegistryService testingClientSessionRegistryService = new TestingClientSessionRegistryService(delegateClientSessionRegistryService);
        List regs = TestingUtility.registerServices((Bundle)Activator.getDefault().getBundle(), (int)1000, (Object[])new Object[]{testingClientSessionRegistryService});
        testingClientSessionRegistryService.setServiceRegistrations(regs);
        return testingClientSessionRegistryService;
    }

    public static void unregisterTestingClientSessionRegistryService(TestingClientSessionRegistryService service) {
        if (service == null || service.getServiceRegistrations() == null) {
            return;
        }
        TestingUtility.unregisterServices(service.getServiceRegistrations());
    }

    public List<ServiceRegistration> getServiceRegistrations() {
        return this.m_serviceRegistrations;
    }

    public void setServiceRegistrations(List<ServiceRegistration> serviceRegistrations) {
        this.m_serviceRegistrations = serviceRegistrations;
    }

    public IClientSessionRegistryService getDelegateService() {
        return this.m_delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends IClientSession> T newClientSession(Class<T> clazz, UserAgent userAgent) {
        Object object = this.m_cacheLock;
        synchronized (object) {
            IClientSession clientSession = this.m_cache.get(clazz.getName());
            if (clientSession != null) {
                return (T)clientSession;
            }
            clientSession = this.m_delegate.newClientSession(clazz, userAgent);
            this.m_cache.put(clazz.getName(), clientSession);
            return (T)clientSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends IClientSession> T newClientSession(Class<T> clazz, Subject subject, String virtualSessionId, UserAgent userAgent) {
        Object object = this.m_cacheLock;
        synchronized (object) {
            IClientSession clientSession = this.m_cache.get(clazz.getName());
            if (clientSession != null) {
                return (T)clientSession;
            }
            clientSession = this.m_delegate.newClientSession(clazz, subject, virtualSessionId, userAgent);
            this.m_cache.put(clazz.getName(), clientSession);
            return (T)clientSession;
        }
    }
}

