/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.testing.client.servicetunnel.http;

import java.net.CookieManager;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.IClientSession;

public class MultiClientSessionCookieStore
implements CookieStore {
    private final Object m_cookieStoreLock = new Object();
    private final Map<IClientSession, CookieStore> m_cookieStores = new HashMap<IClientSession, CookieStore>();
    private final CookieStore m_defaultCookieStore = new CookieManager().getCookieStore();

    @Override
    public void add(URI uri, HttpCookie cookie) {
        this.getDelegate().add(uri, cookie);
    }

    @Override
    public List<HttpCookie> get(URI uri) {
        return this.getDelegate().get(uri);
    }

    @Override
    public List<HttpCookie> getCookies() {
        return this.getDelegate().getCookies();
    }

    @Override
    public List<URI> getURIs() {
        return this.getDelegate().getURIs();
    }

    @Override
    public boolean remove(URI uri, HttpCookie cookie) {
        return this.getDelegate().remove(uri, cookie);
    }

    @Override
    public boolean removeAll() {
        return this.getDelegate().removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CookieStore getDelegate() {
        IClientSession currentSession = ClientJob.getCurrentSession();
        if (currentSession == null) {
            return this.m_defaultCookieStore;
        }
        Object object = this.m_cookieStoreLock;
        synchronized (object) {
            CookieStore cookieStore = this.m_cookieStores.get(currentSession);
            if (cookieStore == null) {
                cookieStore = new CookieManager().getCookieStore();
                this.m_cookieStores.put(currentSession, cookieStore);
            }
            return cookieStore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionStopped(IClientSession clientSession) {
        Object object = this.m_cookieStoreLock;
        synchronized (object) {
            this.m_cookieStores.remove(clientSession);
        }
    }
}

