/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.workbench.window.editor;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class ScoutFormEditorInput
implements IEditorInput {
    private final IRwtEnvironment m_uiEnvironment;
    private final IForm m_scoutObject;

    public ScoutFormEditorInput(IForm scoutObject, IRwtEnvironment uiEnvironment) {
        this.m_scoutObject = scoutObject;
        this.m_uiEnvironment = uiEnvironment;
    }

    private IRwtEnvironment getUiEnvironment() {
        return this.m_uiEnvironment;
    }

    public IForm getScoutObject() {
        return this.m_scoutObject;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        Image icon = this.getUiEnvironment().getIcon(this.getScoutObject().getIconId());
        return ImageDescriptor.createFromImage((Image)icon);
    }

    public String getName() {
        return StringUtility.nvl((Object)this.getScoutObject().getTitle(), (String)"");
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return StringUtility.nvl((Object)this.getScoutObject().getSubTitle(), (String)"");
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ScoutFormEditorInput)) {
            return false;
        }
        ScoutFormEditorInput other = (ScoutFormEditorInput)obj;
        IForm form = this.getScoutObject();
        IForm otherForm = other.getScoutObject();
        if (form.getClass().getName().equals(otherForm.getClass().getName()) && form.getHandler().isOpenExclusive() && otherForm.getHandler().isOpenExclusive()) {
            Object otherKey;
            Object key;
            block6: {
                try {
                    key = form.computeExclusiveKey();
                    otherKey = otherForm.computeExclusiveKey();
                    if (key != null && otherKey != null) break block6;
                    return false;
                }
                catch (ProcessingException e) {
                    return false;
                }
            }
            return key.equals(otherKey);
        }
        return form.equals(otherForm);
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 37 + this.getScoutObject().hashCode();
        return hash;
    }
}

