/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.ext.browser;

import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.service.ResourceManager;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.rap.ext.browser.IHyperlinkCallback;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;

public class BrowserExtension {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BrowserExtension.class);
    private static final Pattern LOCAL_URL_PATTERN = Pattern.compile("(['\"])(http://local[?/][^'\"]*)(['\"])", 34);
    private static final String HYPERLINK_FUNCTION_NAME = "scoutActivateLocalUrl";
    private final Browser m_browser;
    private final HashMap<String, String> m_hyperlinkMap;
    private BrowserFunction m_hyperlinkBrowserFunction;
    private IHyperlinkCallback m_hyperlinkCallback;
    private String m_resourceFolderId;
    private HashSet<String> m_tempFileNames = new HashSet();

    public BrowserExtension(Browser b, IHyperlinkCallback hyperlinkCallback) {
        this.m_browser = b;
        this.m_hyperlinkCallback = hyperlinkCallback;
        this.m_hyperlinkMap = new HashMap();
        this.m_resourceFolderId = UUID.randomUUID().toString();
    }

    public void attach() {
        if (this.m_hyperlinkBrowserFunction == null) {
            this.m_hyperlinkBrowserFunction = this.createLocalHyperlinkFunction();
        }
    }

    private BrowserFunction createLocalHyperlinkFunction() {
        return new BrowserFunction(this.m_browser, this.getLocalHyperlinkFunctionName()){

            public Object function(Object[] arguments) {
                String localUrl = (String)BrowserExtension.this.m_hyperlinkMap.get(arguments[0]);
                if (localUrl == null) {
                    LOG.error("Hyperlink could not be activated. No url specified.");
                    return null;
                }
                if (BrowserExtension.this.m_hyperlinkCallback == null) {
                    LOG.error("Hyperlink could not be activated. Please specify the runnable to be executed.");
                    return null;
                }
                BrowserExtension.this.m_hyperlinkCallback.execute(localUrl);
                return null;
            }
        };
    }

    public void detach() {
        if (this.m_hyperlinkBrowserFunction != null) {
            this.m_hyperlinkBrowserFunction.dispose();
            this.m_hyperlinkBrowserFunction = null;
        }
        this.clearLocalHyperlinkCache();
        this.clearResourceCache();
    }

    public String addResource(String name, InputStream content) {
        if ((name = name.replaceAll("\\\\", "/")) == null || name.length() == 0) {
            return null;
        }
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        String uniqueName = String.valueOf(this.m_resourceFolderId) + name;
        this.m_tempFileNames.add(uniqueName);
        ResourceManager resourceManager = RWT.getResourceManager();
        resourceManager.register(uniqueName, content);
        return resourceManager.getLocation(uniqueName);
    }

    public void clearResourceCache() {
        ResourceManager resourceManager = RWT.getResourceManager();
        try {
            for (String name : this.m_tempFileNames) {
                resourceManager.unregister(name);
            }
        }
        finally {
            this.m_tempFileNames.clear();
        }
    }

    public String adaptLocalHyperlinks(String html) {
        return BrowserExtension.rewriteLocalHyperlinks(html, this.m_hyperlinkMap, this.getLocalHyperlinkFunctionName());
    }

    public void clearLocalHyperlinkCache() {
        this.m_hyperlinkMap.clear();
    }

    protected String getLocalHyperlinkFunctionName() {
        return HYPERLINK_FUNCTION_NAME;
    }

    private static String rewriteLocalHyperlinks(String html, Map<String, String> generatedMappings, String callbackFuncName) {
        if (html == null) {
            return html;
        }
        StringBuilder buf = new StringBuilder();
        Matcher m = LOCAL_URL_PATTERN.matcher(html);
        int nextFind = 0;
        while (m.find(nextFind)) {
            String localUrl = m.group(2);
            String externalKey = "" + generatedMappings.size();
            String callableURL = "javascript:" + callbackFuncName + "('" + externalKey + "');";
            buf.append(html.substring(nextFind, m.start()));
            buf.append(m.group(1));
            buf.append(callableURL);
            buf.append(m.group(3));
            generatedMappings.put(externalKey, localUrl);
            nextFind = m.end();
        }
        if (nextFind == 0) {
            return html;
        }
        if (nextFind < html.length()) {
            buf.append(html.substring(nextFind));
        }
        return buf.toString();
    }
}

