/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.splitbox;

import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.splitbox.ISplitBox;
import org.eclipse.scout.rt.ui.rap.DefaultValidateRoot;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.splitbox.IRwtScoutSplitBox;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;

public class RwtScoutSplitBox
extends RwtScoutFieldComposite<ISplitBox>
implements IRwtScoutSplitBox {
    private OptimisticLock lockSplitter = new OptimisticLock();

    @Override
    protected void initializeUi(Composite parent) {
        SashForm container = this.getUiEnvironment().getFormToolkit().createSashForm(parent, ((ISplitBox)this.getScoutObject()).isSplitHorizontal() ? 256 : 512);
        container.setData("LayoutValidateManager.validateRoot", (Object)new DefaultValidateRoot((Composite)container));
        IFormField[] iFormFieldArray = ((ISplitBox)this.getScoutObject()).getFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField scoutField = iFormFieldArray[n2];
            this.getUiEnvironment().createFormField((Composite)container, scoutField);
            ++n2;
        }
        this.setUiContainer((Composite)container);
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        if (((ISplitBox)this.getScoutObject()).isCacheSplitterPosition()) {
            this.setCachedSplitterPosition();
        } else {
            this.setSplitterPositionFromScout();
        }
    }

    protected void setCachedSplitterPosition() {
        Runnable job = new Runnable(){

            @Override
            public void run() {
                final int[] a = ClientUIPreferences.getInstance((IClientSession)RwtScoutSplitBox.this.getUiEnvironment().getClientSession()).getSplitterPosition((ISplitBox)RwtScoutSplitBox.this.getScoutObject());
                RwtScoutSplitBox.this.getUiEnvironment().invokeUiLater(new Runnable(){

                    @Override
                    public void run() {
                        if (a != null && a.length == 2) {
                            RwtScoutSplitBox.this.setSplitterPosition(a[0], a[1]);
                        } else {
                            RwtScoutSplitBox.this.setSplitterPositionFromScout();
                        }
                    }
                });
            }
        };
        this.getUiEnvironment().invokeScoutLater(job, 0L);
    }

    @Override
    protected void detachScout() {
        this.setSplitterPositionFromUi();
        super.detachScout();
    }

    @Override
    public SashForm getUiContainer() {
        return (SashForm)super.getUiContainer();
    }

    protected void setSplitterPositionFromUi() {
        if (((ISplitBox)this.getScoutObject()).isCacheSplitterPosition()) {
            int[] weights = this.getUiContainer().getWeights();
            this.cacheSplitterPosition(weights);
        } else {
            this.cacheSplitterPosition(null);
        }
    }

    protected void cacheSplitterPosition(final int[] weights) {
        Runnable job = new Runnable(){

            @Override
            public void run() {
                ClientUIPreferences.getInstance((IClientSession)RwtScoutSplitBox.this.getUiEnvironment().getClientSession()).setSplitterPosition((ISplitBox)RwtScoutSplitBox.this.getScoutObject(), weights);
            }
        };
        this.getUiEnvironment().invokeScoutLater(job, 0L);
    }

    protected void setSplitterPositionFromScout() {
        if (this.getUiContainer().isDisposed()) {
            return;
        }
        try {
            if (this.lockSplitter.acquire()) {
                int[] weights;
                double position = ((ISplitBox)this.getScoutObject()).getSplitterPosition();
                weights = new int[]{(int)(position * 100.0), 100 - weights[0]};
                this.getUiContainer().setWeights(weights);
            }
        }
        finally {
            this.lockSplitter.release();
        }
    }

    protected void setSplitterPosition(int leftWidth, int rightWidth) {
        if (this.getUiContainer().isDisposed()) {
            return;
        }
        try {
            int total;
            if (this.lockSplitter.acquire() && (total = leftWidth + rightWidth) > 0) {
                int leftPct = leftWidth * 100 / total;
                int rightPct = rightWidth * 100 / total;
                this.getUiContainer().setWeights(new int[]{leftPct, rightPct});
            }
        }
        finally {
            this.lockSplitter.release();
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        if (!"splitterEnabled".equals(name) && "splitterPosition".equals(name)) {
            this.setSplitterPositionFromScout();
        }
        super.handleScoutPropertyChange(name, newValue);
    }
}

