/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.tablefield;

import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutlineTableForm;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartFieldProposalForm;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.ITableField;
import org.eclipse.scout.rt.ui.rap.LogicalGridData;
import org.eclipse.scout.rt.ui.rap.LogicalGridLayout;
import org.eclipse.scout.rt.ui.rap.basic.table.IRwtScoutTable;
import org.eclipse.scout.rt.ui.rap.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.rap.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.tablefield.IRwtScoutTableField;
import org.eclipse.scout.rt.ui.rap.form.fields.tablefield.IRwtTableStatus;
import org.eclipse.scout.rt.ui.rap.form.fields.tablefield.RwtTableStatus;
import org.eclipse.scout.rt.ui.rap.services.common.patchedclass.IPatchedClassService;
import org.eclipse.scout.rt.ui.rap.util.RwtLayoutUtility;
import org.eclipse.scout.rt.ui.rap.window.desktop.IRwtScoutActionBar;
import org.eclipse.scout.service.SERVICES;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class RwtScoutTableField
extends RwtScoutFieldComposite<ITableField<? extends ITable>>
implements IRwtScoutTableField {
    private IRwtScoutTable m_tableComposite;
    private IRwtTableStatus m_tableStatus;
    private IRwtScoutActionBar m_actionBar;
    private Composite m_tableContainer;

    @Override
    protected void initializeUi(Composite parent) {
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getUiEnvironment().getFormToolkit().createStatusLabel(container, (IFormField)this.getScoutObject());
        this.setUiContainer(container);
        this.setUiLabel(label);
        LogicalGridLayout containerLayout = new LogicalGridLayout(1, 0);
        container.setLayout((Layout)containerLayout);
    }

    @Override
    protected void setFieldEnabled(Control field, boolean b) {
        if (this.m_tableComposite != null) {
            this.m_tableComposite.setEnabledFromScout(b);
        }
    }

    @Override
    public Control getUiField() {
        return super.getUiField();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.setTableFromScout(((ITableField)this.getScoutObject()).getTable());
    }

    protected void setTableFromScout(ITable table) {
        if (this.m_tableComposite != null && !this.m_tableComposite.isUiDisposed()) {
            this.m_tableComposite.dispose();
        }
        if (this.m_tableStatus != null) {
            this.m_tableStatus.dispose();
        }
        if (this.m_actionBar != null) {
            this.m_actionBar.dispose();
        }
        this.m_tableComposite = null;
        this.m_tableStatus = null;
        if (table != null) {
            LogicalGridData tableGridData = LogicalGridDataBuilder.createField(((ITableField)this.getScoutObject()).getGridData());
            this.m_tableComposite = this.createRwtScoutTable();
            this.m_tableContainer = null;
            if (this.dontCreateTableContainer()) {
                this.m_tableComposite.createUiField(this.getUiContainer(), table, this.getUiEnvironment());
                this.m_tableComposite.getUiField().setLayoutData((Object)tableGridData);
            } else {
                Composite tableContainer = new Composite(this.getUiContainer(), 0);
                tableContainer.setData("org.eclipse.rap.rwt.customVariant", (Object)"tableField");
                tableContainer.setLayout((Layout)new LogicalGridLayout(1, 0));
                this.m_tableComposite.createUiField(tableContainer, table, this.getUiEnvironment());
                tableContainer.setLayoutData((Object)tableGridData);
                this.m_tableContainer = tableContainer;
            }
            if (((ITableField)this.getScoutObject()).isTableStatusVisible()) {
                this.m_tableStatus = this.createRwtTableStatus();
            }
            this.m_actionBar = this.createRwtScoutActionBar();
            this.setUiField(this.m_tableComposite.getUiField());
            this.setTableStatusFromScout();
        }
        if (!this.getUiContainer().isDisposed()) {
            this.getUiContainer().layout(true, true);
        }
    }

    protected boolean dontCreateTableContainer() {
        IForm form = null;
        if (this.getScoutObject() != null) {
            form = ((ITableField)this.getScoutObject()).getForm();
        }
        return form == null || form instanceof ISmartFieldProposalForm || form instanceof IOutlineTableForm;
    }

    protected IRwtScoutTable createRwtScoutTable() {
        if (((ITableField)this.getScoutObject()).getForm() instanceof ISmartFieldProposalForm) {
            return ((IPatchedClassService)SERVICES.getService(IPatchedClassService.class)).createRwtScoutTable("proposal-form");
        }
        return ((IPatchedClassService)SERVICES.getService(IPatchedClassService.class)).createRwtScoutTable();
    }

    protected void setTableStatusFromScout() {
        if (this.m_tableStatus != null) {
            IProcessingStatus dataStatus = ((ITableField)this.getScoutObject()).getTablePopulateStatus();
            IProcessingStatus selectionStatus = ((ITableField)this.getScoutObject()).getTableSelectionStatus();
            this.m_tableStatus.setStatus(dataStatus, selectionStatus);
        }
    }

    protected IRwtTableStatus createRwtTableStatus() {
        return new RwtTableStatus(this.getUiContainer(), this.getUiEnvironment(), (ITableField)this.getScoutObject());
    }

    protected IRwtScoutActionBar createRwtScoutActionBar() {
        return null;
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        super.setEnabledFromScout(b);
        if (this.m_tableContainer != null) {
            this.m_tableContainer.setData("org.eclipse.rap.rwt.customVariant", (Object)(b ? "tableField" : "tableFieldDisabled"));
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("table")) {
            this.setTableFromScout((ITable)newValue);
            if (this.isCreated()) {
                RwtLayoutUtility.invalidateLayout(this.getUiEnvironment(), (Control)this.getUiContainer());
            }
        } else if (name.equals("tableSelectionStatus")) {
            this.setTableStatusFromScout();
        } else if (name.equals("tablePopulateStatus")) {
            this.setTableStatusFromScout();
        }
    }
}

