/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.window.desktop.toolbar;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.tool.IToolButton;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.AbstractFormToolButton;
import org.eclipse.scout.rt.ui.rap.basic.RwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.services.common.patchedclass.IPatchedClassService;
import org.eclipse.scout.rt.ui.rap.util.RwtLayoutUtility;
import org.eclipse.scout.rt.ui.rap.window.desktop.toolbar.IRwtScoutToolButton;
import org.eclipse.scout.rt.ui.rap.window.desktop.toolbar.IRwtScoutToolButtonBar;
import org.eclipse.scout.rt.ui.rap.window.desktop.toolbar.IRwtScoutToolButtonForPatch;
import org.eclipse.scout.service.SERVICES;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RwtScoutToolButtonBar
extends RwtScoutComposite<IDesktop>
implements IRwtScoutToolButtonBar<IDesktop> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutToolButtonBar.class);
    private static final String VARIANT_TOOL_BUTTON_BAR = "toolButtonBar";
    private static final String VARIANT_TOOL_BUTTON_BAR_ACTIVE = "toolButtonBar-active";
    private static final String VARIANT_TOOLBAR_CONTAINER = "toolbarContainer";
    private static final String VARIANT_TOOL_BUTTON_BAR_COLLAPSE_BUTTON = "toolButtonBarCollapseButton";
    private static final String VARIANT_TOOL_BUTTON_BUTTON_ACTIVE = "toolButton-active";
    private static final String VARIANT_TOOL_BUTTON = "toolButton";
    private HashMap<IToolButton, IRwtScoutToolButton> m_toolTabItems;
    private Label m_toolButtonsLabel;
    private PropertyChangeListener m_toolbuttonPropertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(final PropertyChangeEvent e) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    if (!RwtScoutToolButtonBar.this.isUiDisposed()) {
                        RwtScoutToolButtonBar.this.handleScoutToolButtonPropertyChange(e.getPropertyName(), e.getNewValue());
                    }
                }
            };
            RwtScoutToolButtonBar.this.getUiEnvironment().invokeUiLater(t);
        }
    };
    private Composite m_toolButtonContainer;
    private Button m_toolButtonCollapseButton;

    public RwtScoutToolButtonBar() {
        this.m_toolTabItems = new HashMap();
    }

    @Override
    protected void initializeUi(Composite parent) {
        Composite toolButtonBar = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        toolButtonBar.setData("org.eclipse.rap.rwt.customVariant", (Object)VARIANT_TOOL_BUTTON_BAR);
        if (this.isShowingCollapseButtonEnabled()) {
            this.m_toolButtonCollapseButton = this.getUiEnvironment().getFormToolkit().createButton(toolButtonBar, "", 8);
            this.m_toolButtonCollapseButton.setData("org.eclipse.rap.rwt.customVariant", (Object)VARIANT_TOOL_BUTTON_BAR_COLLAPSE_BUTTON);
            this.m_toolButtonCollapseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
                private static final long serialVersionUID = 1L;

                public void widgetSelected(SelectionEvent e) {
                    RwtScoutToolButtonBar.this.collapseToolView();
                }
            });
        }
        if (this.isShowingLabelEnabled()) {
            this.m_toolButtonsLabel = this.getUiEnvironment().getFormToolkit().createLabel(toolButtonBar, "", 0x1000000);
            this.m_toolButtonsLabel.setData("org.eclipse.rap.rwt.customVariant", (Object)VARIANT_TOOL_BUTTON);
            this.m_toolButtonsLabel.addMouseListener((MouseListener)new MouseAdapter(){
                private static final long serialVersionUID = 1L;

                public void mouseDown(MouseEvent e) {
                    RwtScoutToolButtonBar.this.collapseToolView();
                }
            });
        }
        this.m_toolButtonContainer = this.getUiEnvironment().getFormToolkit().createComposite(toolButtonBar);
        this.m_toolButtonContainer.setData("org.eclipse.rap.rwt.customVariant", (Object)VARIANT_TOOL_BUTTON_BAR);
        IToolButton[] iToolButtonArray = ((IDesktop)this.getScoutObject()).getToolButtons();
        int n = iToolButtonArray.length;
        int n2 = 0;
        while (n2 < n) {
            IToolButton scoutButton = iToolButtonArray[n2];
            if (scoutButton instanceof AbstractFormToolButton) {
                String simpleClassName = scoutButton.getClass().getSimpleName();
                String variant = VARIANT_TOOL_BUTTON;
                String activeVariant = VARIANT_TOOL_BUTTON_BUTTON_ACTIVE;
                variant = String.valueOf(variant) + "-" + simpleClassName;
                activeVariant = String.valueOf(activeVariant) + "-" + simpleClassName;
                IRwtScoutToolButtonForPatch uiToolButton = ((IPatchedClassService)SERVICES.getService(IPatchedClassService.class)).createRwtScoutToolButton(false, true, variant, activeVariant);
                uiToolButton.createUiField(this.m_toolButtonContainer, scoutButton, this.getUiEnvironment());
                this.m_toolTabItems.put(scoutButton, uiToolButton);
            }
            ++n2;
        }
        GridLayout toolButtonBarLayout = RwtLayoutUtility.createGridLayoutNoSpacing(3, false);
        toolButtonBarLayout.marginLeft = 10;
        toolButtonBarLayout.marginRight = 10;
        toolButtonBar.setLayout((Layout)toolButtonBarLayout);
        if (this.m_toolButtonCollapseButton != null) {
            GridData collapseButtonLayoutData = new GridData(4);
            collapseButtonLayoutData.heightHint = 15;
            collapseButtonLayoutData.widthHint = 15;
            collapseButtonLayoutData.exclude = true;
            this.m_toolButtonCollapseButton.setLayoutData((Object)collapseButtonLayoutData);
        }
        if (this.m_toolButtonsLabel != null) {
            GridData labelData = new GridData(548);
            labelData.exclude = true;
            this.m_toolButtonsLabel.setLayoutData((Object)labelData);
        }
        GridData tabFolderLayoutData = new GridData(128);
        this.m_toolButtonContainer.setLayoutData((Object)tabFolderLayoutData);
        RowLayout layout = new RowLayout(256);
        layout.marginBottom = 0;
        layout.spacing = 15;
        this.m_toolButtonContainer.setLayout((Layout)layout);
        for (IRwtScoutToolButton b : this.m_toolTabItems.values()) {
            RowData data = new RowData();
            Object o = b.getUiField().getLayoutData();
            if (o instanceof RowData) {
                data = (RowData)o;
            }
            data.width = 32;
            data.height = 28;
            b.getUiField().setLayoutData((Object)data);
        }
        this.setUiContainer(toolButtonBar);
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        IToolButton[] iToolButtonArray = ((IDesktop)this.getScoutObject()).getToolButtons();
        int n = iToolButtonArray.length;
        int n2 = 0;
        while (n2 < n) {
            IToolButton scoutButton = iToolButtonArray[n2];
            scoutButton.addPropertyChangeListener(this.m_toolbuttonPropertyListener);
            ++n2;
        }
        this.updateToolButtonLabel();
    }

    @Override
    protected void detachScout() {
        super.detachScout();
        IToolButton[] iToolButtonArray = ((IDesktop)this.getScoutObject()).getToolButtons();
        int n = iToolButtonArray.length;
        int n2 = 0;
        while (n2 < n) {
            IToolButton scoutButton = iToolButtonArray[n2];
            scoutButton.removePropertyChangeListener(this.m_toolbuttonPropertyListener);
            ++n2;
        }
    }

    protected void collapseToolView() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                IToolButton[] iToolButtonArray = ((IDesktop)RwtScoutToolButtonBar.this.getScoutObject()).getToolButtons();
                int n = iToolButtonArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IToolButton scoutButton = iToolButtonArray[n2];
                    if (scoutButton.isSelected()) {
                        scoutButton.getUIFacade().setSelectedFromUI(false);
                    }
                    ++n2;
                }
            }
        };
        this.getUiEnvironment().invokeScoutLater(r, 0L);
    }

    protected void updateToolButtonLabel() {
        String label = null;
        IToolButton[] iToolButtonArray = ((IDesktop)this.getScoutObject()).getToolButtons();
        int n = iToolButtonArray.length;
        int n2 = 0;
        while (n2 < n) {
            IToolButton scoutButton = iToolButtonArray[n2];
            if (scoutButton instanceof AbstractFormToolButton && scoutButton.isSelected()) {
                label = scoutButton.getText();
                this.m_toolButtonContainer.setData("org.eclipse.rap.rwt.customVariant", (Object)VARIANT_TOOL_BUTTON_BAR_ACTIVE);
            }
            ++n2;
        }
        GridData collapseButtonData = null;
        if (this.m_toolButtonCollapseButton != null) {
            collapseButtonData = (GridData)this.m_toolButtonCollapseButton.getLayoutData();
        }
        GridData labelData = null;
        if (this.m_toolButtonsLabel != null) {
            labelData = (GridData)this.m_toolButtonsLabel.getLayoutData();
        }
        if (label == null) {
            if (this.m_toolButtonCollapseButton != null && collapseButtonData != null) {
                this.m_toolButtonCollapseButton.setVisible(false);
                collapseButtonData.exclude = true;
            }
            if (this.m_toolButtonsLabel != null && labelData != null) {
                labelData.exclude = true;
                this.m_toolButtonsLabel.setVisible(false);
            }
            label = "";
        } else {
            if (this.m_toolButtonCollapseButton != null && collapseButtonData != null) {
                collapseButtonData.exclude = false;
                this.m_toolButtonCollapseButton.setVisible(true);
            }
            if (this.m_toolButtonsLabel != null && labelData != null) {
                labelData.exclude = false;
                this.m_toolButtonsLabel.setVisible(true);
            }
        }
        if (this.m_toolButtonsLabel != null) {
            this.m_toolButtonsLabel.setText(label);
        }
        this.getUiContainer().getParent().layout(true, true);
    }

    protected void handleScoutToolButtonPropertyChange(String propertyName, Object newValue) {
        this.updateToolButtonLabel();
    }

    public boolean isShowingCollapseButtonEnabled() {
        return true;
    }

    public boolean isShowingLabelEnabled() {
        return true;
    }
}

