/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.window.popup;

import java.util.EventListener;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.ext.table.TableEx;
import org.eclipse.scout.rt.ui.rap.ext.tree.TreeEx;
import org.eclipse.scout.rt.ui.rap.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.rap.form.IRwtScoutForm;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.scout.rt.ui.rap.window.AbstractRwtScoutPart;
import org.eclipse.scout.rt.ui.rap.window.RwtScoutPartEvent;
import org.eclipse.scout.rt.ui.rap.window.RwtScoutPartListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.Form;

public class RwtScoutPopup
extends AbstractRwtScoutPart {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutPopup.class);
    public static final String PROP_POPUP_OWNER = "propPopupOwner";
    private static final String POPUP_CUSTOM_VARIANT = "popup";
    private Control m_ownerComponent;
    private Rectangle m_ownerBounds;
    private Shell m_window;
    private Composite m_windowContentPane;
    private EventListenerList m_listenerList;
    private boolean m_positionBelowReferenceField;
    private boolean m_popupOnField;
    private int m_widthHint;
    private int m_heightHint;
    private int m_maxHeightHint;
    private int m_maxWidthHint;
    private IRwtScoutForm m_rwtScoutForm;

    @Override
    public Form getUiForm() {
        return null;
    }

    public IRwtScoutForm getRwtScoutForm() {
        return this.m_rwtScoutForm;
    }

    public void createPart(IForm scoutForm, Control ownerComponent, Rectangle ownerBounds, int style, IRwtEnvironment uiEnvironment) {
        super.createPart(scoutForm, uiEnvironment);
        this.m_positionBelowReferenceField = true;
        this.m_ownerComponent = ownerComponent;
        this.m_ownerBounds = ownerBounds;
        this.m_listenerList = new EventListenerList();
        this.m_widthHint = -1;
        this.m_heightHint = -1;
        this.m_maxHeightHint = -1;
        this.m_maxWidthHint = -1;
        this.m_window = new Shell(ownerComponent.getShell(), style);
        this.m_window.setData("extendedStyle", (Object)8);
        this.m_window.setLayout((Layout)new FillLayout());
        this.m_window.setData("org.eclipse.rap.rwt.customVariant", (Object)POPUP_CUSTOM_VARIANT);
        this.m_window.addDisposeListener((DisposeListener)new P_RwtWindowDisposeListener());
        this.m_windowContentPane = this.getUiEnvironment().getFormToolkit().createComposite((Composite)this.m_window, 0);
        this.m_windowContentPane.setLayout((Layout)new FillLayout());
        this.m_rwtScoutForm = this.getUiEnvironment().createForm(this.m_windowContentPane, scoutForm);
        this.attachScout();
    }

    public Shell getShell() {
        return this.m_window;
    }

    @Override
    public Composite getUiContainer() {
        return this.getUiContentPane();
    }

    public Composite getUiContentPane() {
        return this.m_windowContentPane;
    }

    protected Control getOwnerComponent() {
        return this.m_ownerComponent;
    }

    public void setBounds(Rectangle bounds) {
        this.getShell().setBounds(bounds);
        this.getShell().layout(true, true);
    }

    public boolean isPopupOnField() {
        return this.m_popupOnField;
    }

    public void setPopupOnField(boolean popupOnField) {
        this.m_popupOnField = popupOnField;
    }

    public boolean isPopupBelow() {
        return this.m_positionBelowReferenceField;
    }

    public int getWidthHint() {
        return this.m_widthHint;
    }

    public void setWidthHint(int widthHint) {
        this.m_widthHint = widthHint > 0 ? widthHint : -1;
    }

    public int getHeightHint() {
        return this.m_heightHint;
    }

    public void setHeightHint(int heightHint) {
        this.m_heightHint = heightHint > 0 ? heightHint : -1;
    }

    public int getMaxHeightHint() {
        return this.m_maxHeightHint;
    }

    public void setMaxHeightHint(int maxHeightHint) {
        this.m_maxHeightHint = maxHeightHint > 0 ? maxHeightHint : -1;
    }

    public int getMaxWidthHint() {
        return this.m_maxWidthHint;
    }

    public void setMaxWidthHint(int maxWidthHint) {
        this.m_maxWidthHint = maxWidthHint > 0 ? maxWidthHint : -1;
    }

    @Override
    protected void showPartImpl() {
        this.handleUiWindowOpening();
        this.autoAdjustBounds();
        this.m_window.open();
        this.handleUiWindowOpened();
    }

    @Override
    protected void closePartImpl() {
        this.detachScout();
        try {
            if (!this.m_window.isDisposed()) {
                this.m_window.setVisible(false);
                this.m_window.dispose();
            }
        }
        catch (Throwable t) {
            LOG.error("Failed closing popup " + this.getScoutObject(), t);
        }
    }

    public void autoAdjustBounds() {
        Rectangle alternateView;
        if (this.getShell().isDisposed()) {
            return;
        }
        if (this.m_ownerComponent.isDisposed()) {
            LOG.warn("Unexpected: Owner component of popup is disposed");
            return;
        }
        Point dim = this.getShell().computeSize(0, this.m_heightHint, true);
        TableEx proposalTable = RwtUtility.findChildComponent((Widget)this.getShell(), TableEx.class);
        TreeEx proposalTree = RwtUtility.findChildComponent((Widget)this.getShell(), TreeEx.class);
        if (proposalTable != null) {
            dim.x = proposalTable.getSize().x;
        } else if (proposalTree != null) {
            dim.x = proposalTree.getSize().x;
        }
        dim.x = Math.max(dim.x, UiDecorationExtensionPoint.getLookAndFeel().getLogicalGridLayoutDefaultPopupWidth());
        if (this.m_maxWidthHint != -1) {
            dim.x = Math.min(dim.x, this.m_maxWidthHint);
        }
        if (this.m_maxHeightHint != -1) {
            dim.y = Math.min(dim.y, this.m_maxHeightHint);
        }
        Point p = this.m_ownerComponent.toDisplay(new Point(-this.m_ownerComponent.getBorderWidth(), 0));
        Point above = new Point(p.x, p.y);
        if (this.m_popupOnField) {
            above.y += this.m_ownerComponent.getBounds().height;
        }
        Rectangle aboveView = RwtUtility.intersectRectangleWithScreen(this.getShell().getDisplay(), new Rectangle(above.x, above.y - dim.y, dim.x, dim.y), false, false);
        Point below = new Point(p.x, p.y);
        if (!this.m_popupOnField) {
            below.y += this.m_ownerComponent.getBounds().height;
        }
        Rectangle belowView = RwtUtility.intersectRectangleWithScreen(this.getShell().getDisplay(), new Rectangle(below.x, below.y, dim.x, dim.y), false, false);
        Rectangle currentView = this.m_positionBelowReferenceField ? belowView : aboveView;
        Rectangle rectangle = alternateView = this.m_positionBelowReferenceField ? aboveView : belowView;
        if (currentView.height >= alternateView.height) {
            this.getShell().setBounds(currentView);
        } else {
            this.getShell().setBounds(alternateView);
            this.m_positionBelowReferenceField = !this.m_positionBelowReferenceField;
        }
    }

    public void addRwtScoutPartListener(RwtScoutPartListener listener) {
        this.m_listenerList.add(RwtScoutPartListener.class, (EventListener)listener);
    }

    public void removeRwtScoutPartListener(RwtScoutPartListener listener) {
        this.m_listenerList.remove(RwtScoutPartListener.class, (EventListener)listener);
    }

    protected void fireRwtScoutPartEvent(RwtScoutPartEvent e) {
        EventListener[] listeners;
        if (this.m_window != null && (listeners = this.m_listenerList.getListeners(RwtScoutPartListener.class)) != null && listeners.length > 0) {
            EventListener[] eventListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                EventListener listener = eventListenerArray[n2];
                try {
                    ((RwtScoutPartListener)listener).partChanged(e);
                }
                catch (Throwable t) {
                    LOG.error("Unexpected:", t);
                }
                ++n2;
            }
        }
    }

    @Override
    public boolean isVisible() {
        return this.m_window != null && this.m_window.getVisible();
    }

    @Override
    public void activate() {
        this.m_window.getShell().setActive();
    }

    @Override
    public boolean isActive() {
        return this.m_window != null && this.m_window.getDisplay().getActiveShell() == this.m_window;
    }

    @Override
    public boolean setStatusLineMessage(Image image, String message) {
        return false;
    }

    protected void handleUiWindowOpening() {
        this.fireRwtScoutPartEvent(new RwtScoutPartEvent(this, 10));
    }

    protected void handleUiWindowOpened() {
        this.fireRwtScoutPartEvent(new RwtScoutPartEvent(this, 20));
        this.fireRwtScoutPartEvent(new RwtScoutPartEvent(this, 30));
    }

    protected void handleUiWindowClosed() {
        this.fireRwtScoutPartEvent(new RwtScoutPartEvent(this, 50));
        Runnable job = new Runnable(){

            @Override
            public void run() {
                RwtScoutPopup.this.getScoutObject().getUIFacade().fireFormKilledFromUI();
            }
        };
        this.getUiEnvironment().invokeScoutLater(job, 0L);
    }

    private final class P_RwtWindowDisposeListener
    implements DisposeListener {
        private static final long serialVersionUID = 1L;

        private P_RwtWindowDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent e) {
            RwtScoutPopup.this.handleUiWindowClosed();
        }
    }
}

