/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic.table;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.basic.table.SwingScoutTable;
import org.eclipse.scout.rt.ui.swing.basic.table.SwingTableColumn;

public class SwingTableColumnModel
extends DefaultTableColumnModel
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private ISwingEnvironment m_env;
    private SwingScoutTable m_swingScoutTable;
    private MouseListener m_swingTableHeaderMouseListener;
    private boolean m_mousePressedInTableHeader;

    public SwingTableColumnModel(ISwingEnvironment env, SwingScoutTable swingScoutTable) {
        this.m_env = env;
        this.m_swingScoutTable = swingScoutTable;
        this.m_swingTableHeaderMouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SwingTableColumnModel.this.m_mousePressedInTableHeader = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SwingTableColumnModel.this.m_mousePressedInTableHeader = false;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SwingTableColumnModel.this.m_mousePressedInTableHeader = false;
            }
        };
        this.columnMargin = this.m_swingScoutTable.getSwingTable().getIntercellSpacing().width;
        this.initializeColumns();
    }

    public void notifyScoutModelChanged() {
        this.initializeColumns();
    }

    @Override
    public TableColumn getColumn(int columnIndex) {
        if (columnIndex < 0) {
            columnIndex = 0;
        }
        return super.getColumn(columnIndex);
    }

    public void initializeColumns() {
        if (this.m_swingScoutTable.getSwingTable() != null && this.m_swingScoutTable.getSwingTable().getTableHeader() != null) {
            this.m_swingScoutTable.getSwingTable().getTableHeader().removeMouseListener(this.m_swingTableHeaderMouseListener);
        }
        while (this.getColumnCount() > 0) {
            this.removeColumn(this.getColumn(0));
        }
        if (this.m_swingScoutTable.getScoutObject() != null) {
            if (this.m_swingScoutTable.getSwingTable().getTableHeader() != null) {
                this.m_swingScoutTable.getSwingTable().getTableHeader().addMouseListener(this.m_swingTableHeaderMouseListener);
            }
            IColumn[] scoutCols = ((ITable)this.m_swingScoutTable.getScoutObject()).getColumnSet().getVisibleColumns();
            int i = 0;
            while (i < scoutCols.length) {
                SwingTableColumn swingColumn = this.m_env.createColumn(i, scoutCols[i]);
                this.addColumn(swingColumn);
                ++i;
            }
        }
    }

    public IColumn swingToScoutColumn(int index) {
        if (index >= 0 && index < this.getColumnCount()) {
            return ((SwingTableColumn)this.getColumn(index)).getScoutColumn();
        }
        return null;
    }

    @Override
    protected void fireColumnMoved(TableColumnModelEvent e) {
        super.fireColumnMoved(e);
        if (this.m_swingScoutTable.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        if (this.m_swingScoutTable.getScoutObject() != null && e.getFromIndex() != e.getToIndex()) {
            final IColumn col = ((SwingTableColumn)this.getColumn(e.getToIndex())).getScoutColumn();
            final int toIndex = e.getToIndex();
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    try {
                        SwingTableColumnModel.this.m_swingScoutTable.addIgnoredScoutEvent(TableEvent.class, "1");
                        SwingTableColumnModel.this.m_swingScoutTable.addIgnoredScoutEvent(TableEvent.class, "770");
                        ((ITable)SwingTableColumnModel.this.m_swingScoutTable.getScoutObject()).getUIFacade().fireColumnMovedFromUI(col, toIndex);
                    }
                    finally {
                        SwingTableColumnModel.this.m_swingScoutTable.removeIgnoredScoutEvent(TableEvent.class, "1");
                        SwingTableColumnModel.this.m_swingScoutTable.removeIgnoredScoutEvent(TableEvent.class, "770");
                    }
                }
            };
            this.m_env.invokeScoutLater(t, 0L);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if (this.m_mousePressedInTableHeader && (e.getPropertyName().equals("preferredWidth") || e.getPropertyName().equals("width"))) {
            TableColumn column = (TableColumn)e.getSource();
            if (this.m_swingScoutTable != null) {
                ArrayList<TableColumn> list = new ArrayList<TableColumn>(1);
                list.add(column);
                this.m_swingScoutTable.storeColumnWidthsFromSwing(list);
            }
        }
    }

    @Override
    public void moveColumn(int columnIndex, int newIndex) {
        if (this.isMoveColumnAllowed(columnIndex, newIndex)) {
            super.moveColumn(columnIndex, newIndex);
        }
    }

    private boolean isMoveColumnAllowed(int oldIndex, int newIndex) {
        IColumn succeedingColumn;
        IColumn columnToMove;
        ITable table = (ITable)this.m_swingScoutTable.getScoutObject();
        if (!table.isCheckable() || oldIndex == newIndex) {
            return true;
        }
        if (newIndex == 0 && (columnToMove = table.getColumnSet().getVisibleColumn(oldIndex)).isEditable()) {
            return false;
        }
        return oldIndex != 0 || table.getColumnSet().getVisibleColumnCount() <= 1 || !(succeedingColumn = table.getColumnSet().getVisibleColumn(1)).isEditable();
    }
}

