/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SizeSequence;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.rt.ui.swing.SwingLayoutUtility;

public class DynamicRowHeightCache {
    private static final long serialVersionUID = 1L;
    private final JTable m_table;
    private final SizeSequence m_sizes;
    private boolean m_sizesValid;
    private OptimisticLock m_validationLock;

    public DynamicRowHeightCache(JTable table) {
        this(table, table.getRowHeight());
    }

    public DynamicRowHeightCache(JTable table, int rowHeight) {
        this.m_table = table;
        this.m_sizes = new SizeSequence(table.getRowCount(), rowHeight);
        this.m_sizesValid = false;
        this.m_validationLock = new OptimisticLock();
    }

    public int getRowHeight(int row) {
        this.validateSizes();
        return this.m_sizes.getSize(row);
    }

    public int getRowAtPoint(Point p) {
        this.validateSizes();
        int index = this.m_sizes.getIndex(p.y);
        if (index < 0) {
            return -1;
        }
        if (index >= this.m_table.getRowCount()) {
            return -1;
        }
        return index;
    }

    public int getPointForRow(int row) {
        this.validateSizes();
        if (row < 0) {
            return 0;
        }
        if (row >= this.m_table.getRowCount()) {
            return this.m_table.getHeight();
        }
        return this.m_sizes.getPosition(row);
    }

    protected void validateSizes() {
        if (!this.m_sizesValid) {
            this.m_sizesValid = true;
            try {
                if (!this.m_validationLock.acquire()) {
                    return;
                }
                int rowCount = this.m_table.getRowCount();
                TableColumnModel cm = this.m_table.getColumnModel();
                int defaultHeight = this.m_table.getRowHeight();
                int i = 0;
                while (i < rowCount) {
                    int h = this.determinePreferredRowHeight(i, cm, defaultHeight);
                    this.m_sizes.setSize(i, h);
                    ++i;
                }
            }
            finally {
                this.m_validationLock.release();
            }
        }
    }

    protected int determinePreferredRowHeight(int r, TableColumnModel cm, int defaultHeight) {
        int colCount = cm.getColumnCount();
        int maxHeight = defaultHeight;
        int c = 0;
        while (c < colCount) {
            TableCellRenderer renderer = this.m_table.getCellRenderer(r, c);
            JComponent comp = (JComponent)this.m_table.prepareRenderer(renderer, r, c);
            int cellW = cm.getColumn(c).getWidth() - cm.getColumnMargin();
            int h = SwingLayoutUtility.getPreferredLabelSize((JLabel)((JLabel)comp), (int)cellW).height;
            maxHeight = Math.max(maxHeight, h);
            ++c;
        }
        return maxHeight;
    }
}

