/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.plannerfield;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSplitPane;
import javax.swing.table.JTableHeader;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.form.fields.plannerfield.IPlannerField;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.basic.activitymap.SwingScoutActivityMap;
import org.eclipse.scout.rt.ui.swing.basic.table.ISwingScoutTable;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.calendar.CalendarViewEvent;
import org.eclipse.scout.rt.ui.swing.ext.calendar.CalendarViewListener;
import org.eclipse.scout.rt.ui.swing.ext.calendar.DateChooser;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.plannerfield.ISwingScoutPlannerField;
import org.eclipse.scout.rt.ui.swing.form.fields.plannerfield.layout.PlannerFieldLayout;
import org.eclipse.scout.rt.ui.swing.form.fields.plannerfield.layout.PlannerFieldLayoutConstraints;

public class SwingScoutPlannerField
extends SwingScoutFieldComposite<IPlannerField<?, ?, ?, ?>>
implements ISwingScoutPlannerField {
    private ISwingScoutTable m_resourceTableComposite;
    private SwingScoutActivityMap m_activityMapComposite;
    private DateChooser[] m_miniDateChooser;
    private JPanel m_miniCalPanel;
    private P_SwingMiniCalendarChangeListener m_swingMiniCalendarChangeListener;

    @Override
    protected void initializeSwing() {
        JPanel container = new JPanel(new PlannerFieldLayout(this.getSwingEnvironment(), ((IPlannerField)this.getScoutObject()).getGridData()));
        container.setOpaque(false);
        ITable scoutTable = ((IPlannerField)this.getScoutObject()).getResourceTable();
        this.m_resourceTableComposite = this.getSwingEnvironment().createTable(scoutTable);
        this.m_resourceTableComposite.createField(scoutTable, this.getSwingEnvironment());
        JTableHeader h = this.m_resourceTableComposite.getSwingTable().getTableHeader();
        if (h != null) {
            h.setPreferredSize(new Dimension(h.getPreferredSize().width, h.getFontMetrics(h.getFont()).getHeight() * 5 / 2));
            h.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (SwingScoutPlannerField.this.m_activityMapComposite != null) {
                        SwingScoutPlannerField.this.m_activityMapComposite.getSwingActivityMap().revalidate();
                        SwingScoutPlannerField.this.m_activityMapComposite.getSwingActivityMap().repaint();
                    }
                }
            });
        }
        this.m_activityMapComposite = new SwingScoutActivityMap(this.m_resourceTableComposite.getSwingTable());
        this.m_activityMapComposite.createField(((IPlannerField)this.getScoutObject()).getActivityMap(), this.getSwingEnvironment());
        JSplitPane hsplit = new JSplitPane(1, this.m_resourceTableComposite.getSwingScrollPane(), this.m_activityMapComposite.getSwingScrollPane());
        hsplit.setBorder(null);
        hsplit.setDividerLocation(((IPlannerField)this.getScoutObject()).getSplitterPosition());
        hsplit.setDividerSize(3);
        container.add((Component)hsplit, new PlannerFieldLayoutConstraints(1));
        JScrollBar resourceTableScrollBar = this.m_resourceTableComposite.getSwingScrollPane().getVerticalScrollBar();
        JScrollBar activityMapScrollBar = this.m_activityMapComposite.getSwingScrollPane().getVerticalScrollBar();
        P_SwingScrollSyncListener sl = new P_SwingScrollSyncListener(resourceTableScrollBar, activityMapScrollBar);
        resourceTableScrollBar.addAdjustmentListener(sl);
        activityMapScrollBar.addAdjustmentListener(sl);
        this.m_activityMapComposite.getSwingScrollPane().getHorizontalScrollBar().setEnabled(false);
        this.m_miniDateChooser = new DateChooser[0];
        this.m_miniCalPanel = new JPanelEx();
        container.add((Component)this.m_miniCalPanel, new PlannerFieldLayoutConstraints(2));
        container.getInputMap(1).put(SwingUtility.createKeystroke("F5"), "refresh");
        container.getActionMap().put("refresh", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        ((IPlannerField)SwingScoutPlannerField.this.getScoutObject()).getUIFacade().refreshFromUI();
                    }
                };
                SwingScoutPlannerField.this.getSwingEnvironment().invokeScoutLater(t, 0L);
            }
        });
        this.setSwingContainer(container);
        this.setSwingField(container);
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.setMiniCalendarCountFromScout(((IPlannerField)this.getScoutObject()).getMiniCalendarCount());
    }

    @Override
    public ISwingScoutTable getResourceTableComposite() {
        return this.m_resourceTableComposite;
    }

    @Override
    public SwingScoutActivityMap getActivityMapComposite() {
        return this.m_activityMapComposite;
    }

    protected void setMiniCalendarCountFromScout(int calCount) {
        if (this.m_miniDateChooser.length == calCount) {
            return;
        }
        if (this.m_swingMiniCalendarChangeListener != null) {
            int i = 0;
            while (i < this.m_miniDateChooser.length) {
                this.m_miniDateChooser[i].removeCalendarViewListener(this.m_swingMiniCalendarChangeListener);
                ++i;
            }
        }
        this.m_miniCalPanel.removeAll();
        this.m_miniCalPanel.setLayout(new GridLayout(calCount, 1));
        this.m_miniDateChooser = new DateChooser[calCount];
        if (this.m_miniDateChooser.length > 0) {
            if (this.m_swingMiniCalendarChangeListener == null) {
                this.m_swingMiniCalendarChangeListener = new P_SwingMiniCalendarChangeListener();
            }
            int workdayCount = ((IPlannerField)this.getScoutObject()).getActivityMap().getWorkDayCount();
            int i = 0;
            while (i < this.m_miniDateChooser.length) {
                this.m_miniDateChooser[i] = new DateChooser(false);
                this.m_miniDateChooser[i].setMultiSelect(true);
                this.m_miniDateChooser[i].addCalendarViewListener(this.m_swingMiniCalendarChangeListener);
                this.m_miniDateChooser[i].setWorkDayCount(workdayCount);
                this.m_miniCalPanel.add(this.m_miniDateChooser[i].getContainer());
                if (i > 0) {
                    this.m_miniDateChooser[i - 1].setChildCalendar(this.m_miniDateChooser[i]);
                }
                ++i;
            }
            Date[] days = this.m_activityMapComposite.getScoutActivityMap().getDays();
            if (this.m_miniDateChooser.length > 0) {
                this.m_miniDateChooser[0].setSelectedDates(days);
            }
        }
    }

    protected void setWorkDayCountFromScout(int workDayCount) {
        int i = 0;
        while (i < this.m_miniDateChooser.length) {
            this.m_miniDateChooser[i].setWorkDayCount(workDayCount);
            ++i;
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("miniCalendarCount")) {
            this.setMiniCalendarCountFromScout((Integer)newValue);
        }
    }

    private class P_ScoutActivityMapPropertyChangeListener
    implements PropertyChangeListener {
        private P_ScoutActivityMapPropertyChangeListener() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent e) {
            if (e.getPropertyName().equals("workDayCount")) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        SwingScoutPlannerField.this.setWorkDayCountFromScout((Integer)e.getNewValue());
                    }
                };
                SwingScoutPlannerField.this.getSwingEnvironment().invokeSwingLater(t);
            }
        }
    }

    private class P_SwingMiniCalendarChangeListener
    implements CalendarViewListener {
        private P_SwingMiniCalendarChangeListener() {
        }

        @Override
        public void viewChanged(CalendarViewEvent e) {
            switch (e.getType()) {
                case 30: {
                    if (SwingScoutPlannerField.this.getUpdateSwingFromScoutLock().isAcquired()) {
                        return;
                    }
                    final Date[] dates = e.getSource().getSelectedDates();
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            SwingScoutPlannerField.this.m_activityMapComposite.getScoutActivityMap().getUIFacade().setDaysFromUI(dates);
                        }
                    };
                    SwingScoutPlannerField.this.getSwingEnvironment().invokeScoutLater(t, 0L);
                }
            }
        }
    }

    private class P_SwingScrollSyncListener
    implements AdjustmentListener {
        private OptimisticLock m_syncLock = new OptimisticLock();
        private JScrollBar m_bar1;
        private JScrollBar m_bar2;

        public P_SwingScrollSyncListener(JScrollBar bar1, JScrollBar bar2) {
            this.m_bar1 = bar1;
            this.m_bar2 = bar2;
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            try {
                if (this.m_syncLock.acquire()) {
                    if (e.getSource() == this.m_bar1) {
                        this.m_bar2.setValue(e.getValue());
                    } else if (e.getSource() == this.m_bar2) {
                        this.m_bar1.setValue(e.getValue());
                    }
                }
            }
            finally {
                this.m_syncLock.release();
            }
        }
    }
}

