/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop.toolbar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.navigation.INavigationHistoryService;
import org.eclipse.scout.rt.client.ui.desktop.navigation.NavigationHistoryEvent;
import org.eclipse.scout.rt.client.ui.desktop.navigation.NavigationHistoryListener;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.ui.swing.SwingPopupWorker;
import org.eclipse.scout.rt.ui.swing.basic.SwingScoutComposite;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.job.SwingProgressHandler;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.AbstractJNavigationPanel;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.AbstractJToolTabsBar;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.AbstractJViewTabsBar;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.internal.JNavigationPanel;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.internal.JToolTabsBar;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.internal.JViewTabsBar;
import org.eclipse.scout.service.SERVICES;

public class SwingScoutHeaderPanel
extends SwingScoutComposite<IDesktop> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutHeaderPanel.class);
    private static final long serialVersionUID = 1L;
    private static final int DISTANCE_NAVIGATION_TABS = 2;
    protected AbstractJNavigationPanel m_navigationPanel;
    private JLabel m_windowIcons;
    private int m_topLevelMenuCount;
    protected AbstractJViewTabsBar m_viewTabsPanel;
    protected AbstractJToolTabsBar m_toolTabsPanel;
    protected JComponent m_logo;
    private NavigationHistoryListener m_scoutNavListener;
    protected final SpringLayout m_layout = new SpringLayout();

    @Override
    protected void initializeSwing() {
        int height;
        Color color;
        this.m_topLevelMenuCount = ((IDesktop)this.getScoutObject()).getMenus().length;
        final JPanelEx container = new JPanelEx(this.m_layout);
        this.m_navigationPanel = this.createNavigationPanel();
        container.add(this.m_navigationPanel);
        this.m_navigationPanel.setBackAction(new P_BackAction());
        this.m_navigationPanel.setForwardAction(new P_ForwardAction());
        this.m_navigationPanel.setHistoryAction(new P_HistoryAction());
        this.m_navigationPanel.setRefreshAction(new P_RefreshAction());
        this.m_navigationPanel.setStopAction(new SwingProgressHandler.CancelJobsAction());
        this.m_layout.putConstraint("West", (Component)this.m_navigationPanel, 0, "West", (Component)container);
        this.m_layout.putConstraint("North", (Component)this.m_navigationPanel, 0, "North", (Component)container);
        this.m_viewTabsPanel = this.createViewTabsBar();
        container.add(this.m_viewTabsPanel);
        this.m_layout.putConstraint("North", (Component)this.m_viewTabsPanel, 2, "South", (Component)this.m_navigationPanel);
        this.m_layout.putConstraint("South", (Component)this.m_viewTabsPanel, 0, "South", (Component)container);
        this.m_layout.putConstraint("West", (Component)this.m_viewTabsPanel, 0, "West", (Component)container);
        this.m_layout.putConstraint("East", (Component)this.m_viewTabsPanel, 0, "East", (Component)container);
        this.m_toolTabsPanel = this.createToolTabsBar();
        this.m_toolTabsPanel.setSwingScoutHeaderPanel(this);
        container.add(this.m_toolTabsPanel);
        this.m_layout.putConstraint("North", (Component)this.m_toolTabsPanel, 0, "North", (Component)this.m_viewTabsPanel);
        this.m_layout.putConstraint("South", (Component)this.m_toolTabsPanel, 0, "South", (Component)container);
        this.m_layout.putConstraint("East", (Component)this.m_toolTabsPanel, 0, "East", (Component)container);
        this.m_logo = this.getSwingEnvironment().createLogo();
        if (this.m_logo != null) {
            container.add(this.m_logo);
            int vAlignment = UIManager.getInt("HeaderPanel.logoVerticalAlignment");
            switch (vAlignment) {
                case 0: {
                    this.m_layout.putConstraint("North", (Component)this.m_logo, this.m_viewTabsPanel.getPreferredSize().height * -1, "VerticalCenter", (Component)container);
                    break;
                }
                case 1: {
                    this.m_layout.putConstraint("South", (Component)this.m_logo, 0, "North", (Component)this.m_viewTabsPanel);
                    break;
                }
                default: {
                    this.m_layout.putConstraint("North", (Component)this.m_logo, 0, "North", (Component)container);
                }
            }
            int hAlignment = UIManager.getInt("HeaderPanel.logoHorizontalAlignment");
            if (hAlignment == 1) {
                this.m_layout.putConstraint("East", (Component)this.m_logo, 0, "East", (Component)container);
            } else {
                this.m_layout.putConstraint("HorizontalCenter", (Component)this.m_logo, 0, "HorizontalCenter", (Component)container);
            }
            container.addComponentListener(new ComponentAdapter(){
                private final OptimisticLock m_syncLock = new OptimisticLock();

                @Override
                public void componentResized(ComponentEvent e) {
                    try {
                        if (this.m_syncLock.acquire()) {
                            boolean overlapping;
                            boolean bl = overlapping = SwingScoutHeaderPanel.this.m_navigationPanel.getBounds().x + SwingScoutHeaderPanel.this.m_navigationPanel.getBounds().width > SwingScoutHeaderPanel.this.m_logo.getBounds().x;
                            if (overlapping && SwingScoutHeaderPanel.this.m_logo.isVisible()) {
                                SwingScoutHeaderPanel.this.m_logo.setVisible(false);
                            } else if (!overlapping && !SwingScoutHeaderPanel.this.m_logo.isVisible()) {
                                SwingScoutHeaderPanel.this.m_logo.setVisible(true);
                            }
                        }
                    }
                    finally {
                        this.m_syncLock.release();
                    }
                }
            });
        }
        if ((color = UIManager.getColor("HeaderPanel.background")) != null) {
            container.setOpaque(true);
            container.setBackground(color);
        }
        if ((height = UIManager.getInt("HeaderPanel.height")) > 0) {
            container.setPreferredSize(new Dimension(-1, height));
        } else {
            container.addComponentListener(new ComponentAdapter(){
                private int m_height;
                private final OptimisticLock m_syncLock = new OptimisticLock();

                @Override
                public void componentResized(ComponentEvent e) {
                    try {
                        int newHeight;
                        if (this.m_syncLock.acquire() && this.m_height != (newHeight = this.calculatePanelHeight())) {
                            this.m_height = newHeight;
                            container.setPreferredSize(new Dimension(-1, this.m_height));
                        }
                    }
                    finally {
                        this.m_syncLock.release();
                    }
                }

                private int calculatePanelHeight() {
                    double heightNavigationPanel = SwingScoutHeaderPanel.this.m_navigationPanel.getPreferredSize().getHeight();
                    double heightViewTabPanel = SwingScoutHeaderPanel.this.m_viewTabsPanel.getPreferredSize().getHeight();
                    double heightToolTabsPanel = SwingScoutHeaderPanel.this.m_toolTabsPanel.getPreferredSize().getHeight();
                    double heightLogoPanel = 0.0;
                    if (SwingScoutHeaderPanel.this.m_logo != null) {
                        heightLogoPanel = SwingScoutHeaderPanel.this.m_logo.getPreferredSize().getHeight();
                    }
                    double heightTopPanel = Math.max(heightNavigationPanel, heightLogoPanel);
                    double heightBottomPanel = Math.max(heightViewTabPanel, heightToolTabsPanel);
                    return (int)(heightTopPanel + 2.0 + heightBottomPanel);
                }
            });
        }
        this.setSwingField(container);
        this.rebuildViewTabs();
        this.rebuildToolTabs();
        this.rebuildNavigationWidget();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        new ClientSyncJob("add navigation listener", this.getSwingEnvironment().getScoutSession()){

            protected void runVoid(IProgressMonitor monitor) throws Throwable {
                if (SwingScoutHeaderPanel.this.m_scoutNavListener == null) {
                    SwingScoutHeaderPanel.this.m_scoutNavListener = new NavigationHistoryListener(){

                        public void navigationChanged(NavigationHistoryEvent e) {
                            SwingScoutHeaderPanel.this.handleNavigationChangedFromScout();
                        }
                    };
                    ((INavigationHistoryService)SERVICES.getService(INavigationHistoryService.class)).addNavigationHistoryListener(SwingScoutHeaderPanel.this.m_scoutNavListener);
                    SwingScoutHeaderPanel.this.handleNavigationChangedFromScout();
                }
            }
        }.schedule();
    }

    @Override
    protected void detachScout() {
        super.detachScout();
        new ClientSyncJob("remove navigation listener", this.getSwingEnvironment().getScoutSession()){

            protected void runVoid(IProgressMonitor monitor) throws Throwable {
                if (SwingScoutHeaderPanel.this.m_scoutNavListener != null) {
                    INavigationHistoryService nav = (INavigationHistoryService)SERVICES.getService(INavigationHistoryService.class);
                    if (nav != null) {
                        nav.removeNavigationHistoryListener(SwingScoutHeaderPanel.this.m_scoutNavListener);
                    }
                    SwingScoutHeaderPanel.this.m_scoutNavListener = null;
                }
            }
        }.schedule();
    }

    @Override
    protected boolean isHandleScoutPropertyChange(String name, Object newValue) {
        return false;
    }

    protected void handleNavigationBackFromSwing() {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                try {
                    ((INavigationHistoryService)SERVICES.getService(INavigationHistoryService.class)).stepBackward();
                }
                catch (ProcessingException processingException) {
                    // empty catch block
                }
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 0L);
    }

    protected void handleNavigationForwardFromSwing() {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                try {
                    ((INavigationHistoryService)SERVICES.getService(INavigationHistoryService.class)).stepForward();
                }
                catch (ProcessingException processingException) {
                    // empty catch block
                }
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 0L);
    }

    protected void handleNavigationMenuFromSwing() {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                IMenu[] scoutMenus = ((INavigationHistoryService)SERVICES.getService(INavigationHistoryService.class)).getMenus();
                new SwingPopupWorker(SwingScoutHeaderPanel.this.getSwingEnvironment(), SwingScoutHeaderPanel.this.m_navigationPanel, SwingScoutHeaderPanel.this.m_navigationPanel.getHistoryMenuLocation(), scoutMenus).enqueue();
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 5678L);
    }

    protected void handleNavigationChangedFromScout() {
        INavigationHistoryService service = (INavigationHistoryService)SERVICES.getService(INavigationHistoryService.class);
        final boolean backEnabled = service.hasBackwardBookmarks();
        final boolean forewardEnabled = service.hasForwardBookmarks();
        final boolean menuEnabled = backEnabled || forewardEnabled;
        Runnable t = new Runnable(){

            @Override
            public void run() {
                SwingScoutHeaderPanel.this.updateNavigationWidget(backEnabled, forewardEnabled, menuEnabled);
            }
        };
        this.getSwingEnvironment().invokeSwingLater(t);
    }

    public boolean isEmpty() {
        return this.m_topLevelMenuCount == 0;
    }

    public AbstractJToolTabsBar getSwingToolTabsPanel() {
        return this.m_toolTabsPanel;
    }

    public void adjustToolButtonPanelWidth(int width, boolean force) {
        Spring constraintLeft = this.m_layout.getConstraint("West", this.m_toolTabsPanel);
        Spring constraintRigth = this.m_layout.getConstraint("East", this.m_toolTabsPanel);
        int currentWidth = constraintRigth.getValue() - constraintLeft.getValue();
        if (force || width != currentWidth) {
            this.m_layout.putConstraint("West", (Component)this.m_toolTabsPanel, width * -1, "East", (Component)this.getSwingField());
            this.m_layout.putConstraint("East", (Component)this.m_viewTabsPanel, width * -1, "East", (Component)this.getSwingField());
            this.getSwingField().revalidate();
        }
    }

    private void updateNavigationWidget(boolean backEnabled, boolean forwardEnabled, boolean menuEnabled) {
        this.m_navigationPanel.getBackAction().setEnabled(backEnabled);
        this.m_navigationPanel.getForwardAction().setEnabled(forwardEnabled);
        this.m_navigationPanel.getHistoryAction().setEnabled(menuEnabled);
    }

    private void rebuildViewTabs() {
        this.m_viewTabsPanel.rebuild((IDesktop)this.getScoutObject());
    }

    private void rebuildToolTabs() {
        this.m_toolTabsPanel.rebuild((IDesktop)this.getScoutObject());
    }

    private void rebuildNavigationWidget() {
        this.m_navigationPanel.rebuild((IDesktop)this.getScoutObject());
    }

    public AbstractJNavigationPanel getSwingNavigationWidget() {
        return this.m_navigationPanel;
    }

    protected AbstractJNavigationPanel createNavigationPanel() {
        return new JNavigationPanel(this.getSwingEnvironment());
    }

    protected AbstractJToolTabsBar createToolTabsBar() {
        return new JToolTabsBar(this.getSwingEnvironment());
    }

    protected AbstractJViewTabsBar createViewTabsBar() {
        return new JViewTabsBar(this.getSwingEnvironment());
    }

    private class P_BackAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private P_BackAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingScoutHeaderPanel.this.handleNavigationBackFromSwing();
        }
    }

    private class P_ForwardAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private P_ForwardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingScoutHeaderPanel.this.handleNavigationForwardFromSwing();
        }
    }

    private class P_HistoryAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private P_HistoryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingScoutHeaderPanel.this.handleNavigationMenuFromSwing();
        }
    }

    private class P_RefreshAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private P_RefreshAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    IPage page;
                    IOutline outline = ((IDesktop)SwingScoutHeaderPanel.this.getScoutObject()).getOutline();
                    if (outline != null && (page = outline.getActivePage()) != null) {
                        try {
                            page.reloadPage();
                        }
                        catch (ProcessingException e) {
                            LOG.error("reloading page " + page, (Throwable)e);
                        }
                    }
                }
            };
            SwingScoutHeaderPanel.this.getSwingEnvironment().invokeScoutLater(r, 0L);
        }
    }
}

