/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.internal;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.tool.IToolButton;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.AbstractFormToolButton;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.action.ISwingScoutAction;
import org.eclipse.scout.rt.ui.swing.basic.IconGroup;
import org.eclipse.scout.rt.ui.swing.ext.job.SwingProgressHandler;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.AbstractJNavigationPanel;

public class JNavigationPanel
extends AbstractJNavigationPanel {
    private static final long serialVersionUID = 1L;
    private JToolBar m_swingToolBar;
    private JButton m_backButton;
    private JButton m_forwardButton;
    private JButton m_stopRefreshButton;
    private JButton m_historyButton;

    public JNavigationPanel(ISwingEnvironment env) {
        super(env);
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        SwingProgressHandler progressHandler = SwingProgressHandler.getInstance();
        if (progressHandler != null) {
            progressHandler.addStateChangeListener(new SwingProgressHandler.IStateChangeListener(){

                @Override
                public void stateChanged(SwingProgressHandler h) {
                    if (JNavigationPanel.this.m_stopRefreshButton == null) {
                        return;
                    }
                    if (h.isJobRunning()) {
                        JNavigationPanel.this.m_stopRefreshButton.setAction(JNavigationPanel.this.getStopAction());
                        JNavigationPanel.this.installButtonIcons(JNavigationPanel.this.m_stopRefreshButton, "navigation_stop", SwingUtility.getNlsText("Cancel", new String[0]));
                    } else {
                        JNavigationPanel.this.m_stopRefreshButton.setAction(JNavigationPanel.this.getRefreshAction());
                        JNavigationPanel.this.installButtonIcons(JNavigationPanel.this.m_stopRefreshButton, "navigation_refresh", SwingUtility.getNlsText("Refresh", new String[0]));
                    }
                }
            });
        }
    }

    @Override
    public void rebuild(IDesktop desktop) {
        this.removeAll();
        this.m_swingToolBar = new JToolBar(0);
        this.m_swingToolBar.setFloatable(false);
        this.m_swingToolBar.setBorder(new EmptyBorder(0, 3, 0, 0));
        this.m_swingToolBar.setOpaque(false);
        this.m_swingToolBar.setMargin(new Insets(0, 0, 0, 0));
        this.m_swingToolBar.setLayout(new GridBagLayout());
        this.m_historyButton = new JButton(this.getHistoryAction());
        this.m_historyButton.setOpaque(false);
        this.m_historyButton.setEnabled(this.getBackAction().isEnabled() || this.getForwardAction().isEnabled());
        this.installButtonIcons(this.m_historyButton, "navigation_history", SwingUtility.getNlsText("History", new String[0]));
        if (this.m_historyButton.getIcon() == null) {
            this.m_historyButton.setIcon(this.createArrowDownIcon());
        }
        this.addButton(this.m_swingToolBar, this.m_historyButton, new Insets(0, 0, 0, 0));
        this.m_backButton = new JButton(this.getBackAction());
        this.m_backButton.setOpaque(false);
        this.installButtonIcons(this.m_backButton, "navigation_back", SwingUtility.getNlsText("NavigationBackward", new String[0]));
        this.addButton(this.m_swingToolBar, this.m_backButton, new Insets(0, 0, 0, 3));
        this.m_forwardButton = new JButton(this.getForwardAction());
        this.m_forwardButton.setOpaque(false);
        this.installButtonIcons(this.m_forwardButton, "navigation_forward", SwingUtility.getNlsText("NavigationForward", new String[0]));
        this.addButton(this.m_swingToolBar, this.m_forwardButton, new Insets(0, 0, 0, 3));
        this.m_stopRefreshButton = new JButton(this.getRefreshAction());
        this.m_stopRefreshButton.setOpaque(false);
        this.installButtonIcons(this.m_stopRefreshButton, "navigation_refresh", SwingUtility.getNlsText("Refresh", new String[0]));
        this.addButton(this.m_swingToolBar, this.m_stopRefreshButton, new Insets(0, 0, 0, 0));
        boolean separatorRendered = false;
        IToolButton[] iToolButtonArray = desktop.getToolButtons();
        int n = iToolButtonArray.length;
        int n2 = 0;
        while (n2 < n) {
            IToolButton scoutToolButton = iToolButtonArray[n2];
            if (!(scoutToolButton instanceof AbstractFormToolButton)) {
                ISwingScoutAction<IToolButton> swingScoutToolButton;
                if (!separatorRendered) {
                    this.m_swingToolBar.addSeparator(new Dimension(10, 20));
                    separatorRendered = true;
                }
                if ((swingScoutToolButton = this.createSwingScoutToolButton(scoutToolButton)) != null) {
                    AbstractButton swingButton = (AbstractButton)swingScoutToolButton.getSwingField();
                    swingButton.setOpaque(false);
                    this.addButton(this.m_swingToolBar, swingButton, new Insets(0, 0, 0, 1));
                }
            }
            ++n2;
        }
        this.add(this.m_swingToolBar);
    }

    private void addButton(JToolBar toolBar, AbstractButton button, Insets insets) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 3;
        gbc.insets = insets;
        toolBar.add((Component)button, gbc);
    }

    @Override
    public void setBackAction(AbstractAction backAction) {
        super.setBackAction(backAction);
        if (this.m_backButton != null) {
            this.m_backButton.setAction(backAction);
        }
    }

    @Override
    public void setForwardAction(AbstractAction forwardAction) {
        super.setForwardAction(forwardAction);
        if (this.m_forwardButton != null) {
            this.m_forwardButton.setAction(forwardAction);
        }
    }

    @Override
    public void setHistoryAction(AbstractAction historyAction) {
        super.setHistoryAction(historyAction);
        if (this.m_historyButton != null) {
            this.m_historyButton.setAction(historyAction);
        }
    }

    @Override
    public Point getHistoryMenuLocation() {
        Point location = this.m_historyButton.getLocation();
        location.y += this.m_historyButton.getHeight();
        location.x = location.x;
        return location;
    }

    private void installButtonIcons(JButton button, String iconId, String tooltip) {
        IconGroup iconGroup = new IconGroup(iconId);
        button.setIcon(iconGroup.getIcon(IconGroup.IconState.NORMAL));
        if (iconGroup.hasIcon(IconGroup.IconState.DISABLED)) {
            button.setDisabledIcon(iconGroup.getIcon(IconGroup.IconState.DISABLED));
        }
        if (iconGroup.hasIcon(IconGroup.IconState.SELECTED)) {
            button.setPressedIcon(iconGroup.getIcon(IconGroup.IconState.SELECTED));
        }
        if (iconGroup.hasIcon(IconGroup.IconState.ROLLOVER)) {
            button.setRolloverIcon(iconGroup.getIcon(IconGroup.IconState.ROLLOVER));
        }
        button.setToolTipText(tooltip);
    }

    private Icon createArrowDownIcon() {
        int arrowWidth = 8;
        int arrowHeight = arrowWidth / 2;
        BufferedImage img = new BufferedImage(arrowWidth, arrowHeight, 2);
        Graphics2D g = img.createGraphics();
        g.setColor(UIManager.getColor("controlDkShadow"));
        int[] nArray = new int[3];
        nArray[1] = arrowWidth / 2;
        nArray[2] = arrowWidth;
        int[] nArray2 = new int[3];
        nArray2[1] = arrowHeight;
        g.fillPolygon(nArray, nArray2, 3);
        return new ImageIcon(img);
    }

    private ISwingScoutAction<IToolButton> createSwingScoutToolButton(IToolButton scoutToolButton) {
        return this.getSwingEnvironment().createAction(this, (IAction)scoutToolButton);
    }
}

