/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.keystroke.KeyStroke;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.keystroke.ISwtKeyStroke;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class AbstractSwtMenuAction {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractSwtMenuAction.class);
    private final ISwtEnvironment m_environment;
    private final IAction m_scoutAction;
    private boolean m_initialized;
    private boolean m_connectedToScout;
    private P_ScoutPropertyChangeListener m_scoutPropertyListener;
    private MenuItem m_swtMenuItem;
    private final Menu m_swtMenu;
    private ISwtKeyStroke[] m_swtKeyStrokes;
    private SelectionListener m_menuSelectionListener;

    public AbstractSwtMenuAction(Menu swtMenu, IAction action, boolean createInitial, ISwtEnvironment environment) {
        this.m_swtMenu = swtMenu;
        this.m_scoutAction = action;
        this.m_environment = environment;
        if (createInitial) {
            this.callInitializers(this.m_swtMenu);
        }
        this.m_swtMenu.addDisposeListener(new DisposeListener(){
            private static final long serialVersionUID = 1L;

            public void widgetDisposed(DisposeEvent event) {
                AbstractSwtMenuAction.this.disconnectFromScout();
            }
        });
    }

    protected final void callInitializers(Menu swtMenu) {
        if (this.m_initialized) {
            return;
        }
        this.m_initialized = true;
        this.initializeSwt(swtMenu);
        this.connectToScout();
    }

    protected final void connectToScout() {
        if (!this.m_connectedToScout) {
            this.attachScoutListeners();
            this.applyScoutProperties();
            this.m_connectedToScout = true;
        }
    }

    protected final void disconnectFromScout() {
        if (this.m_connectedToScout) {
            this.detachScoutListeners();
            this.m_connectedToScout = false;
        }
    }

    protected void attachScoutListeners() {
        if (this.m_scoutPropertyListener == null) {
            this.m_scoutPropertyListener = new P_ScoutPropertyChangeListener();
            this.m_scoutAction.addPropertyChangeListener((PropertyChangeListener)this.m_scoutPropertyListener);
        }
    }

    protected void detachScoutListeners() {
        if (this.m_scoutPropertyListener != null) {
            this.m_scoutAction.removePropertyChangeListener((PropertyChangeListener)this.m_scoutPropertyListener);
            this.m_scoutPropertyListener = null;
        }
    }

    protected void applyScoutProperties() {
        IAction scoutAction = this.getScoutAction();
        this.setEnabledFromScout(scoutAction.isEnabled());
        this.setTextFromScout(scoutAction.getText());
        this.setTooltipTextFromScout(scoutAction.getTooltipText());
        this.setIconFromScout(scoutAction.getIconId());
        this.updateKeyStrokeFromScout();
    }

    protected void setIconFromScout(String iconId) {
        if (!this.getSwtMenuItem().isDisposed()) {
            this.getSwtMenuItem().setImage(this.getEnvironment().getIcon(iconId));
        }
    }

    protected void setTooltipTextFromScout(String tooltipText) {
        if (!StringUtility.isNullOrEmpty((String)tooltipText)) {
            LOG.warn("unsuported method on swt");
        }
    }

    protected void setTextFromScout(String text) {
        if (!this.getSwtMenuItem().isDisposed()) {
            this.getSwtMenuItem().setText(text);
        }
    }

    protected void setEnabledFromScout(boolean enabled) {
        if (!this.getSwtMenuItem().isDisposed()) {
            this.getSwtMenuItem().setEnabled(enabled);
        }
    }

    protected void updateKeyStrokeFromScout() {
        int n;
        if (this.m_swtKeyStrokes != null) {
            ISwtKeyStroke[] iSwtKeyStrokeArray = this.m_swtKeyStrokes;
            n = this.m_swtKeyStrokes.length;
            int n2 = 0;
            while (n2 < n) {
                ISwtKeyStroke swtStroke = iSwtKeyStrokeArray[n2];
                this.getEnvironment().removeGlobalKeyStroke(swtStroke);
                ++n2;
            }
        }
        this.m_swtKeyStrokes = null;
        if (this.getScoutAction().getKeyStroke() != null) {
            KeyStroke scoutKeyStroke = new KeyStroke(this.getScoutAction().getKeyStroke());
            ISwtKeyStroke[] iSwtKeyStrokeArray = this.m_swtKeyStrokes = SwtUtility.getKeyStrokes((IKeyStroke)scoutKeyStroke, this.getEnvironment());
            int n3 = this.m_swtKeyStrokes.length;
            n = 0;
            while (n < n3) {
                ISwtKeyStroke swtStroke = iSwtKeyStrokeArray[n];
                this.getEnvironment().addGlobalKeyStroke(swtStroke);
                ++n;
            }
        }
    }

    protected void initializeSwt(Menu swtMenu) {
    }

    public ISwtEnvironment getEnvironment() {
        return this.m_environment;
    }

    public IAction getScoutAction() {
        return this.m_scoutAction;
    }

    public MenuItem getSwtMenuItem() {
        return this.m_swtMenuItem;
    }

    public void setSwtMenuItem(MenuItem swtMenuItem) {
        if (this.m_swtMenuItem != null) {
            this.m_swtMenuItem.removeSelectionListener(this.m_menuSelectionListener);
        }
        this.m_swtMenuItem = swtMenuItem;
        if (this.m_menuSelectionListener == null) {
            this.m_menuSelectionListener = new P_MenuItemSelectionListener();
        }
        this.m_swtMenuItem.addSelectionListener(this.m_menuSelectionListener);
    }

    protected Menu getSwtMenu() {
        return this.m_swtMenu;
    }

    private void handleSwtAction() {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                AbstractSwtMenuAction.this.getScoutAction().getUIFacade().fireActionFromUI();
            }
        };
        this.getEnvironment().invokeScoutLater(t, 0L);
    }

    private boolean isHandleScoutPropertyChange(String propertyName, Object newValue) {
        return true;
    }

    protected void handleScoutPropertyChange(String name, Object newValue) {
        if (name.equals("enabled")) {
            this.setEnabledFromScout((Boolean)newValue);
        } else if (name.equals("text")) {
            this.setTextFromScout((String)newValue);
        } else if (name.equals("tooltipText")) {
            this.setTooltipTextFromScout((String)newValue);
        } else if (name.equals("iconId")) {
            this.setIconFromScout((String)newValue);
        } else if (name.equals("keystroke")) {
            this.updateKeyStrokeFromScout();
        }
    }

    private class P_MenuItemSelectionListener
    extends SelectionAdapter {
        private P_MenuItemSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            AbstractSwtMenuAction.this.handleSwtAction();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            super.widgetDefaultSelected(e);
        }
    }

    private class P_ScoutPropertyChangeListener
    implements PropertyChangeListener {
        private P_ScoutPropertyChangeListener() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent e) {
            if (AbstractSwtMenuAction.this.isHandleScoutPropertyChange(e.getPropertyName(), e.getNewValue())) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        AbstractSwtMenuAction.this.handleScoutPropertyChange(e.getPropertyName(), e.getNewValue());
                    }
                };
                AbstractSwtMenuAction.this.getEnvironment().invokeSwtLater(t);
            }
        }
    }
}

