/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.table.celleditor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.IFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.ui.swt.basic.SwtScoutComposite;
import org.eclipse.scout.rt.ui.swt.basic.table.celleditor.FormFieldPopupEvent;
import org.eclipse.scout.rt.ui.swt.basic.table.celleditor.IFormFieldPopupEventListener;
import org.eclipse.scout.rt.ui.swt.form.ISwtScoutForm;
import org.eclipse.scout.rt.ui.swt.window.SwtScoutPartEvent;
import org.eclipse.scout.rt.ui.swt.window.SwtScoutPartListener;
import org.eclipse.scout.rt.ui.swt.window.popup.SwtScoutDropDownPopup;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class SwtScoutFormFieldPopup
extends SwtScoutComposite<IFormField> {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutFormFieldPopup.class);
    private SwtScoutDropDownPopup m_swtScoutPopup;
    private Composite m_owner;
    private int m_minWidth;
    private int m_prefWidth;
    private int m_minHeight;
    private int m_prefHeight;
    private int m_style;
    private SwtScoutPartListener m_popupEventListener;
    private List<IFormFieldPopupEventListener> m_eventListeners = new ArrayList<IFormFieldPopupEventListener>();
    private Object m_eventListenerLock = new Object();

    public SwtScoutFormFieldPopup(Composite owner) {
        this.m_owner = owner;
        this.m_style = 8;
        this.m_popupEventListener = new P_PopupEventListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initializeSwt(Composite parent) {
        super.initializeSwt(parent);
        final AtomicReference formRef = new AtomicReference();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    P_Form form = new P_Form();
                    form.setAutoAddRemoveOnDesktop(false);
                    form.startForm();
                    formRef.set(form);
                }
                catch (Throwable t) {
                    LOG.error("failed to start popup form", t);
                }
                AtomicReference atomicReference = formRef;
                synchronized (atomicReference) {
                    formRef.notifyAll();
                }
            }
        };
        AtomicReference atomicReference = formRef;
        synchronized (atomicReference) {
            this.getEnvironment().invokeScoutLater(runnable, 2345L);
            try {
                formRef.wait(2345L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        IForm form = (IForm)formRef.get();
        if (form == null) {
            LOG.error("No popup form available");
            return;
        }
        this.m_swtScoutPopup = new P_SwtScoutDropDownPopup((Control)this.m_owner, this.m_style);
        this.m_swtScoutPopup.setPopupOnField(true);
        this.m_swtScoutPopup.setHeightHint(this.m_prefHeight);
        this.m_swtScoutPopup.setWidthHint(this.m_prefWidth);
        this.m_swtScoutPopup.getShell().setMinimumSize(this.m_minWidth, this.m_minHeight);
        this.m_swtScoutPopup.getShell().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                switch (event.detail) {
                    case 2: {
                        event.doit = false;
                        SwtScoutFormFieldPopup.this.closePopup(2);
                        break;
                    }
                    case 4: {
                        event.doit = false;
                        SwtScoutFormFieldPopup.this.closePopup(1);
                    }
                }
            }
        });
        this.m_swtScoutPopup.addSwtScoutPartListener(this.m_popupEventListener);
        try {
            this.m_swtScoutPopup.showForm(form);
            this.installTraverseKeyStrokes((Control)this.m_swtScoutPopup.getSwtContentPane());
        }
        catch (Throwable t) {
            LOG.error("failed to show popup form", t);
        }
        this.m_owner.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                SwtScoutFormFieldPopup.this.getSwtContainer().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (SwtScoutFormFieldPopup.this.m_swtScoutPopup != null) {
                            SwtScoutFormFieldPopup.this.m_swtScoutPopup.autoAdjustBounds();
                        }
                    }
                });
            }
        });
        this.setSwtContainer(this.m_owner);
    }

    public void touch() {
        if (this.m_swtScoutPopup != null) {
            this.touch((Control)this.m_swtScoutPopup.getSwtContentPane());
        }
    }

    private void touch(Control control) {
        if (control == null || control.isDisposed()) {
            return;
        }
        Event event = new Event();
        event.widget = control;
        control.notifyListeners(31, event);
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.touch(child);
                ++n2;
            }
        }
    }

    private void installTraverseKeyStrokes(Control control) {
        control.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                switch (e.detail) {
                    case 16: {
                        e.doit = false;
                        SwtScoutFormFieldPopup.this.closePopup(9);
                        break;
                    }
                    case 8: {
                        e.doit = false;
                        SwtScoutFormFieldPopup.this.closePopup(17);
                    }
                }
            }
        });
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.installTraverseKeyStrokes(child);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(IFormFieldPopupEventListener eventListener) {
        Object object = this.m_eventListenerLock;
        synchronized (object) {
            this.m_eventListeners.add(eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(IFormFieldPopupEventListener eventListener) {
        Object object = this.m_eventListenerLock;
        synchronized (object) {
            this.m_eventListeners.remove(eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyEventListeners(FormFieldPopupEvent event) {
        IFormFieldPopupEventListener[] eventListeners;
        Object object = this.m_eventListenerLock;
        synchronized (object) {
            eventListeners = this.m_eventListeners.toArray(new IFormFieldPopupEventListener[this.m_eventListeners.size()]);
        }
        IFormFieldPopupEventListener[] iFormFieldPopupEventListenerArray = eventListeners;
        int n = eventListeners.length;
        int n2 = 0;
        while (n2 < n) {
            IFormFieldPopupEventListener eventListener = iFormFieldPopupEventListenerArray[n2];
            eventListener.handleEvent(event);
            ++n2;
        }
    }

    public void closePopup(int type) {
        this.touch();
        this.m_swtScoutPopup.removeSwtScoutPartListener(this.m_popupEventListener);
        this.m_swtScoutPopup.closePart();
        this.m_swtScoutPopup = null;
        this.notifyEventListeners(new FormFieldPopupEvent((IFormField)this.getScoutObject(), type));
    }

    public SwtScoutDropDownPopup getPopup() {
        return this.m_swtScoutPopup;
    }

    public boolean isClosed() {
        return this.m_swtScoutPopup == null || this.m_swtScoutPopup.getSwtContentPane() == null || this.m_swtScoutPopup.getSwtContentPane().isDisposed();
    }

    public ISwtScoutForm getInnerSwtScoutForm() {
        return this.m_swtScoutPopup.getUiForm();
    }

    public int getMinWidth() {
        return this.m_minWidth;
    }

    public void setMinWidth(int minWidth) {
        this.m_minWidth = minWidth;
    }

    public int getPrefWidth() {
        return this.m_prefWidth;
    }

    public void setPrefWidth(int prefWidth) {
        this.m_prefWidth = prefWidth;
    }

    public int getMinHeight() {
        return this.m_minHeight;
    }

    public void setMinHeight(int minHeight) {
        this.m_minHeight = minHeight;
    }

    public int getPrefHeight() {
        return this.m_prefHeight;
    }

    public void setPrefHeight(int prefHeight) {
        this.m_prefHeight = prefHeight;
    }

    public int getStyle() {
        return this.m_style;
    }

    public void setStyle(int style) {
        this.m_style = style;
    }

    private class P_Form
    extends AbstractForm {
        protected boolean getConfiguredModal() {
            return false;
        }

        protected int getConfiguredDisplayHint() {
            return 20;
        }

        public String getDisplayViewId() {
            return "C";
        }

        protected boolean getConfiguredAskIfNeedSave() {
            return false;
        }

        public void startForm() throws ProcessingException {
            this.startInternal((IFormHandler)new FormHandler());
        }

        public MainBox getMainBox() {
            return (MainBox)this.getRootGroupBox();
        }

        private class FormHandler
        extends AbstractFormHandler {
            private FormHandler() {
            }
        }

        @Order(value=10.0)
        public class MainBox
        extends AbstractGroupBox {
            protected void injectFieldsInternal(List<IFormField> fieldList) {
                fieldList.add((IFormField)SwtScoutFormFieldPopup.this.getScoutObject());
            }

            protected boolean getConfiguredBorderVisible() {
                return false;
            }

            protected int getConfiguredGridColumnCount() {
                return 1;
            }

            protected boolean getConfiguredGridUseUiWidth() {
                return true;
            }

            protected boolean getConfiguredGridUseUiHeight() {
                return true;
            }
        }
    }

    private class P_PopupEventListener
    implements SwtScoutPartListener {
        private P_PopupEventListener() {
        }

        @Override
        public void partChanged(SwtScoutPartEvent e) {
            if (e.getType() == 50) {
                SwtScoutFormFieldPopup.this.closePopup(1);
            }
        }
    }

    private class P_SwtScoutDropDownPopup
    extends SwtScoutDropDownPopup {
        private ShellAdapter m_shellListener;

        public P_SwtScoutDropDownPopup(Control ownerComponent, int style) {
            super(SwtScoutFormFieldPopup.this.getEnvironment(), ownerComponent, (Composite)null, style);
        }

        @Override
        protected void installFocusListener() {
            if (this.m_shellListener == null) {
                this.m_shellListener = new ShellAdapter(){

                    public void shellDeactivated(ShellEvent e) {
                        P_SwtScoutDropDownPopup.this.closePart();
                        P_SwtScoutDropDownPopup.this.fireSwtScoutPartEvent(new SwtScoutPartEvent(P_SwtScoutDropDownPopup.this, 50));
                    }
                };
                this.getShell().addShellListener((ShellListener)this.m_shellListener);
            }
        }

        @Override
        protected void uninstallFocusLostListener() {
            if (this.m_shellListener != null) {
                this.getShell().removeShellListener((ShellListener)this.m_shellListener);
            }
            this.m_shellListener = null;
        }
    }
}

