/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.button;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.WeakEventListener;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.form.fields.button.ButtonEvent;
import org.eclipse.scout.rt.client.ui.form.fields.button.ButtonListener;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.ui.swt.LogicalGridData;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.SwtMenuUtility;
import org.eclipse.scout.rt.ui.swt.basic.comp.HyperlinkEx;
import org.eclipse.scout.rt.ui.swt.ext.ButtonEx;
import org.eclipse.scout.rt.ui.swt.extension.IUiDecoration;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.button.ISwtScoutButton;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class SwtScoutButton
extends SwtScoutFieldComposite<IButton>
implements ISwtScoutButton {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutButton.class);
    private ButtonListener m_scoutButtonListener;
    private OptimisticLock m_selectionLock = new OptimisticLock();
    private boolean m_handleActionPending;
    private Menu m_contextMenu;

    @Override
    protected void initializeSwt(Composite parent) {
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        this.setSwtContainer(container);
        ButtonEx swtFieldAsButton = null;
        HyperlinkEx swtFieldAsLink = null;
        switch (((IButton)this.getScoutObject()).getDisplayStyle()) {
            case 2: {
                ButtonEx swtButton;
                swtFieldAsButton = swtButton = this.getEnvironment().getFormToolkit().createButtonEx(container, 16400);
                break;
            }
            case 1: {
                ButtonEx swtButton;
                swtFieldAsButton = swtButton = this.getEnvironment().getFormToolkit().createButtonEx(container, 0x1000002);
                break;
            }
            case 3: {
                int style = 0x1000000;
                HyperlinkEx swtLink = this.getEnvironment().getFormToolkit().createHyperlink(container, "", style);
                swtLink.setUnderlined(true);
                swtFieldAsLink = swtLink;
                break;
            }
            default: {
                int style = 0x1000008;
                if (((IButton)this.getScoutObject()).hasMenus()) {
                    style |= 4;
                }
                ButtonEx swtButton = this.getEnvironment().getFormToolkit().createButtonEx(container, style);
                swtButton.setDropDownEnabled(true);
                swtFieldAsButton = swtButton;
            }
        }
        this.setSwtLabel(null);
        if (swtFieldAsButton != null) {
            this.m_contextMenu = new Menu((Decorations)swtFieldAsButton.getShell(), 8);
            this.m_contextMenu.addMenuListener((MenuListener)new P_ContextMenuListener());
            swtFieldAsButton.setMenu(this.m_contextMenu);
            swtFieldAsButton.addListener(44, new P_SwtSelectionListener());
            this.setSwtField((Control)swtFieldAsButton);
            LogicalGridData gd = (LogicalGridData)swtFieldAsButton.getLayoutData();
            if (((IButton)this.getScoutObject()).isProcessButton() && !gd.useUiHeight) {
                gd.useUiHeight = true;
                IUiDecoration deco = UiDecorationExtensionPoint.getLookAndFeel();
                gd.heightHint = deco.getProcessButtonHeight();
            }
        } else if (swtFieldAsLink != null) {
            swtFieldAsLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    SwtScoutButton.this.handleSwtAction();
                }
            });
            this.setSwtField((Control)swtFieldAsLink);
            this.getSwtContainer().setTabList(new Control[]{swtFieldAsLink});
        }
        this.getSwtContainer().setLayout((Layout)new LogicalGridLayout(0, 0));
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        if (this.m_scoutButtonListener == null) {
            this.m_scoutButtonListener = new P_ScoutButtonListener();
            ((IButton)this.getScoutObject()).addButtonListener(this.m_scoutButtonListener);
        }
    }

    @Override
    protected void detachScout() {
        super.detachScout();
        if (this.m_scoutButtonListener != null) {
            ((IButton)this.getScoutObject()).removeButtonListener(this.m_scoutButtonListener);
            this.m_scoutButtonListener = null;
        }
    }

    @Override
    public Control getSwtField() {
        return super.getSwtField();
    }

    @Override
    protected void applyScoutProperties() {
        super.applyScoutProperties();
        IButton b = (IButton)this.getScoutObject();
        b.hasMenus();
        this.setIconIdFromScout(b.getIconId());
        this.setImageFromScout(b.getImage());
        this.setSelectionFromScout(b.isSelected());
        this.setLabelFromScout(b.getLabel());
    }

    protected void setIconIdFromScout(String s) {
        if (s != null) {
            Image icon = this.getEnvironment().getIcon(s);
            Control comp = this.getSwtField();
            if (comp instanceof Button) {
                Button b = (Button)comp;
                b.setImage(icon);
            } else {
                boolean cfr_ignored_0 = comp instanceof Hyperlink;
            }
        }
    }

    @Override
    protected void setLabelFromScout(String s) {
        Control comp = this.getSwtField();
        if (comp instanceof Button) {
            Button b = (Button)comp;
            String label = s;
            b.setText(label == null ? "" : label);
        } else if (comp instanceof Hyperlink) {
            Hyperlink t = (Hyperlink)comp;
            String label = StringUtility.removeMnemonic((String)s);
            t.setText(label == null ? "" : label);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setSelectionFromScout(boolean b) {
        try {
            if (!this.m_selectionLock.acquire()) return;
            switch (((IButton)this.getScoutObject()).getDisplayStyle()) {
                case 1: 
                case 2: {
                    Button but;
                    Control comp = this.getSwtField();
                    if (!(comp instanceof Button) || b == (but = (Button)comp).getSelection()) return;
                    but.setSelection(b);
                }
                default: {
                    return;
                }
            }
        }
        finally {
            this.m_selectionLock.release();
        }
    }

    protected void setSelectionFromSwt(final boolean b) {
        try {
            if (this.m_selectionLock.acquire()) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        if (((IButton)SwtScoutButton.this.getScoutObject()).isSelected() != b) {
                            ((IButton)SwtScoutButton.this.getScoutObject()).getUIFacade().setSelectedFromUI(b);
                        }
                        ((IButton)SwtScoutButton.this.getScoutObject()).getUIFacade().fireButtonClickedFromUI();
                    }
                };
                this.getEnvironment().invokeScoutLater(t, 0L);
            }
        }
        finally {
            this.m_selectionLock.release();
        }
    }

    protected void handleSwtAction() {
        if (!this.m_handleActionPending) {
            this.m_handleActionPending = true;
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    try {
                        ((IButton)SwtScoutButton.this.getScoutObject()).getUIFacade().fireButtonClickedFromUI();
                    }
                    finally {
                        SwtScoutButton.this.m_handleActionPending = false;
                    }
                }
            };
            this.getEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void setImageFromScout(Object img) {
        if (img instanceof Image) {
            Control comp = this.getSwtField();
            if (comp instanceof Button) {
                Button b = (Button)comp;
                b.setImage((Image)img);
            } else {
                boolean cfr_ignored_0 = comp instanceof Hyperlink;
            }
        }
    }

    protected void disarmButtonFromScout() {
    }

    protected void requestPopupFromScout() {
        if (this.m_contextMenu != null) {
            this.m_contextMenu.setVisible(true);
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("iconId")) {
            this.setIconIdFromScout((String)newValue);
        } else if (name.equals("image")) {
            this.setImageFromScout(newValue);
        } else if (name.equals("selected")) {
            this.setSelectionFromScout((Boolean)newValue);
        }
    }

    private class P_ContextMenuListener
    extends MenuAdapter {
        private P_ContextMenuListener() {
        }

        public void menuShown(MenuEvent e) {
            MenuItem[] menuItemArray = SwtScoutButton.this.m_contextMenu.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem item = menuItemArray[n2];
                this.disposeMenuItem(item);
                ++n2;
            }
            final AtomicReference scoutMenusRef = new AtomicReference();
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    IMenu[] scoutMenus = ((IButton)SwtScoutButton.this.getScoutObject()).getUIFacade().fireButtonPopupFromUI();
                    scoutMenusRef.set(scoutMenus);
                }
            };
            JobEx job = SwtScoutButton.this.getEnvironment().invokeScoutLater(t, 1200L);
            try {
                job.join(1200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (scoutMenusRef.get() != null) {
                SwtMenuUtility.fillContextMenu((IMenu[])scoutMenusRef.get(), SwtScoutButton.this.m_contextMenu, SwtScoutButton.this.getEnvironment());
            }
        }

        private void disposeMenuItem(MenuItem item) {
            Menu menu = item.getMenu();
            if (menu != null) {
                MenuItem[] menuItemArray = menu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem childItem = menuItemArray[n2];
                    this.disposeMenuItem(childItem);
                    ++n2;
                }
                menu.dispose();
            }
            item.dispose();
        }
    }

    private class P_ScoutButtonListener
    implements ButtonListener,
    WeakEventListener {
        private P_ScoutButtonListener() {
        }

        public void buttonChanged(ButtonEvent e) {
            switch (e.getType()) {
                case 3: {
                    SwtScoutButton.this.getEnvironment().invokeSwtLater(new Runnable(){

                        @Override
                        public void run() {
                            SwtScoutButton.this.disarmButtonFromScout();
                        }
                    });
                    break;
                }
                case 4: {
                    SwtScoutButton.this.getEnvironment().invokeSwtLater(new Runnable(){

                        @Override
                        public void run() {
                            SwtScoutButton.this.requestPopupFromScout();
                        }
                    });
                }
            }
        }
    }

    private class P_SwtSelectionListener
    implements Listener {
        private P_SwtSelectionListener() {
        }

        public void handleEvent(Event event) {
            block0 : switch (event.type) {
                case 44: {
                    switch (((IButton)SwtScoutButton.this.getScoutObject()).getDisplayStyle()) {
                        case 1: 
                        case 2: {
                            SwtScoutButton.this.setSelectionFromSwt(((Button)SwtScoutButton.this.getSwtField()).getSelection());
                            break block0;
                        }
                    }
                    SwtScoutButton.this.handleSwtAction();
                }
            }
        }
    }
}

