/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.services.common.icon.IconSpec;
import org.eclipse.scout.rt.client.ui.IIconLocator;
import org.eclipse.scout.rt.ui.swt.util.ISwtIconLocator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class SwtIconLocator
implements ISwtIconLocator {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtIconLocator.class);
    private final ImageRegistry imageRegistry;
    private final Set<String> m_missingImages = new HashSet<String>();
    private final IIconLocator m_iconLocator;
    private Display m_display;

    public SwtIconLocator(IIconLocator iconLocator) {
        this.m_iconLocator = iconLocator;
        this.m_display = Display.getCurrent();
        this.imageRegistry = new ImageRegistry(this.m_display);
        this.imageRegistry.put("close_a_16", this.getFalse());
    }

    @Override
    public ImageDescriptor getImageDescriptor(String name) {
        if (name == null) {
            return null;
        }
        if (this.m_missingImages.contains(name)) {
            return null;
        }
        ImageDescriptor desc = this.imageRegistry.getDescriptor(name);
        if (desc == null) {
            desc = this.createImageDescriptor(name);
            if (desc == null) {
                this.m_missingImages.add(name);
            } else {
                this.imageRegistry.put(name, desc);
            }
        }
        return desc;
    }

    @Override
    public Image getIcon(String name, int iconDecoration) {
        Image img = null;
        String iconName = name;
        if (iconName == null) {
            iconName = "";
        }
        switch (iconDecoration) {
            case 1: {
                iconName = String.valueOf(iconName) + "__" + 1;
            }
        }
        if (StringUtility.isNullOrEmpty((String)iconName) || "null".equals(iconName)) {
            return null;
        }
        if (this.m_missingImages.contains(iconName)) {
            return null;
        }
        img = this.imageRegistry.get(iconName);
        if (img != null) {
            return img;
        }
        Image undecoratedImg = null;
        if (StringUtility.hasText((String)name) && !"null".equals(name) && !this.m_missingImages.contains(name) && (undecoratedImg = this.imageRegistry.get(name)) == null) {
            ImageDescriptor desc = this.createImageDescriptor(name);
            if (desc != null) {
                this.imageRegistry.put(name, desc);
                undecoratedImg = this.imageRegistry.get(name);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("image found '" + name + "'.");
                }
            } else {
                LOG.warn("image '" + name + "' could not be found!");
                this.m_missingImages.add(name);
            }
        }
        String decorationId = null;
        switch (iconDecoration) {
            case 1: {
                decorationId = "cell_editable";
            }
        }
        Image decorationImg = null;
        if (StringUtility.hasText((String)decorationId) && !"null".equals(decorationId) && !this.m_missingImages.contains(decorationId) && (decorationImg = this.imageRegistry.get(decorationId)) == null) {
            ImageDescriptor desc = this.createImageDescriptor(decorationId);
            if (desc != null) {
                this.imageRegistry.put(decorationId, desc);
                decorationImg = this.imageRegistry.get(decorationId);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("image found '" + decorationId + "'.");
                }
            } else {
                LOG.warn("image '" + decorationId + "' could not be found!");
                this.m_missingImages.add(decorationId);
            }
        }
        img = decorationImg != null ? this.createCombinedImageDescriptor(undecoratedImg, decorationImg) : undecoratedImg;
        return img;
    }

    protected Image createCombinedImageDescriptor(Image undecoratedImg, Image decorationImg) {
        if (undecoratedImg == null) {
            return decorationImg;
        }
        if (decorationImg == null) {
            return undecoratedImg;
        }
        Rectangle undecoratedImgBounds = undecoratedImg.getBounds();
        Rectangle decorationImgBounds = decorationImg.getBounds();
        Image img = new Image((Device)this.m_display, new Rectangle(0, 0, decorationImgBounds.width + undecoratedImgBounds.width, Math.max(decorationImgBounds.height, undecoratedImgBounds.height)));
        GC gc = null;
        try {
            gc = new GC((Drawable)img);
            gc.drawImage(decorationImg, 0, 0);
            gc.drawImage(undecoratedImg, decorationImgBounds.width, 0);
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
        return img;
    }

    protected ImageDescriptor createImageDescriptor(String name) {
        ImageDescriptor desc = null;
        IconSpec spec = this.m_iconLocator.getIconSpec(name);
        if (spec != null) {
            desc = ImageDescriptor.createFromImageData((ImageData)new ImageData((InputStream)new ByteArrayInputStream(spec.getContent())));
            if (LOG.isDebugEnabled()) {
                LOG.debug("image found '" + name + "'.");
            }
        } else {
            LOG.warn("image '" + name + "' could not be found!");
            this.m_missingImages.add(name);
        }
        return desc;
    }

    @Override
    public void dispose() {
        this.imageRegistry.dispose();
    }

    private Image getFalse() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        Image img = new Image((Device)display, 16, 16);
        GC gc = null;
        try {
            gc = new GC((Drawable)img);
            gc.setBackground(display.getSystemColor(2));
            gc.drawRectangle(2, 2, 12, 12);
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
        return img;
    }
}

