/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.compatibility.v37v41.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.TargetDefinition;
import org.eclipse.pde.internal.core.target.provisional.IBundleContainer;
import org.eclipse.pde.internal.core.target.provisional.ITargetDefinition;
import org.eclipse.pde.internal.core.target.provisional.ITargetHandle;
import org.eclipse.pde.internal.core.target.provisional.ITargetPlatformService;
import org.eclipse.scout.sdk.compatibility.internal.service.ITargetPlatformCompatService;
import org.eclipse.scout.sdk.compatibility.v37v41.internal.provisional.LoadTargetDefinitionJobSync;

public class TargetPlatformCompatService
implements ITargetPlatformCompatService {
    public void resolveTargetPlatform(IFile targetFile, boolean loadPlatform, IProgressMonitor monitor) throws CoreException {
        ITargetPlatformService targetService = (ITargetPlatformService)PDECore.getDefault().acquireService(ITargetPlatformService.class.getName());
        ITargetHandle handle = targetService.getTarget(targetFile);
        ITargetDefinition def = handle.getTargetDefinition();
        def.resolve(monitor);
        if (loadPlatform) {
            LoadTargetDefinitionJobSync loadJob = new LoadTargetDefinitionJobSync(def);
            loadJob.run(monitor);
        }
    }

    public void removeInstallableUnitsFromTarget(IFile targetFile, String[] unitIds) throws CoreException {
        ITargetPlatformService svc = (ITargetPlatformService)PDECore.getDefault().acquireService(ITargetPlatformService.class.getName());
        ITargetHandle handle = svc.getTarget(targetFile);
        TargetDefinition td = (TargetDefinition)handle.getTargetDefinition();
        IBundleContainer[] features = td.getBundleContainers();
        if (features != null && features.length > 0) {
            ArrayList<IBundleContainer> newList = new ArrayList<IBundleContainer>(features.length);
            IBundleContainer[] iBundleContainerArray = features;
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                IBundleContainer container = iBundleContainerArray[n2];
                if (container instanceof IUBundleContainer) {
                    IInstallableUnit[] units;
                    IUBundleContainer iuContainer = (IUBundleContainer)container;
                    IInstallableUnit[] iInstallableUnitArray = units = iuContainer.getInstallableUnits();
                    int n3 = units.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IInstallableUnit unit = iInstallableUnitArray[n4];
                        if (!this.isInList(unit.getId(), unitIds)) {
                            newList.add(container);
                        }
                        ++n4;
                    }
                } else {
                    newList.add(container);
                }
                ++n2;
            }
            td.setBundleContainers(newList.toArray(new IBundleContainer[newList.size()]));
            svc.saveTargetDefinition((ITargetDefinition)td);
        }
    }

    private boolean isInList(String search, String[] list) {
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (search.equals(s)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void addInstallableUnitsToTarget(IFile targetFile, String[] unitIds, String[] versions, String[] repositories) throws CoreException {
        URI[] uris = new URI[repositories.length];
        try {
            int i = 0;
            while (i < repositories.length) {
                uris[i] = new URI(repositories[i]);
                ++i;
            }
        }
        catch (URISyntaxException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.scout.sdk.compatibility", "invalid URI provided", (Throwable)e));
        }
        ITargetPlatformService svc = (ITargetPlatformService)PDECore.getDefault().acquireService(ITargetPlatformService.class.getName());
        ITargetHandle handle = svc.getTarget(targetFile);
        ITargetDefinition td = handle.getTargetDefinition();
        IBundleContainer[] features = td.getBundleContainers();
        int s = unitIds.length;
        if (features != null) {
            s += features.length;
        }
        ArrayList<Object> newList = new ArrayList<Object>(s);
        if (features != null && features.length > 0) {
            IBundleContainer[] iBundleContainerArray = features;
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                IBundleContainer container = iBundleContainerArray[n2];
                newList.add(container);
                ++n2;
            }
        }
        int i = 0;
        while (i < unitIds.length) {
            IUBundleContainer group = (IUBundleContainer)svc.newIUContainer(new String[]{unitIds[i]}, new String[]{versions[i]}, new URI[]{uris[i]}, 4);
            newList.add(group);
            ++i;
        }
        td.setBundleContainers(newList.toArray(new IBundleContainer[newList.size()]));
        svc.saveTargetDefinition(td);
    }
}

