/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.rap.ui.internal.extensions.bundle;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.compatibility.internal.PlatformVersionUtility;
import org.eclipse.scout.sdk.operation.project.AbstractScoutProjectNewOperation;
import org.eclipse.scout.sdk.rap.ui.internal.wizard.project.RapTargetPlatformWizardPage;
import org.eclipse.scout.sdk.ui.extensions.bundle.INewScoutBundleHandler;
import org.eclipse.scout.sdk.ui.extensions.bundle.ScoutBundleUiExtension;
import org.eclipse.scout.sdk.ui.wizard.project.IScoutProjectWizard;
import org.eclipse.scout.sdk.util.PropertyMap;
import org.eclipse.scout.sdk.validation.JavaElementValidator;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.osgi.framework.Version;

public class RapScoutBundleExtension
implements INewScoutBundleHandler {
    private boolean m_rapUiSelected = true;
    public static final String ID = "org.eclipse.scout.sdk.ui.UiRapBundle";

    public void init(IScoutProjectWizard wizard, ScoutBundleUiExtension extension) {
        IScoutBundle selected = wizard.getScoutProject();
        boolean available = selected == null || selected.getType().equals("UI_RAP") || selected.getType().equals("CLIENT");
        wizard.getProjectWizardPage().setBundleNodeAvailable(available, available, new String[]{ID});
    }

    public IStatus getStatus(IScoutProjectWizard wizard) {
        IScoutBundle selected = wizard.getScoutProject();
        if (selected == null && !wizard.getProjectWizardPage().hasSelectedBundle(new String[]{"CLIENT"})) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"NoRapWithoutClient"));
        }
        if (this.m_rapUiSelected) {
            String clientMobileBundleName = AbstractScoutProjectNewOperation.getPluginName((String)wizard.getProjectWizardPage().getProjectName(), (String)wizard.getProjectWizardPage().getProjectNamePostfix(), (String)".client.mobile");
            IStatus s = JavaElementValidator.validateNewBundleName((String)clientMobileBundleName);
            if (!s.isOK()) {
                return s;
            }
            if (PlatformVersionUtility.getPlatformVersion().compareTo((Object)new Version(3, 6, 0)) < 0) {
                return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"NoRapBeforeHelios"));
            }
        }
        return Status.OK_STATUS;
    }

    public void bundleSelectionChanged(IScoutProjectWizard wizard, boolean selected) {
        this.m_rapUiSelected = selected;
        Object page = wizard.getPage(RapTargetPlatformWizardPage.class.getName());
        if (page == null) {
            page = new RapTargetPlatformWizardPage();
            wizard.addPage((IWizardPage)page);
        }
        page.setExcludePage(!selected);
    }

    public void putProperties(IScoutProjectWizard wizard, PropertyMap properties) {
        IScoutBundle uiRap;
        IScoutBundle selected = wizard.getScoutProject();
        if (selected != null && (uiRap = selected.getParentBundle(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"UI_RAP"}), true)) != null && uiRap.getJavaProject() != null) {
            properties.setProperty("BUNDLE_RAP_NAME", (Object)uiRap.getProject().getName());
            ((List)properties.getProperty("CREATED_BUNDLES", List.class)).add(uiRap.getJavaProject());
        }
    }
}

