/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.io.Reader;
import java.util.HashMap;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.NumberUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.ConfigPropertyMethodUpdateOperation;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.action.AbstractScoutHandler;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.field.TableFieldNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.page.PageWithTableNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.table.ColumnTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.table.TableNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class TableColumnWidthsPasteAction
extends AbstractScoutHandler {
    private static final String TABLE_MENU_COLUMN_COPY_CLIPBOARD_IDENTIFIER = "COLUMN_COPY_CLIPBOARD_IDENTIFIER";
    private static final String COLUMN_WIDTH_METHOD_NAME = "getConfiguredWidth";
    private IType m_type;
    private HashMap<String, Integer> m_widthsMap;

    public TableColumnWidthsPasteAction() {
        super(Texts.get((String)"Action_PasteColumnWidths"), ScoutSdkUi.getImageDescriptor("tableColumn.png"), "CTRL+V", false, IScoutHandler.Category.IMPORT);
    }

    @Override
    public Object execute(Shell shell, IPage[] selection, ExecutionEvent event) {
        if (this.m_widthsMap != null && this.m_widthsMap.size() > 0) {
            this.changeColumnWidths(this.m_type, this.m_widthsMap, shell);
        } else {
            this.showInfoMessageBox(shell, Texts.get((String)"Action_PasteColumnWidths_InvalidClipboard"));
        }
        return null;
    }

    @Override
    public boolean isVisible() {
        return this.isEditable((IJavaElement)this.m_type);
    }

    public void init(IPage origin) {
        this.determineTableType(origin);
    }

    private boolean fastDetection(String content) {
        try {
            Object identifier = TypeUtility.getFieldConstant((IField)TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.basic.table.menus.CopyWidthsOfColumnsMenu").getField(TABLE_MENU_COLUMN_COPY_CLIPBOARD_IDENTIFIER));
            if (identifier instanceof String) {
                return content.startsWith(identifier.toString());
            }
            return false;
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("Unable to get the identification constant from the scout class", e);
            return true;
        }
    }

    private void showInfoMessageBox(Shell s, String message) {
        MessageBox msgBox = new MessageBox(s, 34);
        msgBox.setMessage(message);
        msgBox.open();
    }

    private String getStringFromClipboard() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Reader reader = DataFlavor.stringFlavor.getReaderForText(clipboard.getContents(null));
            return IOUtility.getContent((Reader)reader);
        }
        catch (Exception e) {
            return null;
        }
    }

    private HashMap<String, Integer> parseContent(String content) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            content = content.replaceAll("\r", "");
            String[] lines = content.split("\n");
            int i = 1;
            while (i < lines.length) {
                String line = lines[i];
                if (StringUtility.hasText((String)line)) {
                    String[] parts = line.split("\t");
                    Integer columnWidth = NumberUtility.nvl((Integer)new Integer(parts[1]), (Number)0);
                    if (columnWidth < 0) {
                        columnWidth = 0;
                    }
                    map.put(parts[0], columnWidth);
                }
                ++i;
            }
            return map;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void changeColumnWidths(IType tableType, HashMap<String, Integer> map, Shell shell) {
        IType[] iTypeArray = ScoutTypeUtility.getColumns((IType)tableType);
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType innerType = iTypeArray[n2];
            String className = innerType.getFullyQualifiedName();
            Integer columnWidth = map.get(className);
            if (columnWidth != null && columnWidth >= 0) {
                ConfigPropertyMethodUpdateOperation op = new ConfigPropertyMethodUpdateOperation(innerType, COLUMN_WIDTH_METHOD_NAME, "  return " + columnWidth.toString() + ";", true);
                new OperationJob(new IOperation[]{op}).schedule();
            } else if (columnWidth != null) {
                this.showInfoMessageBox(shell, Texts.get((String)"ColumnWidthPasteInvalidWidth", (String[])new String[]{columnWidth.toString()}));
            }
            ++n2;
        }
    }

    private void determineTableType(IPage page) {
        IType[] tables;
        if (page instanceof ColumnTablePage) {
            this.m_type = ((ColumnTablePage)page).getColumnDeclaringType();
        } else if (page instanceof PageWithTableNodePage) {
            tables = ScoutTypeUtility.getTables((IType)((PageWithTableNodePage)page).getType());
            if (tables.length > 0) {
                this.m_type = tables[0];
            }
        } else if (page instanceof TableFieldNodePage) {
            tables = ScoutTypeUtility.getTables((IType)((TableFieldNodePage)page).getType());
            if (tables.length > 0) {
                this.m_type = tables[0];
            }
        } else if (page instanceof TableNodePage) {
            this.m_type = ((TableNodePage)page).getType();
        }
        String content = this.getStringFromClipboard();
        if (content != null && this.fastDetection(content)) {
            this.m_widthsMap = this.parseContent(content);
            if (this.m_type != null && this.m_widthsMap != null) {
                String tableTypeClassName = this.m_type.getFullyQualifiedName();
                for (String clazz : this.m_widthsMap.keySet()) {
                    if (clazz.startsWith(tableTypeClassName)) continue;
                    this.m_type = null;
                    this.m_widthsMap = null;
                    break;
                }
            }
        }
    }
}

