/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.delete;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.JavaElementDeleteOperation;
import org.eclipse.scout.sdk.ui.action.AbstractScoutHandler;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.dialog.IMemberSelectionChangedListener;
import org.eclipse.scout.sdk.ui.dialog.MemberSelectionDialog;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.widgets.Shell;

public class FormDeleteAction
extends AbstractScoutHandler {
    private IType m_formType;
    private IType m_formData;
    private IType m_processServiceInterface;
    private IType m_processServiceImplementation;
    private MemberSelectionDialog m_confirmDialog;

    public FormDeleteAction() {
        super(Texts.get((String)"DeleteForm"), ScoutSdkUi.getImageDescriptor("form_remove.png"), "Delete", false, IScoutHandler.Category.DELETE);
    }

    @Override
    public boolean isVisible() {
        return this.isEditable((IJavaElement)this.m_formType);
    }

    @Override
    public Object execute(Shell shell, IPage[] selection, ExecutionEvent event) throws ExecutionException {
        this.m_confirmDialog = new MemberSelectionDialog(shell, Texts.get((String)"Action_deleteTypeX", (String[])new String[]{this.getFormType().getElementName()}));
        this.m_confirmDialog.addMemberSelectionListener(new P_SelectionValidationListener());
        ArrayList<IMember> members = new ArrayList<IMember>();
        ArrayList<IMember> selectedMembers = new ArrayList<IMember>();
        this.collectAffectedMembers(members, selectedMembers);
        this.m_confirmDialog.setMembers(members.toArray(new IMember[members.size()]));
        this.m_confirmDialog.setSelectedMembers(selectedMembers.toArray(new IMember[selectedMembers.size()]));
        if (this.m_confirmDialog.open() == 0) {
            JavaElementDeleteOperation op = new JavaElementDeleteOperation(){

                protected void deleteMember(IJavaElement member, Set<ICompilationUnit> icuForOrganizeImports, IProgressMonitor monitor, IWorkingCopyManager manager) throws CoreException {
                    if (FormDeleteAction.this.m_processServiceInterface != null && member.equals(FormDeleteAction.this.m_processServiceInterface)) {
                        ScoutUtility.unregisterServiceProxy((IType)FormDeleteAction.this.m_processServiceInterface, (IProgressMonitor)monitor);
                    }
                    if (FormDeleteAction.this.m_processServiceImplementation != null && member.equals(FormDeleteAction.this.m_processServiceImplementation)) {
                        ScoutUtility.unregisterServiceImplementation((IType)FormDeleteAction.this.m_processServiceImplementation, (IProgressMonitor)monitor);
                    }
                    super.deleteMember(member, icuForOrganizeImports, monitor, manager);
                }
            };
            op.setMembers((IJavaElement[])this.m_confirmDialog.getSelectedMembers());
            OperationJob job = new OperationJob(new IOperation[]{op});
            job.schedule();
        }
        return null;
    }

    protected void collectAffectedMembers(List<IMember> members, List<IMember> selectedMembers) {
        int n;
        members.add((IMember)this.m_formType);
        selectedMembers.add((IMember)this.m_formType);
        if (this.m_formData == null) {
            try {
                this.m_formData = ScoutTypeUtility.findFormDataForForm((IType)this.getFormType());
            }
            catch (JavaModelException e) {
                ScoutSdkUi.logError(e);
            }
        }
        if (TypeUtility.exists((IJavaElement)this.m_formData)) {
            members.add((IMember)this.m_formData);
            selectedMembers.add((IMember)this.m_formData);
        }
        String formName = this.getFormType().getElementName().replaceAll("^(.*)Form$", "$1");
        IType iService = TypeUtility.getType((String)"org.eclipse.scout.service.IService");
        IPrimaryTypeTypeHierarchy serviceHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iService);
        if (this.m_processServiceInterface == null) {
            ITypeFilter serviceFilter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getTypesOnClasspath((IJavaProject)this.getFormType().getJavaProject()), TypeFilters.getInterfaceFilter()});
            IType[] iTypeArray = serviceHierarchy.getAllSubtypes(iService, serviceFilter, null);
            int n2 = iTypeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                IType candidate = iTypeArray[n3];
                if (candidate.getElementName().matches("I" + formName + "(Process)?" + "Service")) {
                    this.m_processServiceInterface = candidate;
                    break;
                }
                ++n3;
            }
        }
        if (this.m_processServiceInterface != null && this.m_processServiceImplementation == null) {
            IScoutBundle sharedBundle = ScoutTypeUtility.getScoutBundle((IJavaElement)this.m_processServiceInterface);
            IScoutBundle[] visibleServers = sharedBundle.getChildBundles(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"SERVER"}), false);
            ITypeFilter serviceFilter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{ScoutTypeFilters.getInScoutBundles((IScoutBundle[])visibleServers), TypeFilters.getClassFilter()});
            IType[] iTypeArray = serviceHierarchy.getAllSubtypes(iService, serviceFilter, null);
            n = iTypeArray.length;
            int n4 = 0;
            while (n4 < n) {
                IType candidate = iTypeArray[n4];
                if (candidate.getElementName().matches(String.valueOf(formName) + "(Process)?" + "Service")) {
                    this.m_processServiceImplementation = candidate;
                    break;
                }
                ++n4;
            }
        }
        if (this.m_processServiceInterface != null) {
            members.add((IMember)this.m_processServiceInterface);
        }
        if (this.m_processServiceImplementation != null) {
            members.add((IMember)this.m_processServiceImplementation);
        }
        String permissionRegex = this.getFormType().getElementName().replaceAll("^(.*)Form$", "(Create|Read|Update)$1Permission");
        IType permission = TypeUtility.getType((String)Permission.class.getName());
        IPrimaryTypeTypeHierarchy permissionHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)permission);
        ITypeFilter permissionFilter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getTypesOnClasspath((IJavaProject)this.getFormType().getJavaProject()), TypeFilters.getClassFilter()});
        IType[] iTypeArray = permissionHierarchy.getAllSubtypes(permission, permissionFilter, null);
        int n5 = iTypeArray.length;
        n = 0;
        while (n < n5) {
            IType candidate = iTypeArray[n];
            if (candidate.getElementName().matches(permissionRegex)) {
                members.add((IMember)candidate);
            }
            ++n;
        }
    }

    public IType getFormType() {
        return this.m_formType;
    }

    public void setFormType(IType formType) {
        this.m_formType = formType;
    }

    private class P_SelectionValidationListener
    implements IMemberSelectionChangedListener {
        private P_SelectionValidationListener() {
        }

        @Override
        public void handleSelectionChanged(IMember[] selection) {
            FormDeleteAction.this.m_confirmDialog.setMessage("");
            HashSet<IMember> members = new HashSet<IMember>(Arrays.asList(selection));
            boolean canOk = true;
            if (selection == null || selection.length == 0) {
                canOk = false;
            }
            if (FormDeleteAction.this.m_processServiceImplementation != null && FormDeleteAction.this.m_processServiceInterface != null && members.contains(FormDeleteAction.this.m_processServiceInterface) != members.contains(FormDeleteAction.this.m_processServiceImplementation)) {
                FormDeleteAction.this.m_confirmDialog.setMessage(Texts.get((String)"ProcessServiceSelection"), 3);
                canOk = false;
            }
            if (FormDeleteAction.this.m_formType != null && FormDeleteAction.this.m_formData != null && members.contains(FormDeleteAction.this.m_formType) != members.contains(FormDeleteAction.this.m_formData)) {
                FormDeleteAction.this.m_confirmDialog.setMessage(Texts.get((String)"FormDataDeleteWithForm", (String[])new String[]{FormDeleteAction.this.m_formData.getElementName()}), 2);
            }
            FormDeleteAction.this.m_confirmDialog.getOkButton().setEnabled(canOk);
        }
    }
}

