/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.delete;

import java.util.LinkedList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.form.field.FormFieldDeleteOperation;
import org.eclipse.scout.sdk.ui.action.AbstractScoutHandler;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class FormFieldDeleteAction
extends AbstractScoutHandler {
    private LinkedList<IType> m_formFieldTypes = new LinkedList();

    public FormFieldDeleteAction() {
        super(Texts.get((String)"DeleteWithPopup"), ScoutSdkUi.getImageDescriptor("formField_remove.png"), "Delete", true, IScoutHandler.Category.DELETE);
    }

    @Override
    public boolean isVisible() {
        for (IType field : this.m_formFieldTypes) {
            if (this.isEditable((IJavaElement)field)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object execute(Shell shell, IPage[] selection, ExecutionEvent event) throws ExecutionException {
        MessageBox box = new MessageBox(shell, 292);
        if (this.m_formFieldTypes.size() == 1) {
            box.setMessage(Texts.get((String)"FieldDeleteConfirmation"));
        } else {
            box.setMessage(Texts.get((String)"FieldDeleteConfirmationPlural"));
        }
        if (box.open() == 32) {
            for (IType t : this.m_formFieldTypes) {
                FormFieldDeleteOperation op = new FormFieldDeleteOperation(t, true);
                OperationJob job = new OperationJob(new IOperation[]{op});
                job.schedule();
            }
        }
        return null;
    }

    public void addFormFieldType(IType formFieldType) {
        this.m_formFieldTypes.add(formFieldType);
    }
}

