/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.delete;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.JavaElementDeleteOperation;
import org.eclipse.scout.sdk.ui.action.AbstractScoutHandler;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.dialog.IMemberSelectionChangedListener;
import org.eclipse.scout.sdk.ui.dialog.MemberSelectionDialog;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.widgets.Shell;

public class LookupCallDeleteAction
extends AbstractScoutHandler {
    private IType m_lookupCall;
    private IType m_lookupService;
    private IType m_lookupServiceInterface;
    private MemberSelectionDialog m_confirmDialog;

    public LookupCallDeleteAction() {
        super(String.valueOf(Texts.get((String)"DeleteLookupCall")) + "...", ScoutSdkUi.getImageDescriptor("lookupCall_remove.png"), "Delete", false, IScoutHandler.Category.DELETE);
    }

    @Override
    public boolean isVisible() {
        return this.isEditable((IJavaElement)this.m_lookupCall);
    }

    @Override
    public Object execute(Shell shell, IPage[] selection, ExecutionEvent event) throws ExecutionException {
        this.m_confirmDialog = new MemberSelectionDialog(shell, Texts.get((String)"DeleteLookupCall"));
        this.m_confirmDialog.addMemberSelectionListener(new P_SelectionValidationListener());
        ArrayList<IMember> members = new ArrayList<IMember>();
        ArrayList<IMember> selectedMembers = new ArrayList<IMember>();
        this.collectAffectedMembers(members, selectedMembers);
        this.m_confirmDialog.setMembers(members.toArray(new IMember[members.size()]));
        this.m_confirmDialog.setSelectedMembers(selectedMembers.toArray(new IMember[selectedMembers.size()]));
        if (this.m_confirmDialog.open() == 0) {
            JavaElementDeleteOperation op = new JavaElementDeleteOperation(){

                protected void deleteMember(IJavaElement member, Set<ICompilationUnit> icuForOrganizeImports, IProgressMonitor monitor, IWorkingCopyManager manager) throws CoreException {
                    if (LookupCallDeleteAction.this.m_lookupServiceInterface != null && member.equals(LookupCallDeleteAction.this.m_lookupServiceInterface)) {
                        ScoutUtility.unregisterServiceProxy((IType)LookupCallDeleteAction.this.m_lookupServiceInterface, (IProgressMonitor)monitor);
                    }
                    if (LookupCallDeleteAction.this.m_lookupService != null && member.equals(LookupCallDeleteAction.this.m_lookupService)) {
                        ScoutUtility.unregisterServiceImplementation((IType)LookupCallDeleteAction.this.m_lookupService, (IProgressMonitor)monitor);
                    }
                    super.deleteMember(member, icuForOrganizeImports, monitor, manager);
                }
            };
            op.setMembers((IJavaElement[])this.m_confirmDialog.getSelectedMembers());
            OperationJob job = new OperationJob(new IOperation[]{op});
            job.schedule();
        }
        return null;
    }

    protected void collectAffectedMembers(List<IMember> members, List<IMember> selectedMembers) {
        String serviceName;
        members.add((IMember)this.getLookupCall());
        selectedMembers.add((IMember)this.getLookupCall());
        IType iService = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.lookup.ILookupService");
        IPrimaryTypeTypeHierarchy serviceHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iService);
        if (this.m_lookupServiceInterface == null) {
            serviceName = this.getLookupCall().getElementName().replaceAll("^(.*)LookupCall$", "I$1LookupService");
            ITypeFilter serviceFilter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getTypesOnClasspath((IJavaProject)this.getLookupCall().getJavaProject()), TypeFilters.getInterfaceFilter()});
            IType[] iTypeArray = serviceHierarchy.getAllSubtypes(iService, serviceFilter, null);
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType candidate = iTypeArray[n2];
                if (candidate.getElementName().equals(serviceName)) {
                    this.m_lookupServiceInterface = candidate;
                    break;
                }
                ++n2;
            }
        }
        if (this.m_lookupServiceInterface != null && this.m_lookupService == null) {
            serviceName = this.getLookupCall().getElementName().replaceAll("^(.*)LookupCall$", "$1LookupService");
            IScoutBundle sharedBundle = ScoutTypeUtility.getScoutBundle((IJavaElement)this.getLookupCall());
            IScoutBundle[] visibleServers = sharedBundle.getChildBundles(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"SERVER"}), false);
            ITypeFilter serviceFilter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{ScoutTypeFilters.getInScoutBundles((IScoutBundle[])visibleServers), TypeFilters.getClassFilter()});
            IType[] iTypeArray = serviceHierarchy.getAllSubtypes(iService, serviceFilter, null);
            int n = iTypeArray.length;
            int n3 = 0;
            while (n3 < n) {
                IType candidate = iTypeArray[n3];
                if (candidate.getElementName().equals(serviceName)) {
                    this.m_lookupService = candidate;
                    break;
                }
                ++n3;
            }
        }
        if (this.m_lookupServiceInterface != null) {
            members.add((IMember)this.m_lookupServiceInterface);
        }
        if (this.m_lookupService != null) {
            members.add((IMember)this.m_lookupService);
        }
    }

    public IType getLookupCall() {
        return this.m_lookupCall;
    }

    public void setLookupCall(IType lookupCall) {
        this.m_lookupCall = lookupCall;
    }

    private class P_SelectionValidationListener
    implements IMemberSelectionChangedListener {
        private P_SelectionValidationListener() {
        }

        @Override
        public void handleSelectionChanged(IMember[] selection) {
            LookupCallDeleteAction.this.m_confirmDialog.setMessage("");
            HashSet<IMember> members = new HashSet<IMember>(Arrays.asList(selection));
            boolean canOk = true;
            if (selection == null || selection.length == 0) {
                canOk = false;
            }
            if (LookupCallDeleteAction.this.m_lookupService != null && LookupCallDeleteAction.this.m_lookupServiceInterface != null && members.contains(LookupCallDeleteAction.this.m_lookupServiceInterface) != members.contains(LookupCallDeleteAction.this.m_lookupService)) {
                LookupCallDeleteAction.this.m_confirmDialog.setMessage(Texts.get((String)"ProcessServiceSelection"), 3);
                canOk = false;
            }
            LookupCallDeleteAction.this.m_confirmDialog.getOkButton().setEnabled(canOk);
        }
    }
}

