/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.rename;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.action.AbstractScoutHandler;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.dialog.RenameDialog;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.jdt.JdtRenameTransaction;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.Regex;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractRenameAction
extends AbstractScoutHandler {
    private RenameDialog m_dialog;
    private String m_oldName;
    private String m_readOnlySuffix;

    public AbstractRenameAction() {
        super(Texts.get((String)"RenameWithPopup"), ScoutSdkUi.getImageDescriptor("rename.gif"), "ALT+SHIFT+R", false, IScoutHandler.Category.RENAME);
    }

    @Override
    public Object execute(Shell shell, IPage[] selection, ExecutionEvent event) throws ExecutionException {
        this.m_dialog = new RenameDialog(shell, Texts.get((String)"RenameWithPopup"), this.getOldName(), this.getReadOnlySuffix());
        this.m_dialog.addPropertyChangeListener(new P_PropertyListener());
        this.getDialog().create();
        this.validateInternal(this.getDialog().getNewName());
        if (this.getDialog().open() == 0) {
            try {
                JdtRenameTransaction tx = new JdtRenameTransaction();
                this.fillTransaction(tx, this.getDialog().getNewName());
                tx.commit(ScoutSdkUi.getShell());
            }
            catch (CoreException e) {
                ScoutSdkUi.logError("rename failed.", e);
            }
        }
        return null;
    }

    protected abstract void fillTransaction(JdtRenameTransaction var1, String var2) throws CoreException;

    protected abstract IStatus validate(String var1);

    public RenameDialog getDialog() {
        return this.m_dialog;
    }

    private void validateInternal(String newName) {
        IStatus status = this.validate(newName);
        this.getDialog().getOkButton().setEnabled(true);
        switch (status.getSeverity()) {
            case 4: {
                this.getDialog().setMessage(status.getMessage(), 3);
                this.getDialog().getOkButton().setEnabled(false);
                break;
            }
            case 2: {
                this.getDialog().setMessage(status.getMessage(), 2);
                break;
            }
            case 1: {
                this.getDialog().setMessage(status.getMessage(), 1);
                break;
            }
            default: {
                this.getDialog().setMessage("", 0);
            }
        }
    }

    protected IStatus getJavaNameStatus(String newName) {
        if (newName.equals(this.getReadOnlySuffix())) {
            return new Status(4, "org.eclipse.scout.sdk.ui", "Name can not be null or empty");
        }
        if (Regex.REGEX_WELLFORMD_JAVAFIELD.matcher(newName).matches()) {
            return Status.OK_STATUS;
        }
        if (Regex.REGEX_JAVAFIELD.matcher(newName).matches()) {
            return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return Status.OK_STATUS;
    }

    public String getOldName() {
        return this.m_oldName;
    }

    public void setOldName(String oldName) {
        this.m_oldName = oldName;
    }

    public String getReadOnlySuffix() {
        return this.m_readOnlySuffix;
    }

    public void setReadOnlySuffix(String readOnlySuffix) {
        this.m_readOnlySuffix = readOnlySuffix;
    }

    private class P_PropertyListener
    implements PropertyChangeListener {
        private P_PropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("newName")) {
                AbstractRenameAction.this.validateInternal((String)evt.getNewValue());
            }
        }
    }
}

