/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.rename;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.action.rename.AbstractRenameAction;
import org.eclipse.scout.sdk.ui.internal.jdt.JdtRenameTransaction;
import org.eclipse.scout.sdk.util.pde.PluginModelHelper;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutBundleFilter;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public class ServiceRenameAction
extends AbstractRenameAction {
    private IType m_serviceInterface;
    private IType m_serviceImplementation;

    @Override
    protected IStatus validate(String newName) {
        String packName;
        IStatus inheritedStatus = this.getJavaNameStatus(newName);
        if (inheritedStatus.matches(4)) {
            return inheritedStatus;
        }
        if (this.m_serviceImplementation != null && TypeUtility.existsType((String)(String.valueOf(packName = this.m_serviceImplementation.getPackageFragment().getElementName()) + "." + newName))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", "Name already in use.");
        }
        if (this.m_serviceInterface != null && TypeUtility.existsType((String)(String.valueOf(packName = this.m_serviceInterface.getPackageFragment().getElementName()) + ".I" + newName))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", "Name already in use.");
        }
        return inheritedStatus;
    }

    @Override
    public boolean isVisible() {
        return this.isEditable((IJavaElement)this.m_serviceImplementation);
    }

    @Override
    protected void fillTransaction(JdtRenameTransaction transaction, String newName) throws CoreException {
        transaction.add(this.m_serviceImplementation, newName);
        if (this.isEditable((IJavaElement)this.m_serviceInterface)) {
            String newInterfaceName = "I" + newName;
            final IScoutBundle interfaceBundle = ScoutTypeUtility.getScoutBundle((IJavaElement)this.m_serviceInterface);
            final String oldFqn = this.m_serviceInterface.getFullyQualifiedName();
            final String newFqn = oldFqn.replace(this.m_serviceInterface.getElementName(), newInterfaceName);
            transaction.add(this.m_serviceInterface, newInterfaceName);
            OperationJob j = new OperationJob(new IOperation[]{new IOperation(){

                public void validate() throws IllegalArgumentException {
                }

                public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
                    IScoutBundle[] iScoutBundleArray = interfaceBundle.getChildBundles(ScoutBundleFilters.getMultiFilterAnd((IScoutBundleFilter[])new IScoutBundleFilter[]{ScoutBundleFilters.getWorkspaceBundlesFilter(), ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"CLIENT"})}), true);
                    int n = iScoutBundleArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPluginElement[] simpleExtensions;
                        IScoutBundle clientBundle = iScoutBundleArray[n2];
                        String attribName = "class";
                        PluginModelHelper h = new PluginModelHelper(clientBundle.getProject());
                        HashMap<String, String> attributes = new HashMap<String, String>(1);
                        attributes.put(attribName, oldFqn);
                        IPluginElement[] iPluginElementArray = simpleExtensions = h.PluginXml.getSimpleExtensions("org.eclipse.scout.service.services", "proxy", attributes);
                        int n3 = simpleExtensions.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IPluginElement proxy = iPluginElementArray[n4];
                            proxy.setAttribute(attribName, newFqn);
                            ++n4;
                        }
                        h.save();
                        ++n2;
                    }
                }

                public String getOperationName() {
                    return "Rename client proxies";
                }
            }});
            j.schedule();
        }
    }

    public void setServiceInterface(IType serviceInterface) {
        this.m_serviceInterface = serviceInterface;
    }

    public void setServiceImplementation(IType serviceImplementation) {
        this.m_serviceImplementation = serviceImplementation;
    }
}

