/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.fields.TextField;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class StyledTextField
extends TextField {
    private P_SuffixListener m_suffixListener = null;
    private String m_readOnlyPrefix;
    private String m_readOnlySuffix;
    private OptimisticLock m_revalLock = new OptimisticLock();

    public StyledTextField(Composite parent) {
        super(parent);
    }

    public StyledTextField(Composite parent, String labelName) {
        super(parent, labelName);
    }

    public StyledTextField(Composite parent, String labelName, int labelPercentage) {
        super(parent, labelName, labelPercentage);
    }

    public String getReadOnlySuffix() {
        return this.m_readOnlySuffix;
    }

    public String getModifiableText() {
        String text = this.getText();
        if (this.m_suffixListener != null && text.length() >= this.m_suffixListener.getSuffix().length()) {
            text = text.substring(0, text.length() - this.m_suffixListener.getSuffix().length());
        }
        return text;
    }

    public void setReadOnlySuffix(String suffix) {
        this.m_readOnlySuffix = suffix;
        this.updateListeners();
    }

    public void setReadOnlyPrefix(String readOnlyPrefix) {
        this.m_readOnlyPrefix = readOnlyPrefix;
        this.updateListeners();
    }

    public String getReadOnlyPrefix() {
        return this.m_readOnlyPrefix;
    }

    private synchronized void updateListeners() {
        StyledText textComp = this.getTextComponent();
        if (StringUtility.isNullOrEmpty((String)this.getReadOnlyPrefix()) && StringUtility.isNullOrEmpty((String)this.getReadOnlySuffix())) {
            if (this.m_suffixListener != null) {
                this.m_suffixListener.setSuffix("");
                textComp.removeListener(13, (Listener)this.m_suffixListener);
                textComp.removeListener(3, (Listener)this.m_suffixListener);
                textComp.removeListener(24, (Listener)this.m_suffixListener);
                textComp.removeVerifyKeyListener((VerifyKeyListener)this.m_suffixListener);
                textComp.removeListener(1, (Listener)this.m_suffixListener);
                textComp.removeListener(15, (Listener)this.m_suffixListener);
                this.m_suffixListener = null;
            }
        } else {
            if (this.m_suffixListener == null) {
                this.m_suffixListener = new P_SuffixListener();
            }
            this.m_suffixListener.setPrefix(this.getReadOnlyPrefix());
            this.m_suffixListener.setSuffix(this.getReadOnlySuffix());
            textComp.addListener(13, (Listener)this.m_suffixListener);
            textComp.addListener(3, (Listener)this.m_suffixListener);
            textComp.addListener(24, (Listener)this.m_suffixListener);
            textComp.addVerifyKeyListener((VerifyKeyListener)this.m_suffixListener);
            textComp.addListener(1, (Listener)this.m_suffixListener);
            textComp.addListener(15, (Listener)this.m_suffixListener);
        }
    }

    private static String replace(String regex, String ... replacements) {
        StringBuilder sb = new StringBuilder(regex);
        int i = 0;
        while (i < replacements.length) {
            int index = 0;
            String placeholder = "#" + i + "#";
            while ((index = sb.indexOf(placeholder, index)) >= 0) {
                sb.replace(index, index + placeholder.length(), replacements[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        String prefix = "";
        if (this.m_suffixListener != null) {
            prefix = this.m_suffixListener.getPrefix();
        }
        if (!text.startsWith(prefix)) {
            text = String.valueOf(prefix) + text;
        }
        String suffix = "";
        if (this.m_suffixListener != null) {
            suffix = this.m_suffixListener.getSuffix();
        }
        if (!text.endsWith(suffix)) {
            text = String.valueOf(text) + suffix;
        }
        super.setText(text);
    }

    private class P_SuffixListener
    implements Listener,
    VerifyKeyListener {
        private Pattern m_preSuffixPattern;
        private StyleRange m_suffixStyleRange;
        private StyleRange m_prefixStyleRange;
        private static final String prePostFixRegex = "^(#0#).*(#1#)$";
        private String m_suffixString = "";
        private String m_prefixString = "";

        public P_SuffixListener() {
            this("");
        }

        public P_SuffixListener(String suffix) {
            this(suffix, null);
        }

        public P_SuffixListener(String postfix, StyleRange style) {
            if (style == null) {
                style = new StyleRange(-1, -1, StyledTextField.this.getDisplay().getSystemColor(9), null);
            }
            this.m_suffixStyleRange = new StyleRange(-1, -1, style.foreground, style.background, style.fontStyle);
            this.m_prefixStyleRange = new StyleRange(-1, -1, style.foreground, style.background, style.fontStyle);
            this.m_preSuffixPattern = Pattern.compile(StyledTextField.replace(prePostFixRegex, new String[]{this.m_prefixString, this.m_suffixString}));
            this.setSuffix(postfix);
        }

        public void verifyKey(VerifyEvent event) {
            Event e = new Event();
            e.keyCode = event.keyCode;
            e.character = event.character;
            e.doit = event.doit;
            e.widget = event.widget;
            e.type = 25;
            this.handleEvent(e);
            event.doit = e.doit;
        }

        public void handleEvent(Event event) {
            block18: {
                try {
                    if (!StyledTextField.this.m_revalLock.acquire()) break block18;
                    Point textSelection = StyledTextField.this.getTextComponent().getSelection();
                    Matcher suffixMatcher = this.m_preSuffixPattern.matcher(StyledTextField.this.getTextComponent().getText());
                    if (!suffixMatcher.find()) break block18;
                    switch (event.type) {
                        case 25: {
                            if (event.character == '\b') {
                                boolean bl = event.doit = textSelection.x - 1 >= suffixMatcher.end(1) || textSelection.x != textSelection.y;
                            }
                            if (event.character == '\u007f') {
                                event.doit = textSelection.x + 1 <= suffixMatcher.start(2) || textSelection.x != textSelection.y;
                            }
                            break;
                        }
                        case 24: {
                            this.updateStyleRanges();
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 13: {
                            Point selection = StyledTextField.this.getTextComponent().getSelection();
                            if (selection.x < suffixMatcher.end(1)) {
                                selection.x = suffixMatcher.end(1);
                                if (selection.x > selection.y) {
                                    selection.y = selection.x;
                                }
                                event.doit = false;
                            }
                            if (selection.y > suffixMatcher.start(2)) {
                                selection.y = suffixMatcher.start(2);
                                if (selection.y < selection.x) {
                                    selection.x = selection.y;
                                }
                                event.doit = false;
                            }
                            if (!event.doit) {
                                StyledTextField.this.getTextComponent().setSelection(selection);
                            }
                            break;
                        }
                        case 15: {
                            int x = StyledTextField.this.getTextComponent().getSelection().x;
                            if (x >= suffixMatcher.end(1) && x <= suffixMatcher.start(2)) break;
                            StyledTextField.this.getTextComponent().setSelection(suffixMatcher.end(1));
                        }
                        default: {
                            break;
                        }
                    }
                }
                finally {
                    StyledTextField.this.m_revalLock.release();
                }
            }
        }

        String getPrefix() {
            return this.m_prefixString;
        }

        String getSuffix() {
            return this.m_suffixString;
        }

        void setSuffix(String postfix) {
            try {
                if (StyledTextField.this.m_revalLock.acquire()) {
                    Matcher suffixMatcher;
                    if (postfix == null) {
                        postfix = "";
                    }
                    StyledText text = StyledTextField.this.getTextComponent();
                    if (this.m_suffixString != null && (suffixMatcher = this.m_preSuffixPattern.matcher(text.getText())).find()) {
                        String newText = text.getText().substring(0, suffixMatcher.start(2));
                        text.setText(newText);
                    }
                    this.m_suffixString = postfix;
                    this.m_preSuffixPattern = Pattern.compile(StyledTextField.replace(prePostFixRegex, new String[]{this.m_prefixString, this.m_suffixString}));
                    if (!text.getText().endsWith(this.m_suffixString)) {
                        text.setText(String.valueOf(text.getText()) + this.m_suffixString);
                    }
                    this.updateStyleRanges();
                }
            }
            finally {
                StyledTextField.this.m_revalLock.release();
            }
        }

        void setPrefix(String prefix) {
            try {
                if (StyledTextField.this.m_revalLock.acquire()) {
                    Matcher suffixMatcher;
                    if (prefix == null) {
                        prefix = "";
                    }
                    StyledText text = StyledTextField.this.getTextComponent();
                    if (this.m_prefixString != null && (suffixMatcher = this.m_preSuffixPattern.matcher(text.getText())).find()) {
                        String newText = text.getText().substring(suffixMatcher.end(1));
                        text.setText(newText);
                    }
                    this.m_prefixString = prefix;
                    this.m_preSuffixPattern = Pattern.compile(StyledTextField.replace(prePostFixRegex, new String[]{this.m_prefixString, this.m_suffixString}));
                    if (!text.getText().startsWith(this.m_prefixString)) {
                        text.setText(String.valueOf(this.m_prefixString) + text.getText());
                    }
                    this.updateStyleRanges();
                }
            }
            finally {
                StyledTextField.this.m_revalLock.release();
            }
        }

        private void updateStyleRanges() {
            Matcher preSuffixMatcher = this.m_preSuffixPattern.matcher(StyledTextField.this.getTextComponent().getText());
            if (preSuffixMatcher.find()) {
                this.m_suffixStyleRange.start = preSuffixMatcher.start(2);
                this.m_suffixStyleRange.length = preSuffixMatcher.end(2) - preSuffixMatcher.start(2);
                this.m_prefixStyleRange.start = preSuffixMatcher.start(1);
                this.m_prefixStyleRange.length = preSuffixMatcher.end(1) - preSuffixMatcher.start(1);
                StyledTextField.this.getTextComponent().setStyleRanges(new StyleRange[]{this.m_prefixStyleRange, this.m_suffixStyleRange});
            } else {
                StyledTextField.this.getTextComponent().setStyleRanges(null);
            }
        }
    }
}

