/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.bundletree;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.swt.graphics.Color;

public class TreeNode
implements ITreeNode {
    private final String m_type;
    private Object m_data;
    private String m_text;
    private boolean m_visible = true;
    private boolean m_checkable = false;
    private boolean m_enabled = true;
    private boolean m_bold = false;
    private ImageDescriptor m_image;
    private int m_orderNr = 0;
    private Color m_foreground;
    private Color m_background;
    private ITreeNode m_parent;
    private List<ITreeNode> m_children = new ArrayList<ITreeNode>();

    public TreeNode(String type) {
        this(type, null);
    }

    public TreeNode(String type, String text) {
        this(type, text, null);
    }

    public TreeNode(String type, String text, Object data) {
        this.m_type = type;
        this.m_data = data;
        this.m_text = text;
    }

    public TreeNode(ITreeNode node) {
        this.m_data = node.getData();
        this.m_bold = node.isBold();
        this.m_checkable = node.isCheckable();
        this.m_image = node.getImage();
        this.m_text = node.getText();
        this.m_type = node.getType();
        this.m_visible = node.isVisible();
    }

    @Override
    public String getType() {
        return this.m_type;
    }

    @Override
    public void setText(String text) {
        this.m_text = text;
    }

    @Override
    public String getText() {
        return this.m_text;
    }

    public void setData(Object data) {
        this.m_data = data;
    }

    @Override
    public Object getData() {
        return this.m_data;
    }

    @Override
    public void setParent(ITreeNode parent) {
        this.m_parent = parent;
    }

    @Override
    public ITreeNode getParent() {
        return this.m_parent;
    }

    @Override
    public void addChild(ITreeNode childNode) {
        this.m_children.add(childNode);
    }

    @Override
    public boolean removeChild(ITreeNode childNode) {
        return this.m_children.remove(childNode);
    }

    @Override
    public List<ITreeNode> getChildren() {
        return this.m_children;
    }

    @Override
    public ITreeNode[] getChildren(ITreeNodeFilter filter) {
        ArrayList<ITreeNode> children = new ArrayList<ITreeNode>();
        for (ITreeNode child : this.getChildren()) {
            if (!filter.accept(child)) continue;
            children.add(child);
        }
        return children.toArray(new ITreeNode[children.size()]);
    }

    @Override
    public void setVisible(boolean visible) {
        this.m_visible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.m_visible;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.m_enabled;
    }

    @Override
    public void setBold(boolean bold) {
        this.m_bold = bold;
    }

    @Override
    public boolean isBold() {
        return this.m_bold;
    }

    public void setImage(ImageDescriptor image) {
        this.m_image = image;
    }

    @Override
    public ImageDescriptor getImage() {
        return this.m_image;
    }

    @Override
    public void setCheckable(boolean checkable) {
        this.m_checkable = checkable;
    }

    @Override
    public boolean isCheckable() {
        return this.m_checkable;
    }

    @Override
    public void setOrderNr(int orderNr) {
        this.m_orderNr = orderNr;
    }

    @Override
    public int getOrderNr() {
        return this.m_orderNr;
    }

    @Override
    public Color getForeground() {
        return this.m_foreground;
    }

    @Override
    public void setForeground(Color foreground) {
        this.m_foreground = foreground;
    }

    @Override
    public Color getBackground() {
        return this.m_background;
    }

    @Override
    public void setBackground(Color background) {
        this.m_background = background;
    }
}

