/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.bundletree;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.ui.extensions.bundle.ScoutBundleUiExtension;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeNode;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.bundle.ScoutBundleExtensionPoint;
import org.eclipse.scout.sdk.util.ScoutResourceFilters;
import org.eclipse.scout.sdk.util.resources.IResourceFilter;
import org.eclipse.scout.sdk.util.resources.ResourceUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class TreeUtility {
    public static final String TYPE_PRODUCT_NODE = "zz_product_node";

    private TreeUtility() {
    }

    public static ITreeNode[] findNodes(ITreeNode startNode, ITreeNodeFilter filter) {
        ArrayList<ITreeNode> collector = new ArrayList<ITreeNode>(3);
        TreeUtility.collectNodes(startNode, filter, collector);
        return collector.toArray(new ITreeNode[collector.size()]);
    }

    public static <T> boolean isOneOf(T toSearch, T ... listToSearchIn) {
        if (listToSearchIn != null && listToSearchIn.length > 0) {
            T[] TArray = listToSearchIn;
            int n = listToSearchIn.length;
            int n2 = 0;
            while (n2 < n) {
                T t = TArray[n2];
                if (CompareUtility.equals(t, toSearch)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static ITreeNode findNode(ITreeNode startNode, ITreeNodeFilter filter) {
        ArrayList<ITreeNode> collector = new ArrayList<ITreeNode>(3);
        TreeUtility.collectNodes(startNode, filter, collector);
        if (collector.size() > 0) {
            return collector.get(0);
        }
        return null;
    }

    private static void collectNodes(ITreeNode node, ITreeNodeFilter filter, List<ITreeNode> collector) {
        if (node != null) {
            if (filter.accept(node)) {
                collector.add(node);
            }
            for (ITreeNode childNode : node.getChildren()) {
                TreeUtility.collectNodes(childNode, filter, collector);
            }
        }
    }

    public static ITreeNode createBundleTree(IScoutBundle scoutProject) {
        return TreeUtility.createBundleTree(scoutProject, NodeFilters.getAcceptAll());
    }

    public static ITreeNode createBundleTree(IScoutBundle scoutProject, ITreeNodeFilter filter) {
        TreeNode rootNode = new TreeNode("root", "root");
        rootNode.setVisible(false);
        HashSet<IScoutBundle> rootBundles = new HashSet<IScoutBundle>();
        IScoutBundle[] iScoutBundleArray = scoutProject.getParentBundles(ScoutBundleFilters.getRootBundlesFilter(), true);
        int n = iScoutBundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutBundle root = iScoutBundleArray[n2];
            rootBundles.add(root);
            ++n2;
        }
        TreeUtility.recAddChildNodes(rootNode, rootBundles, filter);
        return rootNode;
    }

    private static void recAddChildNodes(ITreeNode node, Set<? extends IScoutBundle> bundles, ITreeNodeFilter filter) {
        for (IScoutBundle iScoutBundle : bundles) {
            ITreeNode childNode = TreeUtility.createBundleTreeNode(node, iScoutBundle, filter);
            if (childNode == null) continue;
            TreeUtility.recAddChildNodes(childNode, iScoutBundle.getDirectChildBundles(), filter);
        }
    }

    public static ITreeNode createBundleTreeNode(ITreeNode parent, IScoutBundle b) {
        return TreeUtility.createBundleTreeNode(parent, b, null);
    }

    private static ITreeNode createBundleTreeNode(ITreeNode parent, IScoutBundle b, ITreeNodeFilter filter) {
        ScoutBundleUiExtension uiExt = ScoutBundleExtensionPoint.getExtension(b.getType());
        TreeNode childNode = null;
        if (uiExt != null) {
            childNode = new TreeNode(b.getType(), b.getSymbolicName(), b);
            childNode.setOrderNr(Integer.MAX_VALUE - Math.abs(uiExt.getOrderNumber()));
            if (filter != null && !filter.accept(childNode)) {
                return null;
            }
            childNode.setBold(false);
            ImageDescriptor icon = uiExt.getIcon();
            if (b.isBinary()) {
                icon = ScoutSdkUi.getImageDescriptor(icon, "binary_decoration.png", 2);
                childNode.setForeground(ScoutSdkUi.getDisplay().getSystemColor(17));
            }
            childNode.setImage(icon);
            parent.addChild(childNode);
            childNode.setParent(parent);
        }
        return childNode;
    }

    public static ITreeNode createNode(ITreeNode parentNode, String type, String name, ImageDescriptor img) {
        return TreeUtility.createNode(parentNode, type, name, img, 0);
    }

    public static ITreeNode createNode(ITreeNode parentNode, String type, String name, ImageDescriptor img, int orderNr) {
        return TreeUtility.createNode(parentNode, type, name, img, orderNr, null);
    }

    public static ITreeNode createNode(ITreeNode parentNode, String type, String name, ImageDescriptor img, int orderNr, Object data) {
        return TreeUtility.createNode(parentNode, type, name, img, orderNr, data, true);
    }

    public static ITreeNode createNode(ITreeNode parentNode, String type, String name, ImageDescriptor img, int orderNr, Object data, boolean bold) {
        TreeNode node = new TreeNode(type, name);
        node.setData(data);
        node.setOrderNr(orderNr);
        node.setImage(img);
        node.setBold(bold);
        node.setCheckable(true);
        node.setParent(parentNode);
        parentNode.addChild(node);
        return node;
    }

    public static ITreeNode createProductTree(IScoutBundle project, ITreeNodeFilter visibleFilter, boolean checkMode) throws CoreException {
        if (project == null) {
            return null;
        }
        if (visibleFilter == null) {
            visibleFilter = NodeFilters.getAcceptAll();
        }
        IResource[] productFiles = ResourceUtility.getAllResources((IResourceFilter)ScoutResourceFilters.getProductFiles((IScoutBundle)project));
        TreeNode rootNode = new TreeNode("root", "root");
        rootNode.setVisible(false);
        IResource[] iResourceArray = productFiles;
        int n = productFiles.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            IFile file = (IFile)res;
            IScoutBundle bundle = ScoutTypeUtility.getScoutBundle((IProject)file.getProject());
            TreeNode bundleNode = (TreeNode)TreeUtility.findNode(rootNode, NodeFilters.getByData(bundle));
            if (bundleNode == null) {
                bundleNode = new TreeNode(bundle.getType(), bundle.getSymbolicName(), bundle);
                ScoutBundleUiExtension uiExt = ScoutBundleExtensionPoint.getExtension(bundle.getType());
                if (uiExt != null) {
                    bundleNode.setImage(uiExt.getIcon());
                    bundleNode.setOrderNr(uiExt.getOrderNumber());
                }
                bundleNode.setCheckable(false);
                if (visibleFilter.accept(bundleNode)) {
                    rootNode.addChild(bundleNode);
                } else {
                    bundleNode = null;
                }
            }
            if (bundleNode != null) {
                TreeNode productNode = new TreeNode(TYPE_PRODUCT_NODE, String.valueOf(file.getName()) + " (" + file.getParent().getName() + ")", file);
                productNode.setCheckable(checkMode);
                productNode.setBold(true);
                IWorkbenchAdapter wbAdapter = (IWorkbenchAdapter)file.getAdapter(IWorkbenchAdapter.class);
                if (wbAdapter != null) {
                    ImageDescriptor imageDescriptor = wbAdapter.getImageDescriptor((Object)file);
                    productNode.setImage(imageDescriptor);
                }
                if (visibleFilter.accept(productNode)) {
                    bundleNode.addChild(productNode);
                }
            }
            ++n2;
        }
        return rootNode;
    }
}

