/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.dialog;

import org.eclipse.scout.commons.CompareUtility;

public class FontSpec {
    private String m_name;
    private Integer m_style;
    private Integer m_height;

    public FontSpec(FontSpec spec) {
        this.m_name = spec.getName();
        this.m_style = spec.getStyle();
        this.m_height = spec.getHeight();
    }

    public FontSpec() {
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void addStyle(int style) {
        if (this.m_style == null) {
            this.m_style = 0;
        }
        this.m_style = this.m_style | style;
    }

    public void setStyle(Integer style) {
        this.m_style = style;
    }

    public Integer getStyle() {
        return this.m_style;
    }

    public void setHeight(Integer height) {
        this.m_height = height;
    }

    public Integer getHeight() {
        return this.m_height;
    }

    public boolean isDefault() {
        return this.hashCode() == 12345;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FontSpec)) {
            return false;
        }
        FontSpec fontSpec = (FontSpec)obj;
        return CompareUtility.equals((Object)fontSpec.getName(), (Object)this.getName()) && CompareUtility.equals((Object)fontSpec.getStyle(), (Object)this.getStyle()) && CompareUtility.equals((Object)fontSpec.getHeight(), (Object)this.getHeight());
    }

    public int hashCode() {
        int code = 12345;
        if (this.getName() != null) {
            code ^= this.getName().hashCode();
        }
        if (this.getStyle() != null) {
            code ^= this.getStyle().hashCode();
        }
        if (this.getHeight() != null) {
            code ^= this.getHeight().hashCode();
        }
        return code;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("name='");
        if (this.getName() != null) {
            builder.append(String.valueOf(this.getName()) + "'");
        } else {
            builder.append("default'");
        }
        builder.append(" style='");
        if (this.getStyle() != null) {
            builder.append(this.getStyle() + "'");
        } else {
            builder.append("default'");
        }
        builder.append(" size='");
        if (this.getHeight() != null) {
            builder.append(this.getHeight() + "'");
        }
        return builder.toString();
    }
}

