/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions.technology.laf;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.sdk.extensions.runtime.classes.RuntimeClasses;
import org.eclipse.scout.sdk.operation.util.OrganizeImportOperation;
import org.eclipse.scout.sdk.ui.extensions.technology.AbstractScoutTechnologyHandler;
import org.eclipse.scout.sdk.ui.extensions.technology.IScoutTechnologyResource;
import org.eclipse.scout.sdk.ui.extensions.technology.ScoutTechnologyResource;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.util.NamingUtility;
import org.eclipse.scout.sdk.util.log.ScoutStatus;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class RayoUiSwingEnvTechnologyHandler
extends AbstractScoutTechnologyHandler {
    private static final Pattern RAYO_ENV_REGEX = Pattern.compile("public.*class.*extends.*RayoSwingEnvironment.*", 32);

    @Override
    public void selectionChanged(IScoutTechnologyResource[] resources, boolean selected, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        IScoutTechnologyResource[] iScoutTechnologyResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutTechnologyResource res = iScoutTechnologyResourceArray[n2];
            IType swingEnv = this.getType(res.getBundle(), res.getResource());
            this.setSuperClass(swingEnv, selected, monitor, workingCopyManager);
            ++n2;
        }
    }

    private void setSuperClass(IType swingEnv, boolean selected, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        ICompilationUnit cu = swingEnv.getCompilationUnit();
        workingCopyManager.register(cu, monitor);
        String source = cu.getSource();
        Document document = new Document(source);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setIgnoreMethodBodies(true);
        parser.setSource(source.toCharArray());
        CompilationUnit root = (CompilationUnit)parser.createAST(monitor);
        root.recordModifications();
        SimpleType newSuperClassType = null;
        if (selected) {
            newSuperClassType = root.getAST().newSimpleType((Name)root.getAST().newQualifiedName(root.getAST().newName("com.bsiag.scout.rt.ui.swing.rayo"), root.getAST().newSimpleName("RayoSwingEnvironment")));
        } else {
            String fqn = RuntimeClasses.getSuperTypeName((String)"org.eclipse.scout.rt.ui.swing.ISwingEnvironment", (IJavaProject)swingEnv.getJavaProject());
            String className = NamingUtility.getSimpleName((String)fqn);
            String pckName = NamingUtility.getPackage((String)fqn);
            newSuperClassType = root.getAST().newSimpleType((Name)root.getAST().newQualifiedName(root.getAST().newName(pckName), root.getAST().newSimpleName(className)));
        }
        for (Object type : root.types()) {
            if (!(type instanceof TypeDeclaration)) continue;
            TypeDeclaration td = (TypeDeclaration)type;
            td.setSuperclassType((Type)newSuperClassType);
        }
        TextEdit edits = root.rewrite((IDocument)document, cu.getJavaProject().getOptions(true));
        try {
            edits.apply((IDocument)document);
        }
        catch (MalformedTreeException e) {
            throw new CoreException((IStatus)new ScoutStatus((Throwable)e));
        }
        catch (BadLocationException e) {
            throw new CoreException((IStatus)new ScoutStatus((Throwable)e));
        }
        cu.getBuffer().setContents(document.get());
        OrganizeImportOperation o = new OrganizeImportOperation(cu);
        o.validate();
        o.run(monitor, workingCopyManager);
    }

    private IType getType(IScoutBundle bundle, IFile f) {
        IType[] iTypeArray = this.getSwingEnvironments(bundle);
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType candidate = iTypeArray[n2];
            if (candidate.getResource().equals((Object)f)) {
                return candidate;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public TriState getSelection(IScoutBundle project) {
        IType[] swingEnvs = this.getSwingEnvironments(project);
        if (swingEnvs == null || swingEnvs.length == 0) {
            return TriState.FALSE;
        }
        TriState ret = TriState.parseTriState((Object)this.isRayoEnvironment(swingEnvs[0]));
        int i = 1;
        while (i < swingEnvs.length) {
            TriState tmp = TriState.parseTriState((Object)this.isRayoEnvironment(swingEnvs[i]));
            if (ret != tmp) {
                return TriState.UNDEFINED;
            }
            ++i;
        }
        return ret;
    }

    private boolean isRayoEnvironment(IType swingEnv) {
        if (!TypeUtility.exists((IJavaElement)swingEnv)) {
            return false;
        }
        try {
            String source = swingEnv.getSource();
            return RAYO_ENV_REGEX.matcher(source).matches();
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("unable to read source of SwingEnvironment class: " + swingEnv, e);
            return false;
        }
    }

    @Override
    public boolean isActive(IScoutBundle project) {
        return project.getChildBundle(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"UI_SWING"}), false) != null;
    }

    private IType[] getSwingEnvironments(IScoutBundle bundle) {
        IScoutBundle[] swingBundles = bundle.getChildBundles(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"UI_SWING"}), true);
        IType baseType = TypeUtility.getType((String)"org.eclipse.scout.rt.ui.swing.ISwingEnvironment");
        if (TypeUtility.exists((IJavaElement)baseType)) {
            IPrimaryTypeTypeHierarchy hierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)baseType);
            return hierarchy.getAllSubtypes(baseType, ScoutTypeFilters.getTypesInScoutBundles((IScoutBundle[])swingBundles));
        }
        return new IType[0];
    }

    @Override
    protected void contributeResources(IScoutBundle project, List<IScoutTechnologyResource> list) {
        IType[] iTypeArray = this.getSwingEnvironments(project);
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType swingEnvType = iTypeArray[n2];
            IResource res = swingEnvType.getResource();
            if (res.getType() == 1) {
                IFile javaRes = (IFile)res;
                ScoutTechnologyResource tr = new ScoutTechnologyResource(ScoutTypeUtility.getScoutBundle((IJavaElement)swingEnvType.getJavaProject()), javaRes);
                list.add(tr);
            }
            ++n2;
        }
    }
}

